/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.ohf.utilities.xml.XMLWriter;

public class XHTMLWriter
extends XMLWriter {
    public static final String NS_XHTML = "http://www.w3.org/1999/xhtml";
    public static final int NULL_INTEGER = -1;
    private String headerStyle = null;

    public XHTMLWriter(OutputStream stream, String charset) throws UnsupportedEncodingException {
        super(stream, charset);
        this.setPretty(true);
        this.setLineType(1);
    }

    public void start() throws IOException {
        super.start();
        this.defaultNamespace(NS_XHTML);
    }

    public void openDiv(String style) throws IOException {
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        this.open(NS_XHTML, "div");
    }

    public void closeDiv() throws IOException, IOException {
        this.close(NS_XHTML, "div");
    }

    public void openSpan(String style) throws IOException {
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        this.open(NS_XHTML, "span");
    }

    public void closeSpan() throws IOException, IOException {
        this.close(NS_XHTML, "span");
    }

    public void span(String style, String content) throws IOException, IOException {
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        this.element(NS_XHTML, "span", content);
    }

    public void nonBreakingSpace(int count) throws IOException {
        int i = 0;
        while (i < count) {
            this.escapedText("&nbsp;");
            ++i;
        }
    }

    public void paragraph() throws IOException, IOException {
        this.element(NS_XHTML, "p", null);
    }

    public void paragraph(String content) throws IOException, IOException {
        this.element(NS_XHTML, "p", content);
    }

    public void header(int level, String content) throws IOException, IOException {
        if (this.headerStyle != null) {
            this.attribute(NS_XHTML, "style", this.headerStyle);
        }
        this.element(NS_XHTML, "h" + Integer.toString(level), content);
    }

    public void anchor(String url, String content, String style) throws IOException, IOException {
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        this.anchor(url, content);
    }

    public void anchor(String anchor) throws IOException, IOException {
        this.attribute(NS_XHTML, "name", anchor);
        this.element(NS_XHTML, "a", null);
    }

    public void anchor(String url, String content) throws IOException, IOException {
        this.attribute(NS_XHTML, "href", url);
        this.element(NS_XHTML, "a", content);
    }

    public void br() throws IOException, IOException {
        this.element(NS_XHTML, "br", null);
    }

    public void openTable(int border, int padding, int spacing, int width, String style) throws IOException {
        if (border != -1) {
            this.attribute(NS_XHTML, "border", Integer.toString(border));
        }
        if (padding != -1) {
            this.attribute(NS_XHTML, "cellpadding", Integer.toString(border));
        }
        if (spacing != -1) {
            this.attribute(NS_XHTML, "cellspacing", Integer.toString(border));
        }
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        if (width != -1) {
            this.attribute(NS_XHTML, "width", String.valueOf(Integer.toString(width)) + "%");
        }
        this.open(NS_XHTML, "table");
    }

    public void closeTable() throws IOException, IOException {
        this.close(NS_XHTML, "table");
    }

    public void openTableRow(String style) throws IOException {
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        this.open(NS_XHTML, "tr");
    }

    public void openTableRow() throws IOException {
        this.open(NS_XHTML, "tr");
    }

    public void openTableRow(int marker) throws IOException {
        if (marker == -1) {
            this.attribute(NS_XHTML, "style", "font-weight: bold");
        } else if (marker == 1) {
            this.attribute(NS_XHTML, "style", "background-color:#E0E0E0");
        }
        this.open(NS_XHTML, "tr");
    }

    public void closeTableRow() throws IOException, IOException {
        this.close(NS_XHTML, "tr");
    }

    public void openTableCell() throws IOException {
        this.openTableCell(null);
    }

    public void closeTableCell() throws IOException, IOException {
        this.close(NS_XHTML, "td");
    }

    public void openTableCell(String style) throws IOException {
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        this.open(NS_XHTML, "td");
    }

    public void openTableCell(int span, String style) throws IOException {
        this.attribute(NS_XHTML, "colspan", Integer.toString(span));
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        this.open(NS_XHTML, "td");
    }

    public void tableCellSpacer(int count, int colspan) throws IOException, IOException {
        this.tableCellSpacer(null, count, colspan);
    }

    public void tableCellSpacer(int count) throws IOException, IOException {
        this.tableCellSpacer(null, count, -1);
    }

    public void tableCellSpacer(String style, int i) throws IOException, IOException {
        this.tableCellSpacer(style, i, -1);
    }

    public void tableCellSpacer(String style, int i, int colspan) throws IOException, IOException {
        if (colspan != -1) {
            this.attribute(NS_XHTML, "colspan", Integer.toString(colspan));
        }
        this.openTableCell(style);
        this.nonBreakingSpace(i);
        this.close();
    }

    public void tableCell(String content) throws IOException, IOException {
        this.tableCell(null, content);
    }

    public void tableCell(String style, String content, String hint) throws IOException, IOException {
        this.attribute(NS_XHTML, "title", hint);
        this.tableCell(style, content);
    }

    public void tableCell(String style, String content) throws IOException, IOException {
        this.openTableCell(style);
        if (content == null) {
            this.nonBreakingSpace(1);
        } else {
            this.text(content);
        }
        this.close();
    }

    public void openBlockQuote() throws IOException {
        this.open(NS_XHTML, "blockQuote");
    }

    public void closeBlockQuote() throws IOException, IOException {
        this.close(NS_XHTML, "blockQuote");
    }

    public void openList(boolean ordered) throws IOException {
        this.open(NS_XHTML, ordered ? "ol" : "ul");
    }

    public void closeList(boolean ordered) throws IOException, IOException {
        this.close(NS_XHTML, ordered ? "ol" : "ul");
    }

    public void openItem() throws IOException {
        this.open(NS_XHTML, "li");
    }

    public void closeItem() throws IOException, IOException {
        this.close(NS_XHTML, "li");
    }

    public void openHtml() throws IOException {
        this.open(NS_XHTML, "html");
    }

    public void closeHtml() throws IOException, IOException {
        this.close(NS_XHTML, "html");
    }

    public void openHead() throws IOException {
        this.open(NS_XHTML, "head");
    }

    public void closeHead() throws IOException, IOException {
        this.close(NS_XHTML, "head");
    }

    public void title(String title) throws IOException {
        this.element(NS_XHTML, "title", title);
    }

    public void openBody(String style) throws IOException {
        if (style != null) {
            this.attribute(NS_XHTML, "style", style);
        }
        this.open(NS_XHTML, "body");
    }

    public void closeBody() throws IOException, IOException {
        this.close(NS_XHTML, "body");
    }

    public void openFont(String color) throws IOException {
        this.attribute(NS_XHTML, "color", color);
        this.open(NS_XHTML, "font");
    }

    public void closeFont() throws IOException, IOException {
        this.close(NS_XHTML, "font");
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public void setHeaderStyle(String headerStyle) {
        this.headerStyle = headerStyle;
    }

    public void image(String source) throws IOException {
        this.attribute(NS_XHTML, "src", source);
        this.element(NS_XHTML, "img", null);
    }

    public void object(String source, String type, String altText, int width, int height) throws IOException {
        this.attribute(NS_XHTML, "data", source);
        this.attribute(NS_XHTML, "type", type);
        this.attribute(NS_XHTML, "width", Integer.toString(width));
        this.attribute(NS_XHTML, "height", Integer.toString(height));
        this.element(NS_XHTML, "object", altText);
    }

    public void hr(int i) throws IOException {
        this.attribute(NS_XHTML, "width", String.valueOf(Integer.toString(i)) + "%");
        this.element(NS_XHTML, "hr", null);
    }

    public void openParagraph() throws IOException {
        this.open(NS_XHTML, "p");
    }

    public void closeParagraph() throws IOException, IOException {
        this.close(NS_XHTML, "p");
    }

    public void openBold() throws IOException {
        this.open(NS_XHTML, "b");
    }

    public void closeBold() throws IOException, IOException {
        this.close(NS_XHTML, "b");
    }

    public void openItalic() throws IOException {
        this.open(NS_XHTML, "i");
    }

    public void closeItalic() throws IOException, IOException {
        this.close(NS_XHTML, "i");
    }

    public void anchorDest(String id) throws IOException {
        this.attribute(NS_XHTML, "name", id);
        this.element(NS_XHTML, "a", null);
    }
}

