/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.codes;

import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;

public class AuditEventID
extends CodedValueType {
    protected AuditEventID(String value, String meaning) {
        this.setCodeSystemName("DCM");
        this.setCode(value);
        this.setDisplayName(meaning);
    }

    public static final class ApplicationActivity
    extends AuditEventID {
        public ApplicationActivity() {
            super("110100", "Application Activity");
        }
    }

    public static class AuditLogUsed
    extends AuditEventID {
        public AuditLogUsed() {
            super("110101", "Audit Log Used");
        }
    }

    public static class BeginTransferringDICOMInstances
    extends AuditEventID {
        public BeginTransferringDICOMInstances() {
            super("110102", "Being Transfering DICOM Instances");
        }
    }

    public static class DICOMInstancesAccessed
    extends AuditEventID {
        public DICOMInstancesAccessed() {
            super("110103", "DICOM Instances Accessed");
        }
    }

    public static class DICOMInstancesTransferred
    extends AuditEventID {
        public DICOMInstancesTransferred() {
            super("110104", "DICOM Instances Transferred");
        }
    }

    public static class DICOMStudyDeleted
    extends AuditEventID {
        public DICOMStudyDeleted() {
            super("110105", "DICOM Study Deleted");
        }
    }

    public static class Export
    extends AuditEventID {
        public Export() {
            super("110106", "Export");
        }
    }

    public static class Import
    extends AuditEventID {
        public Import() {
            super("110107", "Import");
        }
    }

    public static class NetworkActivity
    extends AuditEventID {
        public NetworkActivity() {
            super("110108", "Network Activity");
        }
    }

    public static class OrderRecord
    extends AuditEventID {
        public OrderRecord() {
            super("110109", "Order Record");
        }
    }

    public static class PatientRecord
    extends AuditEventID {
        public PatientRecord() {
            super("110110", "Patient Record");
        }
    }

    public static class ProceedureRecord
    extends AuditEventID {
        public ProceedureRecord() {
            super("110111", "Proceedure Record");
        }
    }

    public static class Query
    extends AuditEventID {
        public Query() {
            super("110112", "Query");
        }
    }

    public static class SecurityAlert
    extends AuditEventID {
        public SecurityAlert() {
            super("110113", "Security Alert");
        }
    }

    public static class UserAuthentication
    extends AuditEventID {
        public UserAuthentication() {
            super("110114", "User Authentication");
        }
    }
}

