/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.syslog.bsd;

import java.net.InetAddress;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.audit.syslog.util.TimeStamp;

public class BSDMessage {
    static final Logger mLogger = Logger.getLogger(BSDMessage.class);
    int priority;
    TimeStamp timeStamp;
    InetAddress toIp;
    String FQDN;
    String tag;
    String message;

    public BSDMessage(int priority, TimeStamp timeStamp, InetAddress toIP, String tag, String message) {
        this.priority = priority;
        this.timeStamp = timeStamp;
        this.toIp = toIP;
        this.FQDN = null;
        this.tag = tag;
        this.message = message;
    }

    public BSDMessage(int priority, TimeStamp timeStamp, String FQDN, String tag, String message) {
        this.priority = priority;
        this.timeStamp = timeStamp;
        this.FQDN = FQDN;
        this.toIp = null;
        this.tag = tag;
        this.message = message;
    }

    public BSDMessage(TimeStamp timeStamp, String FQDN, String tag, String message) {
        this.priority = 13;
        this.timeStamp = timeStamp;
        this.FQDN = FQDN;
        this.toIp = null;
        this.tag = tag;
        this.message = message;
    }

    public BSDMessage(TimeStamp timeStamp, InetAddress toIP, String tag, String message) {
        this.priority = 13;
        this.timeStamp = timeStamp;
        this.toIp = toIP;
        this.FQDN = null;
        this.tag = tag;
        this.message = message;
    }

    public BSDMessage(InetAddress toIP, String tag, String message) {
        this.priority = 13;
        this.timeStamp = new TimeStamp();
        this.toIp = toIP;
        this.FQDN = null;
        this.tag = tag;
        this.message = message;
    }

    public BSDMessage(String FQDN, String tag, String message) {
        this.priority = 13;
        this.timeStamp = new TimeStamp();
        this.FQDN = FQDN;
        this.toIp = null;
        this.tag = tag;
        this.message = message;
    }

    public String toString() {
        try {
            if (this.toIp == null && this.FQDN == null) {
                throw new Exception("IP and FQDN are null");
            }
            String auditMessage = "<" + this.priority + ">" + this.timeStamp.toString() + " " + (this.toIp != null ? this.toIp.getHostAddress() : (this.FQDN != null ? this.FQDN : "")) + " " + this.tag + this.message;
            return auditMessage;
        }
        catch (Exception e) {
            mLogger.error((Object)e.getMessage());
            return null;
        }
    }

    public String getFQDN() {
        return this.FQDN;
    }

    public String getMessage() {
        return this.message;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getTag() {
        return this.tag;
    }

    public TimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    public InetAddress getToIp() {
        return this.toIp;
    }
}

