/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.mllp;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgent;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.common.mllp.MLLPException;
import org.eclipse.ohf.ihe.common.mllp.SecureTCPPort;
import org.eclipse.ohf.ihe.common.mllp.TCPPort;

public class MLLPDestination {
    private static final Logger logger = Logger.getLogger(MLLPDestination.class);
    private TCPPort port;
    private char[] sHex;
    private char[] eHex;
    private Socket targetSocket;
    private int MAX_RETRY_COUNT = 3;
    private int RETRY_WAIT = 2000;
    private static final String ERROR_RESP = "err";
    private URI uri = null;
    private static boolean USE_ATNA = true;
    private AtnaAgent atnaAgent = null;

    public MLLPDestination(TCPPort destination) {
        this.port = destination;
        char[] sHex = new char[]{'\u000b'};
        char[] eHex = new char[]{'\u001c', '\r'};
        this.port.setStartHex(sHex);
        this.port.setEndHex(eHex);
        this.sHex = this.port.getStartHex();
        this.eHex = this.port.getEndHex();
        this.targetSocket = null;
        String scheme = "mllp";
        if (destination instanceof SecureTCPPort) {
            scheme = "mllps";
        }
        try {
            this.uri = new URI(scheme, null, destination.getTcpHost(), destination.getTcpPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Problem constructing URI. " + e.getLocalizedMessage()));
        }
    }

    public MLLPDestination(String tcpHost, int tcpPort) {
        this.port = new TCPPort();
        this.port.setTcpHost(tcpHost);
        this.port.setTcpPort(tcpPort);
        char[] sHex = new char[]{'\u000b'};
        char[] eHex = new char[]{'\u001c', '\r'};
        this.port.setStartHex(sHex);
        this.port.setEndHex(eHex);
        this.sHex = this.port.getStartHex();
        this.eHex = this.port.getEndHex();
        this.targetSocket = null;
        logger.info((Object)"Forcing use of unsecure mllp. If this is not want was expected, use a different constructor");
        try {
            this.uri = new URI("mllp", null, tcpHost, tcpPort, null, null, null);
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Problem constructing URI. " + e.getLocalizedMessage()));
        }
    }

    public MLLPDestination(URI uri) {
        this.uri = uri;
        if (uri.getScheme().equalsIgnoreCase("mllp")) {
            this.port = new TCPPort();
        } else if (uri.getScheme().equalsIgnoreCase("mllps")) {
            this.port = new SecureTCPPort();
        } else {
            logger.error((Object)("URI for MLLP is does not contain a valid protocol. Expected either mllp or mllps instead got: " + uri.getScheme()));
            throw new IllegalArgumentException("URI contained an invalid protocol: " + uri.getScheme());
        }
        this.port.setTcpHost(uri.getHost());
        this.port.setTcpPort(uri.getPort());
        char[] sHex = new char[]{'\u000b'};
        char[] eHex = new char[]{'\u001c', '\r'};
        this.port.setStartHex(sHex);
        this.port.setEndHex(eHex);
        this.sHex = this.port.getStartHex();
        this.eHex = this.port.getEndHex();
        this.targetSocket = null;
    }

    public int getMaxRetry() {
        return this.MAX_RETRY_COUNT;
    }

    public void setMaxRetry(int retryCount) {
        this.MAX_RETRY_COUNT = retryCount;
    }

    public int getRetryWait() {
        return this.RETRY_WAIT;
    }

    public void setRetryWait(int retryWait) {
        this.RETRY_WAIT = retryWait;
    }

    public URI getURI() {
        return this.uri;
    }

    public String sendMessage(String msg) throws MLLPException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MLLPDestination: sendMessage - Entry ");
        }
        String respMsg = null;
        this.targetSocket = null;
        try {
            try {
                if (USE_ATNA) {
                    boolean useTLS = this.uri.getScheme().equalsIgnoreCase("mllps");
                    this.targetSocket = this.getAtnaAgent().getSocket(this.uri, useTLS);
                } else {
                    this.targetSocket = this.port instanceof SecureTCPPort ? this.createSecureSocket((SecureTCPPort)this.port) : this.createSocket(this.port);
                }
                if (this.targetSocket == null) {
                    logger.error((Object)"Unable to create socket connection needed to deliver message");
                    throw new MLLPException("Unable to create socket connection ", 0);
                }
                logger.info((Object)("*** Sending message to " + this.port.getTcpHost() + " on port " + this.port.getTcpPort() + "\n" + msg));
                respMsg = this.sendMessage(this.targetSocket, msg, this.port);
                logger.info((Object)("*** Response from " + this.port.getTcpHost() + " on port " + this.port.getTcpPort() + " was:\n" + respMsg));
            }
            catch (Throwable th) {
                logger.error((Object)("Encountered unexpected error. " + th.getLocalizedMessage()), th);
                throw new MLLPException("Unexpected error ", 1, th);
            }
        }
        finally {
            if (this.targetSocket != null) {
                try {
                    this.targetSocket.close();
                }
                catch (IOException e) {
                    logger.error((Object)("Error closing socket associated with port " + this.port.toString()), (Throwable)e);
                    throw new MLLPException("Error closing socket ", 2, e);
                }
                this.targetSocket = null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MLLPDestination: sendMessage - Exit");
        }
        return respMsg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendMessage(Socket socket, String msg, TCPPort tcpp) throws MLLPException {
        String respondMsg;
        block17: {
            respondMsg = null;
            BufferedReader fromServer = null;
            PrintWriter toServer = null;
            try {
                fromServer = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            }
            catch (IOException e) {
                logger.error((Object)("Unable to get input stream for communication to " + tcpp.getTcpHost() + ":" + tcpp.getTcpPort()), (Throwable)e);
                respondMsg = ERROR_RESP;
            }
            if (respondMsg == null) {
                try {
                    toServer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
                }
                catch (IOException e) {
                    logger.error((Object)("Unable to get output stream for communication to " + tcpp.getTcpHost() + ":" + tcpp.getTcpPort()), (Throwable)e);
                    respondMsg = ERROR_RESP;
                }
            }
            if (respondMsg == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sending the server: " + this.addEnvelope(msg)));
                }
                toServer.print(this.addEnvelope(msg));
                toServer.flush();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"done sending the message to the server");
                }
                char[] buf = new char[tcpp.getBufferSize()];
                StringBuffer sb = new StringBuffer();
                try {
                    int readLength = -1;
                    try {
                        readLength = fromServer.read(buf, 0, buf.length);
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Warning - exception thrown during server response read sometimes due to the server closing the socket.");
                        logger.warn((Object)"Warning - will attempt to continue under assumption that response was received.");
                        logger.warn((Object)"  If it was not, your guess is as good as mine as to where subsequent code will break based on bad input.");
                        logger.warn((Object)("  Buffer length " + buf.length + " message " + buf.toString() + " received prior to exception."));
                        logger.warn((Object)e);
                    }
                    if (readLength == -1) {
                        logger.error((Object)"did not read any byte from the server");
                        respondMsg = ERROR_RESP;
                        break block17;
                    }
                    while (readLength != -1) {
                        sb.append(buf, 0, readLength);
                        if (this.endOfMessageFound(sb)) break;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"End of message not found. Doing another read to receive rest of message");
                        }
                        readLength = fromServer.read(buf, 0, buf.length);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("buffer length " + buf.length));
                        logger.debug((Object)("readLength= " + readLength));
                        logger.debug((Object)("got: " + String.valueOf(buf[buf.length - 1])));
                    }
                    respondMsg = this.checkStripEnvelope(sb);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Response was: " + respondMsg));
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Error reading data from " + tcpp.toString()), (Throwable)e);
                    respondMsg = ERROR_RESP;
                    throw new MLLPException("Error sending message ", 3, e);
                }
            }
        }
        if (respondMsg == ERROR_RESP) {
            throw new MLLPException("Error sending message ", 3);
        }
        return respondMsg;
    }

    private boolean endOfMessageFound(StringBuffer sb) {
        if (sb.length() < this.eHex.length) {
            return false;
        }
        int x = sb.length() - this.eHex.length;
        int y = 0;
        while (y < this.eHex.length) {
            if (sb.charAt(x) != this.eHex[y]) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Ending character sequence not found in message");
                }
                return false;
            }
            ++x;
            ++y;
        }
        return true;
    }

    private SSLSocket createSecureSocket(SecureTCPPort tcpp) throws MLLPException {
        TrustManagerFactory tfact;
        KeyManagerFactory kfact;
        FileInputStream is;
        SSLSocket s = null;
        int retries = 0;
        SSLContext sslc = null;
        String sslPName = null;
        String sslPClass = null;
        try {
            sslPName = tcpp.getSslProviderName();
            sslPClass = tcpp.getSslProviderClass();
            if (sslPName != null && sslPName.length() > 0 && sslPClass != null && sslPClass.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Registering " + sslPName + " provider for " + tcpp.getProtocol() + " protocol"));
                }
                Security.setProperty("security.provider.1", sslPClass);
                sslc = SSLContext.getInstance(tcpp.getProtocol(), sslPName);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using default provider for " + tcpp.getProtocol() + " protocol"));
                }
                sslc = SSLContext.getInstance(tcpp.getProtocol());
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("Requested secure socket provider " + sslPName + " is not supported"), (Throwable)e);
            throw new MLLPException("Secure socket provider not supported ", 4);
        }
        catch (NoSuchProviderException e) {
            logger.error((Object)("Error registering provider for secure socket " + sslPName), (Throwable)e);
            throw new MLLPException("Error registering provider for secure socket ", 4);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SSLContext provider is: " + sslc.getProvider().toString()));
            logger.debug((Object)("Default key manager algorithm is : " + KeyManagerFactory.getDefaultAlgorithm()));
        }
        try {
            is = new FileInputStream(tcpp.getKeyStoreName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            is = null;
        }
        String keyStorePass = tcpp.getKeyStorePassword();
        if (is == null) {
            logger.error((Object)("Unable to find certificate store " + tcpp.getKeyStoreName() + " on classpath"));
            throw new MLLPException("Secure socket unable to find certificate store ", 4);
        }
        try {
            kfact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore kstore = KeyStore.getInstance(KeyStore.getDefaultType());
            kstore.load(is, keyStorePass.toCharArray());
            kfact.init(kstore, keyStorePass.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("Algorithm " + KeyManagerFactory.getDefaultAlgorithm() + " is not supported"), (Throwable)e);
            throw new MLLPException("Secure socket algorithm not supported ", 4);
        }
        catch (KeyStoreException e) {
            logger.error((Object)("Keystore of type " + KeyStore.getDefaultType() + " is not supported"), (Throwable)e);
            throw new MLLPException("Secure socket keystore not supported ", 4);
        }
        catch (CertificateException e) {
            logger.error((Object)("Error loading key store " + tcpp.getKeyStoreName()), (Throwable)e);
            throw new MLLPException("Secure socket error loading key store ", 4);
        }
        catch (IOException e) {
            logger.error((Object)("Error loading key store " + tcpp.getKeyStoreName()), (Throwable)e);
            throw new MLLPException("Secure socket error loading key store ", 4);
        }
        catch (UnrecoverableKeyException e) {
            logger.error((Object)("Error loading key store " + tcpp.getKeyStoreName()), (Throwable)e);
            throw new MLLPException("Secure socket error loading key store ", 4);
        }
        try {
            is = new FileInputStream(tcpp.getTrustStoreName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            is = null;
        }
        String trustStorePass = tcpp.getTrustStorePassword();
        if (is == null) {
            logger.error((Object)("Unable to find trust store " + tcpp.getTrustStoreName() + " on classpath"));
            throw new MLLPException("Secure socket unable to find trust store ", 4);
        }
        try {
            tfact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore tstore = KeyStore.getInstance(KeyStore.getDefaultType());
            tstore.load(is, trustStorePass.toCharArray());
            tfact.init(tstore);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("Error loading trust store " + tcpp.getTrustStoreName()), (Throwable)e);
            throw new MLLPException("Secure socket error loading trust store ", 4);
        }
        catch (KeyStoreException e) {
            logger.error((Object)("Error loading trust store " + tcpp.getTrustStoreName()), (Throwable)e);
            throw new MLLPException("Secure socket error loading trust store ", 4);
        }
        catch (CertificateException e) {
            logger.error((Object)("Error loading trust store " + tcpp.getTrustStoreName()), (Throwable)e);
            throw new MLLPException("Secure socket error loading trust store ", 4);
        }
        catch (IOException e) {
            logger.error((Object)("Error loading trust store " + tcpp.getTrustStoreName()), (Throwable)e);
            throw new MLLPException("Secure socket error loading trust store ", 4);
        }
        try {
            sslc.init(kfact.getKeyManagers(), tfact.getTrustManagers(), null);
        }
        catch (KeyManagementException e) {
            logger.error((Object)"Error initializing key management infrastructure", (Throwable)e);
            throw new MLLPException("Secure socket error initializing key management ", 4);
        }
        SSLSocketFactory sslFact = sslc.getSocketFactory();
        if (logger.isDebugEnabled()) {
            String[] csuites = sslFact.getDefaultCipherSuites();
            logger.debug((Object)("Cipher suites for " + sslFact.getClass().getName() + " are: "));
            int i = 0;
            while (i < csuites.length) {
                logger.debug((Object)("\t" + csuites[i]));
                ++i;
            }
        }
        while (retries < this.MAX_RETRY_COUNT) {
            try {
                s = (SSLSocket)sslFact.createSocket(tcpp.getTcpHost(), tcpp.getTcpPort());
                s.setSoTimeout(tcpp.getSocketTimeoutMS());
                s.setKeepAlive(true);
                ArrayList suiteList = new ArrayList();
                if (suiteList != null && suiteList.size() > 0) {
                    String[] enabledSuites = new String[suiteList.size()];
                    int i = 0;
                    while (i < enabledSuites.length) {
                        enabledSuites[i] = (String)suiteList.get(i);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Enabling cipher suite: " + enabledSuites[i]));
                        }
                        ++i;
                    }
                    s.setEnabledCipherSuites(enabledSuites);
                }
                s.startHandshake();
                break;
            }
            catch (SSLHandshakeException he) {
                logger.error((Object)("Handshake failed with server " + tcpp.toString()), (Throwable)he);
                try {
                    s.close();
                }
                catch (IOException e1) {
                    logger.error((Object)("Error trying to close socket for " + tcpp.toString()), (Throwable)e1);
                }
                throw new MLLPException("Secure socket handshake failed ", 4);
            }
            catch (UnknownHostException e) {
                logger.error((Object)("Unable to establish connection to " + tcpp.getTcpHost() + " " + tcpp.getTcpPort()), (Throwable)e);
                throw new MLLPException("Secure socket connection failed ", 4);
            }
            catch (SocketException e) {
                logger.error((Object)("Error connecting to " + tcpp.getTcpHost() + " " + tcpp.getTcpPort() + ". Will retry in " + this.RETRY_WAIT / 1000 + " seconds."), (Throwable)e);
                try {
                    Thread.sleep(this.RETRY_WAIT);
                    ++retries;
                }
                catch (InterruptedException interruptedException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Sleep awoken early");
                    }
                    ++retries;
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error connecting to " + tcpp.getTcpHost() + " " + tcpp.getTcpPort() + ". Will retry in " + this.RETRY_WAIT / 1000 + " seconds."), (Throwable)e);
                ++retries;
            }
        }
        if (retries > this.MAX_RETRY_COUNT) {
            throw new MLLPException("Secure socket retries exhausted ", 4);
        }
        return s;
    }

    private Socket createSocket(TCPPort tcpp) throws MLLPException {
        Socket s = null;
        int retries = 0;
        while (retries < this.MAX_RETRY_COUNT) {
            try {
                s = new Socket(tcpp.getTcpHost(), tcpp.getTcpPort());
                s.setSoTimeout(tcpp.getSocketTimeoutMS());
                s.setKeepAlive(true);
                break;
            }
            catch (UnknownHostException e) {
                logger.error((Object)("Unable to establish connection to " + tcpp.getTcpHost() + " " + tcpp.getTcpPort()), (Throwable)e);
                break;
            }
            catch (SocketException e) {
                logger.error((Object)("Error connecting to " + tcpp.getTcpHost() + " " + tcpp.getTcpPort() + ". Will retry in " + this.RETRY_WAIT / 1000 + " seconds."), (Throwable)e);
                try {
                    Thread.sleep(this.RETRY_WAIT);
                    ++retries;
                }
                catch (InterruptedException interruptedException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Sleep awoken early");
                    }
                    ++retries;
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error connecting to " + tcpp.getTcpHost() + " " + tcpp.getTcpPort() + ". Will retry in " + this.RETRY_WAIT / 1000 + " seconds."), (Throwable)e);
                ++retries;
            }
        }
        if (retries > this.MAX_RETRY_COUNT) {
            throw new MLLPException("Socket retries exhausted ", 5);
        }
        return s;
    }

    private String addEnvelope(String msg) {
        StringBuffer sb = new StringBuffer(msg.length() + this.sHex.length + this.eHex.length);
        int x = 0;
        while (x < this.sHex.length) {
            sb.append(this.sHex[x]);
            ++x;
        }
        sb.append(msg);
        x = 0;
        while (x < this.eHex.length) {
            sb.append(this.eHex[x]);
            ++x;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sb.toString());
        }
        return sb.toString();
    }

    private String checkStripEnvelope(StringBuffer msg) {
        int msgLen = msg.length();
        int x = 0;
        while (x < this.sHex.length) {
            if (msg.charAt(x) != this.sHex[x]) {
                logger.fatal((Object)("Message format error. Start envelope char " + msg.charAt(x) + " did not match the configuration parameter " + this.sHex[x]));
                return ERROR_RESP;
            }
            ++x;
        }
        x = msgLen - this.eHex.length;
        int y = 0;
        while (x < msgLen) {
            if (msg.charAt(x) != this.eHex[y]) {
                logger.fatal((Object)("Message format error. End envelope char at " + msg.charAt(x) + " did not match the configuration parameter " + this.eHex[y]));
                return ERROR_RESP;
            }
            ++x;
            ++y;
        }
        return msg.substring(this.sHex.length, msgLen - this.eHex.length);
    }

    private AtnaAgent getAtnaAgent() {
        if (this.atnaAgent == null) {
            this.atnaAgent = AtnaAgentFactory.getAtnaAgent();
        }
        return this.atnaAgent;
    }

    public static boolean getUseATNA() {
        return USE_ATNA;
    }

    public static void setUseATNA(boolean atna) {
        USE_ATNA = atna;
    }
}

