/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.util.RimResourceFactoryImpl;
import org.eclipse.ohf.ihe.xds.metadata.FolderType;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1FolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.FolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;

public class EbXML_2_1InputStreamFolderExtractor
implements FolderExtractor {
    public static final String DESCRIPTOR = "EBXML_STREAM_FOL_EXTR";
    private static final Logger logger = Logger.getLogger(EbXML_2_1InputStreamFolderExtractor.class);
    private InputStream ebXMLFolderInputStream;

    public EbXML_2_1InputStreamFolderExtractor(InputStream ebXMLFolderInputStream) {
        this.ebXMLFolderInputStream = ebXMLFolderInputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FolderType extract() throws MetadataExtractionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading RimPackage.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading Resources.");
        }
        Resource resource = new RimResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:rim:xsd:2.1"));
        try {
            resource.load(this.ebXMLFolderInputStream, null);
        }
        catch (IOException e) {
            logger.error((Object)"IOException while loading Resources from InputStream.", (Throwable)e);
            throw new MetadataExtractionException("IOException while loading Resources from InputStream.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Parsing ebXML InputStream contents.");
        }
        EList list = resource.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        RegistryPackageType folderData = null;
        AssociationType1[] associationData = null;
        if (root.getRegistryPackage() != null) {
            folderData = root.getRegistryPackage();
        } else {
            if (root.getLeafRegistryObjectList() == null) {
                logger.error((Object)"Malformed InputStream: InputStream must contain a single RegistryPackage or a single LeafRegistryObjectList containing a single RegistryPackage and one or more Associations. Extraction cannot proceed.");
                throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single RegistryPackage or a single LeafRegistryObjectList containing a single RegistryPackage and one or more Associations. Extraction cannot proceed.");
            }
            if (!root.getLeafRegistryObjectList().getExtrinsicObject().isEmpty()) {
                folderData = (RegistryPackageType)root.getLeafRegistryObjectList().getRegistryPackage().get(0);
                if (root.getLeafRegistryObjectList().getAssociation().isEmpty()) {
                    logger.error((Object)"Malformed InputStream: InputStream must contain a single RegistryPackage or a single LeafRegistryObjectList containing a single RegistryPackage and one or more Associations. Extraction cannot proceed.");
                    throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single RegistryPackage or a single LeafRegistryObjectList containing a single RegistryPackage and one or more Associations. Extraction cannot proceed.");
                }
                EList assocs = root.getLeafRegistryObjectList().getAssociation();
                associationData = new AssociationType1[assocs.size()];
                int i = 0;
                while (i < associationData.length) {
                    associationData[i] = (AssociationType1)assocs.get(i);
                    ++i;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating Folder metadata with object from InputStream " + this.ebXMLFolderInputStream));
        }
        EbXML_2_1FolderExtractor fExtractor = new EbXML_2_1FolderExtractor(folderData, associationData);
        FolderType folder = fExtractor.extract();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Unloading Resources.");
        }
        resource.unload();
        return folder;
    }
}

