/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.SubmitObjectsRequestType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.util.RegistryResourceFactoryImpl;
import org.eclipse.ohf.ihe.xds.metadata.ProvideAndRegisterDocumentSetType;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1ProvideAndRegisterDocumentSetExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.extract.ProvideAndRegisterDocumentSetExtractor;

public class EbXML_2_1InputStreamProvideAndRegisterDocumentSetExtractor
implements ProvideAndRegisterDocumentSetExtractor {
    public static final String DESCRIPTOR = "EBXML_STREAM_PRDS_EXTR";
    private static final Logger logger = Logger.getLogger(EbXML_2_1InputStreamProvideAndRegisterDocumentSetExtractor.class);
    private InputStream ebXMLmetadataInputStream;

    public EbXML_2_1InputStreamProvideAndRegisterDocumentSetExtractor(InputStream ebXMLmetadataInputStream) {
        this.ebXMLmetadataInputStream = ebXMLmetadataInputStream;
    }

    public ProvideAndRegisterDocumentSetType extract() throws MetadataExtractionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading RegistryPackage.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading Resources.");
        }
        Resource resource = new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
        try {
            resource.load(this.ebXMLmetadataInputStream, null);
        }
        catch (IOException e) {
            logger.error((Object)"IOException while loading Resources from InputStream.", (Throwable)e);
            throw new MetadataExtractionException("IOException while loading Resources from InputStream.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Parsing ebXML InputStream contents.");
        }
        EList list = resource.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        SubmitObjectsRequestType metadata = null;
        if (root.getSubmitObjectsRequest() == null) {
            logger.error((Object)"Malformed InputStream: InputStream must contain a single SubmitObjectsRequest.Extraction cannot proceed.");
            throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single SubmitObjectsRequest.Extraction cannot proceed.");
        }
        metadata = root.getSubmitObjectsRequest();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating entire metadata with object from InputStream " + this.ebXMLmetadataInputStream));
        }
        EbXML_2_1ProvideAndRegisterDocumentSetExtractor prsExtractor = new EbXML_2_1ProvideAndRegisterDocumentSetExtractor(metadata);
        ProvideAndRegisterDocumentSetType meta = prsExtractor.extract();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Unloading Resources.");
        }
        resource.unload();
        return meta;
    }
}

