/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.xds.metadata.DocumentRoot;
import org.eclipse.ohf.ihe.xds.metadata.FolderType;
import org.eclipse.ohf.ihe.xds.metadata.extract.FolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.util.MetadataResourceFactoryImpl;

public class InputStreamFolderExtractor
implements FolderExtractor {
    public static final String DESCRIPTOR = "STREAM_FOL_EXTR";
    private static final Logger logger = Logger.getLogger(InputStreamFolderExtractor.class);
    private InputStream folderInputStream;

    public InputStreamFolderExtractor(InputStream folderInputStream) {
        this.folderInputStream = folderInputStream;
    }

    public FolderType extract() throws MetadataExtractionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading MetadataPackage.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading Resources.");
        }
        Resource resource = new MetadataResourceFactoryImpl().createResource(URI.createURI((String)"urn:org:eclipse:ohf:ihe:xds:metadata"));
        try {
            resource.load(this.folderInputStream, null);
        }
        catch (IOException e) {
            logger.error((Object)"IOException while loading Resources from InputStream.", (Throwable)e);
            throw new MetadataExtractionException("IOException while loading Resources from InputStream.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating Folder metadata with object from InputStream " + this.folderInputStream));
        }
        EList list = resource.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        FolderType folder = root.getFolder();
        return folder;
    }
}

