/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract.cdar2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.ohf.ihe.common.cdar2.AD;
import org.eclipse.ohf.ihe.common.cdar2.ADXP;
import org.eclipse.ohf.ihe.common.cdar2.CD;
import org.eclipse.ohf.ihe.common.cdar2.CE;
import org.eclipse.ohf.ihe.common.cdar2.ENXP;
import org.eclipse.ohf.ihe.common.cdar2.II;
import org.eclipse.ohf.ihe.common.cdar2.IVLTS;
import org.eclipse.ohf.ihe.common.cdar2.ON;
import org.eclipse.ohf.ihe.common.cdar2.PN;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedEntity;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040EncompassingEncounter;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040HealthCareFacility;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Location;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Organization;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent;
import org.eclipse.ohf.ihe.common.cdar2.TEL;
import org.eclipse.ohf.ihe.common.cdar2.TS1;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.Hl7v2Factory;
import org.eclipse.ohf.ihe.common.hl7v2.SourcePatientInfoType;
import org.eclipse.ohf.ihe.common.hl7v2.XAD;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.common.hl7v2.XON;
import org.eclipse.ohf.ihe.common.hl7v2.XPN;
import org.eclipse.ohf.ihe.common.hl7v2.XTN;
import org.eclipse.ohf.ihe.xds.metadata.AuthorType;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.ParentDocumentRelationshipType;
import org.eclipse.ohf.ihe.xds.metadata.extract.DocumentEntryElementExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.extract.cdar2.AdministrativeGender;
import org.eclipse.ohf.ihe.xds.metadata.impl.MetadataFactoryImpl;

public class CDAR2Extractor
implements DocumentEntryExtractor,
DocumentEntryElementExtractor {
    public static final String DESCRIPTOR = "CDAR2_DE_EXTR";
    private static Logger logger = Logger.getLogger(CDAR2Extractor.class);
    public static final HashMap ADMIN_GENDER_TABLE_001 = new HashMap();
    protected POCDMT000040ClinicalDocument cda;

    static {
        ADMIN_GENDER_TABLE_001.put(AdministrativeGender.M_LITERAL.getName(), "M");
        ADMIN_GENDER_TABLE_001.put(AdministrativeGender.F_LITERAL.getName(), "F");
        ADMIN_GENDER_TABLE_001.put(AdministrativeGender.UN_LITERAL.getName(), "O");
    }

    public CDAR2Extractor(POCDMT000040ClinicalDocument cda) {
        this.cda = cda;
    }

    public DocumentEntryType extract() throws MetadataExtractionException {
        String uniqueId;
        CodedMetadataType typeCode;
        InternationalStringType title;
        SourcePatientInfoType patientInfo;
        CX sourcePatientId;
        String stopTime;
        String startTime;
        XCN legalAuth;
        String langCode;
        CodedMetadataType psc;
        CodedMetadataType hcfc;
        String creationTime;
        CodedMetadataType confidentialityCode;
        CodedMetadataType classCode;
        AuthorType[] authors;
        logger.info((Object)"BEGIN CDAR2Extractor.extract()");
        if (this.cda == null) {
            logger.error((Object)"CDA is null, cannot execute extraction.");
            throw new MetadataExtractionException("CDA is null, cannot execute extraction.");
        }
        DocumentEntryType docEntry = MetadataFactoryImpl.eINSTANCE.createDocumentEntryType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.author(s)");
        }
        if ((authors = this.extractAuthors()) != null) {
            int i = 0;
            while (i < authors.length) {
                docEntry.getAuthor().add((Object)authors[i]);
                ++i;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.classCode");
        }
        if ((classCode = this.extractClassCode()) != null) {
            docEntry.setClassCode(classCode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.confidentialityCode");
        }
        if ((confidentialityCode = this.extractConfidentialityCode()) != null) {
            docEntry.setConfidentialityCode(confidentialityCode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.creationTime");
        }
        if ((creationTime = this.extractCreationTime()) != null) {
            docEntry.setCreationTime(creationTime);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.healthcareFacilityCode");
        }
        if ((hcfc = this.extractHealthCareFacilityTypeCode()) != null) {
            docEntry.setHealthCareFacilityTypeCode(hcfc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.practiceSettingCode");
        }
        if ((psc = this.extractPracticeSettingCode()) != null) {
            docEntry.setPracticeSettingCode(psc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.languageCode");
        }
        if ((langCode = this.extractLanguageCode()) != null) {
            docEntry.setLanguageCode(langCode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.legalAuthenticator");
        }
        if ((legalAuth = this.extractLegalAuthenticator()) != null) {
            docEntry.setLegalAuthenticator(legalAuth);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.serviceStartTime");
        }
        if ((startTime = this.extractServiceStartTime()) != null) {
            docEntry.setServiceStartTime(startTime);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.serviceStopTime");
        }
        if ((stopTime = this.extractServiceStopTime()) != null) {
            docEntry.setServiceStopTime(stopTime);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.sourcePatientId");
        }
        if ((sourcePatientId = this.extractSourcePatientId()) != null) {
            docEntry.setSourcePatientId(sourcePatientId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.sourcePatientInfo");
        }
        if ((patientInfo = this.extractSourcePatientInfo()) != null) {
            docEntry.setSourcePatientInfo(patientInfo);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.title");
        }
        if ((title = this.extractTitle()) != null) {
            docEntry.setTitle(title);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.typeCode");
        }
        if ((typeCode = this.extractTypeCode()) != null) {
            docEntry.setTypeCode(typeCode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.uniqueId");
        }
        if ((uniqueId = this.extractUniqueId()) != null) {
            docEntry.setUniqueId(uniqueId);
        }
        logger.info((Object)"DONE");
        return docEntry;
    }

    public AuthorType[] extractAuthors() {
        if (!this.atLeastOne((List)this.cda.getAuthor())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName()));
            }
            return null;
        }
        Iterator i = this.cda.getAuthor().iterator();
        ArrayList<AuthorType> authorList = new ArrayList<AuthorType>();
        while (i.hasNext()) {
            POCDMT000040AssignedAuthor aAuth;
            POCDMT000040Author author = (POCDMT000040Author)i.next();
            AuthorType aut = MetadataFactory.eINSTANCE.createAuthorType();
            String role = this.extractAuthorRole(author.getFunctionCode());
            if (role != null) {
                aut.getAuthorRole().add((Object)role);
            }
            if ((aAuth = author.getAssignedAuthor()) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName()));
                }
            } else {
                XON inst = this.extractAuthorInstitution(aAuth.getRepresentedOrganization());
                if (inst != null) {
                    aut.getAuthorInstitution().add((Object)inst);
                }
                if (aAuth.getAssignedAuthoringDevice() == null) {
                    String speciality;
                    XCN person = this.extractAuthorPerson(aAuth);
                    if (person != null) {
                        aut.setAuthorPerson(person);
                    }
                    if ((speciality = this.extractAuthorSpeciality(aAuth.getCode())) != null) {
                        aut.getAuthorSpeciality().add((Object)speciality);
                    }
                }
            }
            authorList.add(aut);
        }
        AuthorType[] returnList = new AuthorType[authorList.size()];
        i = authorList.iterator();
        int count = 0;
        while (i.hasNext()) {
            returnList[count] = (AuthorType)i.next();
            ++count;
        }
        return returnList;
    }

    public AvailabilityStatusType extractAvailabilityStatus() {
        logger.info((Object)"CDA R2 document header does not contain information corresponding to availablity status metadata.");
        return null;
    }

    public CodedMetadataType extractClassCode() {
        if (this.cda.getCode() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/code"));
            }
            return null;
        }
        if (this.cda.getCode().getCode() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/code@code"));
        }
        if (this.cda.getCode().getDisplayName() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/code@displayName"));
        }
        if (this.cda.getCode().getCodeSystemName() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/code@codeSchemeName"));
        }
        CodedMetadataType code = this.map((CD)this.cda.getCode());
        return code;
    }

    public InternationalStringType extractComments() {
        logger.info((Object)"CDA R2 document header does not contain information corresponding to comments metadata.");
        return null;
    }

    public CodedMetadataType extractConfidentialityCode() {
        if (this.cda.getConfidentialityCode() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/confidentialityCode"));
            }
            return null;
        }
        if (this.cda.getConfidentialityCode().getCode() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/confidentialityCode@code"));
        }
        if (this.cda.getConfidentialityCode().getDisplayName() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/confidentialityCode@displayName"));
        }
        if (this.cda.getConfidentialityCode().getCodeSystemName() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/confidentialityCode@codeSchemeName"));
        }
        CodedMetadataType code = this.map((CD)this.cda.getConfidentialityCode());
        return code;
    }

    public String extractCreationTime() {
        if (this.cda.getEffectiveTime() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/effectiveTime"));
            }
            return null;
        }
        if (this.cda.getEffectiveTime().getValue() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/effectiveTime@value"));
            }
            return null;
        }
        return this.map(this.cda.getEffectiveTime());
    }

    public String extractEntryUUID() {
        logger.info((Object)"DocumentEntry.entryUUID is an XDS specific attribute and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public CodedMetadataType[] extractEventCodes() {
        logger.info((Object)"This extraction routine, at this point,does not attempt to extract event code metadata from a generic CDA R2 document.");
        return null;
    }

    public CodedMetadataType extractFormatCode() {
        logger.info((Object)"DocumentEntry.formatCode is an XDS specific attribute and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public String extractHash() {
        logger.info((Object)"DocumentEntry.hash is a comptuted value and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public CodedMetadataType extractHealthCareFacilityTypeCode() {
        if (this.cda.getComponentOf() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040Component1.class.getName()));
            }
        } else if (this.cda.getComponentOf().getEncompassingEncounter() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040Component1.class.getName() + "/ " + POCDMT000040EncompassingEncounter.class.getName()));
            }
        } else if (this.cda.getComponentOf().getEncompassingEncounter().getLocation() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040Component1.class.getName() + "/ " + POCDMT000040EncompassingEncounter.class.getName() + "/ " + POCDMT000040Location.class.getName()));
            }
        } else if (this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040Component1.class.getName() + "/ " + POCDMT000040EncompassingEncounter.class.getName() + "/ " + POCDMT000040Location.class.getName() + "/ " + POCDMT000040HealthCareFacility.class.getName()));
            }
        } else if (this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility().getCode() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040Component1.class.getName() + "/ " + POCDMT000040EncompassingEncounter.class.getName() + "/ " + POCDMT000040Location.class.getName() + "/ " + POCDMT000040HealthCareFacility.class.getName() + "/code"));
            }
        } else {
            CE facility = this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility().getCode();
            if (facility.getCode() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040Component1.class.getName() + "/ " + POCDMT000040EncompassingEncounter.class.getName() + "/ " + POCDMT000040Location.class.getName() + "/ " + POCDMT000040HealthCareFacility.class.getName() + "/code@code)"));
            }
            if (facility.getDisplayName() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040Component1.class.getName() + "/ " + POCDMT000040EncompassingEncounter.class.getName() + "/ " + POCDMT000040Location.class.getName() + "/ " + POCDMT000040HealthCareFacility.class.getName() + "/code@displayName)"));
            }
            if (facility.getCodeSystemName() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040Component1.class.getName() + "/ " + POCDMT000040EncompassingEncounter.class.getName() + "/ " + POCDMT000040Location.class.getName() + "/ " + POCDMT000040HealthCareFacility.class.getName() + "/code@codeSchemeName)"));
            }
            CodedMetadataType code = this.map((CD)facility);
            return code;
        }
        return null;
    }

    public String extractLanguageCode() {
        if (this.cda.getLanguageCode() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/languageCode"));
            }
            return null;
        }
        if (this.cda.getLanguageCode().getCode() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/languageCode@code"));
        }
        return this.cda.getLanguageCode().getCode();
    }

    public XCN extractLegalAuthenticator() {
        if (this.cda.getLegalAuthenticator() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName()));
            }
            return null;
        }
        if (this.cda.getLegalAuthenticator().getAssignedEntity() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName()));
            }
            return null;
        }
        POCDMT000040AssignedEntity auth = this.cda.getLegalAuthenticator().getAssignedEntity();
        boolean idNull = false;
        if (!this.atLeastOne((List)auth.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ id"));
            }
            idNull = true;
        } else {
            if (((II)auth.getId().get(0)).getRoot() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ id@root"));
            }
            if (((II)auth.getId().get(0)).getExtension() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ id@extension"));
            }
            if (((II)auth.getId().get(0)).getAssigningAuthorityName() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ id@assigningAuthorityName"));
            }
        }
        if (auth.getAssignedPerson() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ " + POCDMT000040Person.class.getName()));
            }
            if (idNull) {
                return null;
            }
            return this.map((II)auth.getId().get(0), null);
        }
        if (!this.atLeastOne((List)auth.getAssignedPerson().getName())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name "));
            }
            if (idNull) {
                return null;
            }
            return this.map((II)auth.getId().get(0), null);
        }
        if (!this.atLeastOne((List)((PN)auth.getAssignedPerson().getName().get(0)).getFamily()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name/family "));
        }
        if (!this.atLeastOne((List)((PN)auth.getAssignedPerson().getName().get(0)).getGiven()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name/given "));
        }
        if (!this.atLeastOne((List)((PN)auth.getAssignedPerson().getName().get(0)).getPrefix()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name/prefix "));
        }
        if (!this.atLeastOne((List)((PN)auth.getAssignedPerson().getName().get(0)).getSuffix()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040LegalAuthenticator.class.getName() + "/ " + POCDMT000040AssociatedEntity.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name/suffix "));
        }
        if (idNull) {
            return this.map(null, (PN)auth.getAssignedPerson().getName().get(0));
        }
        return this.map((II)auth.getId().get(0), (PN)auth.getAssignedPerson().getName().get(0));
    }

    public String extractMimeType() {
        logger.info((Object)"DocumentEntry.mimeTypeis an XDS specific attribute and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public String extractParentDocumentId() {
        logger.info((Object)"DocumentEntry.parentDocumentId expresses the id of a parent document to this CDA document in the XDS Regisry.\nThis is not necessairly the same parent document that is documented within the CDA. \nThus, this information is not extracted.");
        return null;
    }

    public ParentDocumentRelationshipType extractParentDocumentRelationship() {
        logger.info((Object)"DocumentEntry.parentDocumentRelationship expresses the relationship of this CDA to another document in the XDS Regisry.\nThis is not necessairly the same relationship documented within the CDA. \nThus, this infomation is not extracted.");
        return null;
    }

    public CX extractPatientId() {
        logger.info((Object)"DocumentEntry.patientId expresses the Affinity Domain level patient id used in the XDS Regisry.\nIn all cases, this is not necessairly the same patientId that is documented within the CDA. \nThus, this information is not extracted.");
        return null;
    }

    public CodedMetadataType extractPracticeSettingCode() {
        return this.extractHealthCareFacilityTypeCode();
    }

    public String extractServiceStartTime() {
        if (!this.atLeastOne((List)this.cda.getDocumentationOf())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName()));
            }
            return null;
        }
        POCDMT000040DocumentationOf docOf = (POCDMT000040DocumentationOf)this.cda.getDocumentationOf().get(0);
        POCDMT000040ServiceEvent sEvent = docOf.getServiceEvent();
        if (sEvent == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName() + "/ " + POCDMT000040ServiceEvent.class));
            }
            return null;
        }
        if (sEvent.getEffectiveTime() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName() + "/ " + POCDMT000040ServiceEvent.class + "/ effectiveTime"));
            }
            return null;
        }
        IVLTS range = sEvent.getEffectiveTime();
        if (range.getLow() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName() + "/ " + POCDMT000040ServiceEvent.class + "/ effectiveTime/ low"));
            }
        } else if (range.getLow().getValue() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName() + "/ " + POCDMT000040ServiceEvent.class + "/ effectiveTime/ low@value"));
        }
        return this.map((TS1)range.getLow());
    }

    public String extractServiceStopTime() {
        if (!this.atLeastOne((List)this.cda.getDocumentationOf())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName()));
            }
            return null;
        }
        POCDMT000040DocumentationOf docOf = (POCDMT000040DocumentationOf)this.cda.getDocumentationOf().get(0);
        POCDMT000040ServiceEvent sEvent = docOf.getServiceEvent();
        if (sEvent == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName() + "/ " + POCDMT000040ServiceEvent.class));
            }
            return null;
        }
        if (sEvent.getEffectiveTime() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName() + "/ " + POCDMT000040ServiceEvent.class + "/ effectiveTime"));
            }
            return null;
        }
        IVLTS range = sEvent.getEffectiveTime();
        if (range.getHigh() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName() + "/ " + POCDMT000040ServiceEvent.class + "/ effectiveTime/ high"));
            }
        } else if (range.getHigh().getValue() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040DocumentationOf.class.getName() + "/ " + POCDMT000040ServiceEvent.class + "/ effectiveTime/ high@value"));
        }
        return this.map((TS1)range.getHigh());
    }

    public String extractSize() {
        logger.info((Object)"DocumentEntry.size is a comptuted value and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public CX extractSourcePatientId() {
        if (!this.atLeastOne((List)this.cda.getRecordTarget())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName()));
            }
            return null;
        }
        POCDMT000040RecordTarget target = (POCDMT000040RecordTarget)this.cda.getRecordTarget().get(0);
        if (target.getPatientRole() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName()));
            }
            return null;
        }
        POCDMT000040PatientRole patient = target.getPatientRole();
        if (!this.atLeastOne((List)patient.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ id"));
            }
            return null;
        }
        II pId = (II)patient.getId().get(0);
        if (pId.getExtension() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ id@extension"));
        }
        if (pId.getRoot() == null && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ id@root"));
        }
        return this.map(pId);
    }

    public SourcePatientInfoType extractSourcePatientInfo() {
        if (!this.atLeastOne((List)this.cda.getRecordTarget())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName()));
            }
            return null;
        }
        POCDMT000040RecordTarget target = (POCDMT000040RecordTarget)this.cda.getRecordTarget().get(0);
        if (target.getPatientRole() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName()));
            }
            return null;
        }
        POCDMT000040PatientRole patient = target.getPatientRole();
        SourcePatientInfoType sourceInfo = Hl7v2Factory.eINSTANCE.createSourcePatientInfoType();
        if (!this.atLeastOne((List)patient.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ id"));
            }
        } else {
            sourceInfo.getPatientIdentifier().addAll((Collection)this.extractPid3((List)patient.getId()));
        }
        if (!this.atLeastOne((List)patient.getAddr())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ addr"));
            }
        } else {
            sourceInfo.setPatientAddress(this.extractPid11((AD)patient.getAddr().get(0)));
        }
        if (!this.atLeastOne((List)patient.getTelecom()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ telecom"));
        }
        if (patient.getPatient() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName()));
            }
        } else {
            POCDMT000040Patient p = patient.getPatient();
            if (p.getId() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName() + "/ id"));
                }
            } else {
                ArrayList<II> l = new ArrayList<II>();
                l.add(p.getId());
                sourceInfo.getPatientIdentifier().addAll((Collection)this.extractPid3(l));
            }
            if (!this.atLeastOne((List)p.getName())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName() + "/ name"));
                }
            } else {
                sourceInfo.getPatientName().addAll((Collection)this.extractPid5((List)p.getName()));
            }
            sourceInfo.setPatientDateOfBirth(this.extractPid7(p.getBirthTime()));
            sourceInfo.setPatientSex(this.extractPid8(p.getAdministrativeGenderCode()));
        }
        return sourceInfo;
    }

    public InternationalStringType extractTitle() {
        if (this.cda.getTitle() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/title"));
            }
            return null;
        }
        LocalizedStringType dName = MetadataFactory.eINSTANCE.createLocalizedStringType();
        String txt = this.processMixed(this.cda.getTitle().getMixed());
        if (txt.length() <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata value: " + POCDMT000040ClinicalDocument.class.getName() + "/title"));
            }
            return null;
        }
        dName.setValue(txt);
        InternationalStringType display = MetadataFactory.eINSTANCE.createInternationalStringType();
        display.getLocalizedString().add((Object)dName);
        return display;
    }

    public CodedMetadataType extractTypeCode() {
        return this.extractClassCode();
    }

    public String extractURI() {
        logger.info((Object)"DocumentEntry.URI is a comptuted value and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public String extractUniqueId() {
        if (this.cda.getId() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/id"));
            }
            return null;
        }
        if (this.cda.getId().getRoot() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/id@root"));
            }
            return null;
        }
        if (this.cda.getId().getExtension() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/id@extension"));
            }
            return this.cda.getId().getRoot();
        }
        return String.valueOf(this.cda.getId().getRoot()) + "^" + this.cda.getId().getExtension();
    }

    private XON extractAuthorInstitution(POCDMT000040Organization org) {
        if (org == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Organization.class.getName()));
            }
            return null;
        }
        boolean idNull = false;
        if (!this.atLeastOne((List)org.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Organization.class.getName() + "/ id"));
            }
            idNull = true;
        } else {
            if (((II)org.getId().get(0)).getRoot() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Organization.class.getName() + "/ id@root"));
            }
            if (((II)org.getId().get(0)).getExtension() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Organization.class.getName() + "/ id@extension"));
            }
            if (((II)org.getId().get(0)).getAssigningAuthorityName() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Organization.class.getName() + "/ id@assigningAuthorityName"));
            }
        }
        if (!this.atLeastOne((List)org.getName())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Organization.class.getName() + "/ name"));
            }
            if (idNull) {
                return null;
            }
            return this.map(null, (II)org.getId().get(0));
        }
        if (idNull) {
            return this.map((ON)org.getName().get(0), null);
        }
        return this.map((ON)org.getName().get(0), (II)org.getId().get(0));
    }

    private XCN extractAuthorPerson(POCDMT000040AssignedAuthor aAuth) {
        if (aAuth == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName()));
            }
            return null;
        }
        boolean idNull = false;
        if (!this.atLeastOne((List)aAuth.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ id"));
            }
            idNull = true;
        } else {
            if (((II)aAuth.getId().get(0)).getRoot() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ id@root"));
            }
            if (((II)aAuth.getId().get(0)).getExtension() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ id@extension"));
            }
            if (((II)aAuth.getId().get(0)).getAssigningAuthorityName() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ id@assigningAuthorityName"));
            }
        }
        if (aAuth.getAssignedPerson() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Person.class.getName()));
            }
            if (idNull) {
                return null;
            }
            return this.map((II)aAuth.getId().get(0), null);
        }
        if (!this.atLeastOne((List)aAuth.getAssignedPerson().getName())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name "));
            }
            if (idNull) {
                return null;
            }
            return this.map((II)aAuth.getId().get(0), null);
        }
        if (!this.atLeastOne((List)((PN)aAuth.getAssignedPerson().getName().get(0)).getFamily()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name/family "));
        }
        if (!this.atLeastOne((List)((PN)aAuth.getAssignedPerson().getName().get(0)).getGiven()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name/given "));
        }
        if (!this.atLeastOne((List)((PN)aAuth.getAssignedPerson().getName().get(0)).getPrefix()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name/prefix "));
        }
        if (!this.atLeastOne((List)((PN)aAuth.getAssignedPerson().getName().get(0)).getSuffix()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/ " + POCDMT000040Person.class.getName() + "/name/suffix "));
        }
        if (idNull) {
            return this.map(null, (PN)aAuth.getAssignedPerson().getName().get(0));
        }
        return this.map((II)aAuth.getId().get(0), (PN)aAuth.getAssignedPerson().getName().get(0));
    }

    private String extractAuthorRole(CE role) {
        if (role == null) {
            return null;
        }
        if (role.getCode() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/ functionCode"));
            }
            return null;
        }
        return role.getCode();
    }

    private String extractAuthorSpeciality(CE spec) {
        if (spec == null) {
            return null;
        }
        if (spec.getCode() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040Author.class.getName() + "/" + POCDMT000040AssignedAuthor.class.getName() + "/code"));
            }
            return null;
        }
        return spec.getCode();
    }

    private List extractPid3(List idList) {
        Iterator i = idList.iterator();
        ArrayList<CX> ids = new ArrayList<CX>();
        while (i.hasNext()) {
            CX cx;
            II pId = (II)i.next();
            if (pId.getExtension() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ id@extension"));
            }
            if (pId.getRoot() == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ id@root"));
            }
            if ((cx = this.map(pId)) == null) continue;
            ids.add(cx);
        }
        return ids;
    }

    private List extractPid5(List nameList) {
        Iterator i = nameList.iterator();
        ArrayList<XPN> names = new ArrayList<XPN>();
        while (i.hasNext()) {
            PN name = (PN)i.next();
            if (!this.atLeastOne((List)name.getFamily()) && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040RecordTarget.class.getName() + "/" + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName() + "/name/family "));
            }
            if (!this.atLeastOne((List)name.getGiven()) && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040RecordTarget.class.getName() + "/" + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName() + "/name/given "));
            }
            if (!this.atLeastOne((List)name.getPrefix()) && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040RecordTarget.class.getName() + "/" + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName() + "/name/prefix "));
            }
            if (!this.atLeastOne((List)name.getSuffix()) && logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/" + POCDMT000040RecordTarget.class.getName() + "/" + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName() + "/name/suffix "));
            }
            XPN xpn = this.map(name);
            names.add(xpn);
        }
        return names;
    }

    private String extractPid7(TS1 time) {
        if (time == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName() + "/ birthTime"));
            }
            return null;
        }
        return this.map(time);
    }

    private String extractPid8(CE docCode) {
        if (docCode == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ " + POCDMT000040Patient.class.getName() + "/ administrativeGenderCode"));
            }
            return null;
        }
        String gender = docCode.getCode();
        String value = (String)ADMIN_GENDER_TABLE_001.get(gender);
        if (value == null && gender != null) {
            logger.warn((Object)("Vocabulary value not found: " + gender));
        }
        return value;
    }

    private XAD extractPid11(AD addr) {
        if (!this.atLeastOne((List)addr.getStreetAddressLine()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ addr/streetAddressLine "));
        }
        if (!this.atLeastOne((List)addr.getAdditionalLocator()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ addr/additionalLocator"));
        }
        if (!this.atLeastOne((List)addr.getCity()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ addr/city"));
        }
        if (!this.atLeastOne((List)addr.getState()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ addr/state "));
        }
        if (!this.atLeastOne((List)addr.getPostalCode()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ addr/postalCode "));
        }
        if (!this.atLeastOne((List)addr.getCountry()) && logger.isDebugEnabled()) {
            logger.debug((Object)("Missing metadata source: " + POCDMT000040ClinicalDocument.class.getName() + "/ " + POCDMT000040RecordTarget.class.getName() + "/ " + POCDMT000040PatientRole.class.getName() + "/ addr/country"));
        }
        return this.map(addr);
    }

    protected String processMixed(FeatureMap m) {
        StringBuffer txt = new StringBuffer("");
        int i = 0;
        while (i < m.size()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)m.get(i);
            if (entry.getEStructuralFeature() == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text()) {
                txt.append((String)entry.getValue());
            }
            ++i;
        }
        return txt.toString();
    }

    protected boolean atLeastOne(List l) {
        if (l == null) {
            return false;
        }
        if (l.size() < 1) {
            return false;
        }
        return l.get(0) != null;
    }

    protected CodedMetadataType map(CD docCode) {
        if (docCode == null) {
            return null;
        }
        CodedMetadataType code = MetadataFactoryImpl.eINSTANCE.createCodedMetadataType();
        code.setCode(docCode.getCode());
        if (docCode.getDisplayName() != null) {
            LocalizedStringType dName = MetadataFactory.eINSTANCE.createLocalizedStringType();
            dName.setValue(docCode.getDisplayName());
            InternationalStringType display = MetadataFactory.eINSTANCE.createInternationalStringType();
            display.getLocalizedString().add((Object)dName);
            code.setDisplayName(display);
        }
        if (docCode.getCodeSystemName() != null) {
            code.setSchemeName(docCode.getCodeSystemName());
        }
        return code;
    }

    protected CX map(II id) {
        if (id == null) {
            return null;
        }
        CX cx = Hl7v2Factory.eINSTANCE.createCX();
        cx.setIdNumber(id.getExtension());
        cx.setAssigningAuthorityUniversalId(id.getRoot());
        cx.setAssigningAuthorityUniversalIdType("ISO");
        return cx;
    }

    protected XTN map(TEL tel) {
        if (tel == null) {
            return null;
        }
        XTN xtn = Hl7v2Factory.eINSTANCE.createXTN();
        xtn.setUnformattedTelephoneNumber(tel.getValue());
        return xtn;
    }

    protected String map(TS1 time) {
        if (time == null) {
            return null;
        }
        if (time.getValue() == null) {
            return null;
        }
        String tm = time.getValue();
        if (tm.length() > "YYYYMMDDHHMMSS".length()) {
            tm = tm.substring(0, "YYYYMMDDHHMMSS".length());
        }
        return tm;
    }

    protected XPN map(PN name) {
        ENXP prefix;
        ENXP suffix;
        ENXP family;
        String txt;
        if (name == null) {
            return null;
        }
        XPN xpn = Hl7v2Factory.eINSTANCE.createXPN();
        if (this.atLeastOne((List)name.getFamily()) && (txt = this.processMixed((family = (ENXP)name.getFamily().get(0)).getMixed())).length() > 0) {
            xpn.setFamilyName(txt);
        }
        if (this.atLeastOne((List)name.getGiven())) {
            ENXP given = (ENXP)name.getGiven().get(0);
            txt = this.processMixed(given.getMixed());
            if (txt.length() > 0) {
                xpn.setGivenName(txt);
            }
            if (name.getGiven().size() > 1 && name.getGiven().get(1) != null) {
                ENXP cfr_ignored_0 = (ENXP)name.getGiven().get(1);
                txt = this.processMixed(given.getMixed());
                if (txt.length() > 0) {
                    xpn.setOtherName(txt);
                }
            }
        }
        if (this.atLeastOne((List)name.getSuffix()) && (txt = this.processMixed((suffix = (ENXP)name.getSuffix().get(0)).getMixed())).length() > 0) {
            xpn.setSuffix(txt);
        }
        if (this.atLeastOne((List)name.getPrefix()) && (txt = this.processMixed((prefix = (ENXP)name.getPrefix().get(0)).getMixed())).length() > 0) {
            xpn.setPrefix(txt);
        }
        return xpn;
    }

    protected XCN map(II id, PN name) {
        XCN xcn = Hl7v2Factory.eINSTANCE.createXCN();
        boolean idNull = true;
        boolean nameNull = true;
        if (id != null) {
            xcn.setIdNumber(id.getExtension());
            xcn.setAssigningAuthorityName(id.getAssigningAuthorityName());
            xcn.setAssigningAuthorityUniversalId(id.getRoot());
            xcn.setAssigningAuthorityUniversalIdType("ISO");
            idNull = false;
        }
        if (name != null) {
            ENXP prefix;
            ENXP suffix;
            ENXP family;
            String txt;
            if (this.atLeastOne((List)name.getFamily()) && (txt = this.processMixed((family = (ENXP)name.getFamily().get(0)).getMixed())).length() > 0) {
                xcn.setFamilyName(txt);
            }
            if (this.atLeastOne((List)name.getGiven())) {
                ENXP given = (ENXP)name.getGiven().get(0);
                txt = this.processMixed(given.getMixed());
                if (txt.length() > 0) {
                    xcn.setGivenName(txt);
                }
                if (name.getGiven().size() > 1 && name.getGiven().get(1) != null) {
                    ENXP cfr_ignored_0 = (ENXP)name.getGiven().get(1);
                    txt = this.processMixed(given.getMixed());
                    if (txt.length() > 0) {
                        xcn.setOtherName(txt);
                    }
                }
            }
            if (this.atLeastOne((List)name.getSuffix()) && (txt = this.processMixed((suffix = (ENXP)name.getSuffix().get(0)).getMixed())).length() > 0) {
                xcn.setSuffix(txt);
            }
            if (this.atLeastOne((List)name.getPrefix()) && (txt = this.processMixed((prefix = (ENXP)name.getPrefix().get(0)).getMixed())).length() > 0) {
                xcn.setPrefix(txt);
            }
        }
        if (idNull && nameNull) {
            return null;
        }
        return xcn;
    }

    protected XON map(ON name, II id) {
        String txt;
        XON xon = Hl7v2Factory.eINSTANCE.createXON();
        if (id != null) {
            xon.setIdNumber(id.getExtension());
            xon.setAssigningAuthorityName(id.getAssigningAuthorityName());
            xon.setAssigningAuthorityUniversalId(id.getRoot());
            xon.setAssigningAuthorityUniversalIdType("ISO");
        }
        if (name != null && (txt = this.processMixed(name.getMixed())).length() > 0) {
            xon.setOrganizationName(txt);
        }
        return xon;
    }

    protected XAD map(AD addr) {
        ADXP stl;
        String txt;
        if (addr == null) {
            return null;
        }
        XAD xad = Hl7v2Factory.eINSTANCE.createXAD();
        if (this.atLeastOne((List)addr.getStreetAddressLine()) && (txt = this.processMixed((stl = (ADXP)addr.getStreetAddressLine().get(0)).getMixed())).length() > 0) {
            xad.setStreetAddress(txt);
        }
        if (this.atLeastOne((List)addr.getAdditionalLocator()) && (txt = this.processMixed((stl = (ADXP)addr.getAdditionalLocator().get(0)).getMixed())).length() > 0) {
            xad.setOtherDesignation(txt);
        }
        if (this.atLeastOne((List)addr.getCity()) && (txt = this.processMixed((stl = (ADXP)addr.getCity().get(0)).getMixed())).length() > 0) {
            xad.setCity(txt);
        }
        if (this.atLeastOne((List)addr.getState()) && (txt = this.processMixed((stl = (ADXP)addr.getState().get(0)).getMixed())).length() > 0) {
            xad.setStateOrProvince(txt);
        }
        if (this.atLeastOne((List)addr.getPostalCode()) && (txt = this.processMixed((stl = (ADXP)addr.getPostalCode().get(0)).getMixed())).length() > 0) {
            xad.setZipOrPostalCode(txt);
        }
        if (this.atLeastOne((List)addr.getCountry()) && (txt = this.processMixed((stl = (ADXP)addr.getCountry().get(0)).getMixed())).length() > 0) {
            xad.setCountry(txt);
        }
        return xad;
    }
}

