/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pdq.consumer;

import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerException;

public class PdqConsumerResponse
extends PixPdqMessage {
    private boolean hasERR = false;
    private boolean hasPID = false;
    private boolean hasDSC = false;

    public PdqConsumerResponse(MessageManager globalFactory) throws PdqConsumerException {
        try {
            this.setDefinitions(globalFactory.getVersionDefinitions());
            this.setVersion(8);
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }

    public void init() {
        SegmentList segList = this.getSegments();
        int i = 0;
        while (i < segList.size()) {
            if (!this.hasERR && segList.item(i).getCode().compareTo("ERR") == 0) {
                this.hasERR = true;
            } else if (!this.hasPID && segList.item(i).getCode().compareTo("PID") == 0) {
                this.hasPID = true;
            } else if (!this.hasDSC && segList.item(i).getCode().compareTo("DSC") == 0) {
                this.hasDSC = true;
            }
            ++i;
        }
    }

    public boolean hasError() {
        return this.hasERR;
    }

    public String getResponseAckCode(boolean expandString) throws PdqConsumerException {
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("MSA", 1);
        int fieldIndex = 0;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return value;
    }

    public String getControlId() throws PdqConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("MSA", 1);
        int fieldIndex = 1;
        try {
            return seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }

    public int getErrorCountbySegment() {
        if (!this.hasERR) {
            return -1;
        }
        return this.getSegments().countByCode("ERR");
    }

    public int getErrorCountbyRepeat() {
        if (!this.hasERR) {
            return -1;
        }
        try {
            int fieldIndex = 1;
            return this.getSegments().getByCodeAndIndex("ERR", 1).getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String[] getErrorLocation(int segmentIndex, int repeatIndex) throws PdqConsumerException {
        if (!this.hasERR) {
            return null;
        }
        Segment seg = this.getSegments().getByCodeAndIndex("ERR", segmentIndex + 1);
        int fieldIndex = 1;
        try {
            return PixPdqMessageUtilities.getFieldComponentsInRepeat((Segment)seg, (int)fieldIndex, (int)repeatIndex);
        }
        catch (PixPdqMessageException e) {
            throw new PdqConsumerException(e);
        }
    }

    public String[] getErrorCode(int segmentIndex) throws PdqConsumerException {
        if (!this.hasERR) {
            return null;
        }
        Segment seg = this.getSegments().getByCodeAndIndex("ERR", segmentIndex + 1);
        int fieldIndex = 2;
        try {
            return PixPdqMessageUtilities.getFieldComponents((Segment)seg, (int)fieldIndex);
        }
        catch (PixPdqMessageException e) {
            throw new PdqConsumerException(e);
        }
    }

    public String getErrorSeverity(int segmentIndex, boolean expandString) throws PdqConsumerException {
        if (!this.hasERR) {
            return "";
        }
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("ERR", segmentIndex + 1);
        int fieldIndex = 3;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return value;
    }

    public String getQueryStatus(boolean expandString) throws PdqConsumerException {
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("QAK", 1);
        int fieldIndex = 1;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return value;
    }

    public String[] getQueryName() throws PdqConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("QPD", 1);
        int fieldIndex = 0;
        try {
            return PixPdqMessageUtilities.getFieldComponents((Segment)seg, (int)fieldIndex);
        }
        catch (PixPdqMessageException e) {
            throw new PdqConsumerException(e);
        }
    }

    public String getQueryTag() throws PdqConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("QPD", 1);
        int fieldIndex = 1;
        try {
            return seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }

    public int getPatientCount() {
        return this.getSegments().countByCode("PID");
    }

    public int getPatientIdentifierCount(int patientIndex) {
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 2;
        try {
            return seg.getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String[] getPatientIdentifier(int patientIndex, int identifierIndex) throws PdqConsumerException {
        String[] values = new String[4];
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 2;
        try {
            Field fld = seg.getFields().item(fieldIndex).getRepeat(identifierIndex);
            values[0] = fld.forceElement("1").getAsString();
            values[1] = fld.forceElement("4-1").getAsString();
            values[2] = fld.forceElement("4-2").getAsString();
            values[3] = fld.forceElement("4-3").getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return values;
    }

    public int getPatientNameCount(int patientIndex) {
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 4;
        try {
            return seg.getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String[] getPatientName(int patientIndex, int patientNameIndex) throws PdqConsumerException {
        String[] values = new String[6];
        int fieldIndex = 4;
        try {
            Field fld = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1).getFields().item(fieldIndex).getRepeat(patientNameIndex);
            values[0] = fld.forceElement("1-1").getAsString();
            values[1] = fld.forceElement("2").getAsString();
            values[2] = fld.forceElement("3").getAsString();
            values[3] = fld.forceElement("4").getAsString();
            values[4] = fld.forceElement("5").getAsString();
            values[5] = fld.forceElement("6").getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return values;
    }

    public String getPatientNameFamilyName(int patientIndex, int patientNameIndex) throws PdqConsumerException {
        String component = "1-1";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNameGivenName(int patientIndex, int patientNameIndex) throws PdqConsumerException {
        String component = "2";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNameOtherName(int patientIndex, int patientNameIndex) throws PdqConsumerException {
        String component = "3";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNameSuffix(int patientIndex, int patientNameIndex) throws PdqConsumerException {
        String component = "4";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNamePrefix(int patientIndex, int patientNameIndex) throws PdqConsumerException {
        String component = "5";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientNameDegree(int patientIndex, int patientNameIndex) throws PdqConsumerException {
        String component = "6";
        return this.getPatientNameRepeatField(patientIndex, patientNameIndex, component);
    }

    public String getPatientDateOfBirth(int patientIndex) throws PdqConsumerException {
        int fieldIndex = 6;
        Field fld = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1).getFields().item(fieldIndex);
        String component = "1";
        try {
            return fld.forceElement(component).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }

    public String getPatientSex(int patientIndex, boolean expandString) throws PdqConsumerException {
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 7;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return value;
    }

    public int getPatientAddressCount(int patientIndex) {
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 10;
        try {
            return seg.getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String[] getPatientAddress(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String[] values = new String[10];
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 10;
        try {
            Field fld = seg.getFields().item(fieldIndex).getRepeat(patientAddressIndex);
            values[0] = fld.forceElement("1-1").getAsString();
            values[1] = fld.forceElement("2").getAsString();
            values[2] = fld.forceElement("3").getAsString();
            values[3] = fld.forceElement("4").getAsString();
            values[4] = fld.forceElement("5").getAsString();
            values[5] = fld.forceElement("6").getAsString();
            values[6] = fld.forceElement("7").getAsString();
            values[7] = fld.forceElement("8").getAsString();
            values[8] = fld.forceElement("9").getAsString();
            values[9] = fld.forceElement("10").getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return values;
    }

    public String getPatientAddressStreetAddress(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "1-1";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressOtherDesignation(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "2";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressCity(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "3";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressStateOrProvince(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "4";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressZipOrPostalCode(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "5";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressCountry(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "6";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressType(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "7";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressOtherGeographicDesignation(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "8";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressCountyParishCode(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "9";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public String getPatientAddressCensusTract(int patientIndex, int patientAddressIndex) throws PdqConsumerException {
        String component = "10";
        return this.getPatientAddressRepeatField(patientIndex, patientAddressIndex, component);
    }

    public int getPatientPhoneHomeCount(int patientIndex) {
        int fieldIndex = 12;
        try {
            return this.getSegments().getByCodeAndIndex("PID", patientIndex + 1).getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String getPatientPhoneHomeUnformattedTelephoneNumber(int patientIndex, int phoneIndex) throws PdqConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 12;
        try {
            Field fld = seg.getFields().item(fieldIndex).getRepeat(phoneIndex);
            return fld.forceElement("1").getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }

    public int getPatientPhoneBusinessCount(int patientIndex) {
        int fieldIndex = 13;
        try {
            return this.getSegments().getByCodeAndIndex("PID", patientIndex + 1).getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception hL7V2Exception) {
            return -1;
        }
    }

    public String getPatientPhoneBusinessUnformattedTelephoneNumber(int patientIndex, int phoneIndex) throws PdqConsumerException {
        Segment seg = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1);
        int fieldIndex = 13;
        try {
            Field fld = seg.getFields().item(fieldIndex).getRepeat(phoneIndex);
            return fld.forceElement("1").getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }

    public String getContinuationPointer() throws PdqConsumerException {
        if (!this.hasDSC) {
            return null;
        }
        Segment seg = this.getSegments().getByCodeAndIndex("DSC", 1);
        int fieldIndex = 0;
        try {
            return seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }

    public String getContinuationStyle(boolean expandString) throws PdqConsumerException {
        if (!this.hasDSC) {
            return null;
        }
        String value = null;
        Segment seg = this.getSegments().getByCodeAndIndex("DSC", 1);
        int fieldIndex = 1;
        try {
            value = expandString ? seg.forceField(fieldIndex).getAsTableDescription() : seg.forceField(fieldIndex).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        return value;
    }

    private String getPatientNameRepeatField(int patientIndex, int patientNameIndex, String component) throws PdqConsumerException {
        try {
            int fieldIndex = 4;
            Field fld = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1).getFields().item(fieldIndex).getRepeat(patientNameIndex);
            return fld.forceElement(component).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }

    private String getPatientAddressRepeatField(int patientIndex, int patientAddressIndex, String component) throws PdqConsumerException {
        try {
            int fieldIndex = 10;
            Field fld = this.getSegments().getByCodeAndIndex("PID", patientIndex + 1).getFields().item(fieldIndex).getRepeat(patientAddressIndex);
            return fld.forceElement(component).getAsString();
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
    }
}

