/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.source.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class OID {
    static int sequence = 0;
    static final String rootPrefix = "1.2.820";

    public static String createOID(String organization) {
        ++sequence;
        byte[] hostip = new byte[4];
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostip = localhost.getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            hostip[0] = 127;
            hostip[1] = 0;
            hostip[2] = 0;
            hostip[3] = 1;
        }
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 138;
        nArray[3] = 74;
        nArray[4] = 253;
        nArray[5] = 172;
        int[] mac = nArray;
        int i = 0;
        while (i < mac.length) {
            mac[i] = (int)((double)(hostip[i % hostip.length] - mac[i]) * Math.random());
            ++i;
        }
        String macString = "";
        int i2 = 0;
        while (i2 < mac.length) {
            macString = String.valueOf(macString) + OID.format(mac[i2]);
            ++i2;
        }
        if (organization == null) {
            organization = "99999";
        }
        String root = "1.2.820." + Integer.parseInt(organization);
        String suffix = String.valueOf(macString) + "." + System.currentTimeMillis() + "." + sequence;
        int maxSuffix = 55;
        if (suffix.length() > maxSuffix) {
            suffix = suffix.substring(0, maxSuffix);
        }
        String result = String.valueOf(root) + "." + suffix;
        return result.replaceAll("[.]0", ".1");
    }

    public static String createOIDGivenRoot(String rootOid) {
        if (rootOid == null) {
            return OID.createOID(rootOid);
        }
        ++sequence;
        byte[] hostip = new byte[4];
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostip = localhost.getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            hostip[0] = 127;
            hostip[1] = 0;
            hostip[2] = 0;
            hostip[3] = 1;
        }
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 138;
        nArray[3] = 74;
        nArray[4] = 253;
        nArray[5] = 172;
        int[] mac = nArray;
        int i = 0;
        while (i < mac.length) {
            mac[i] = (int)((double)(hostip[i % hostip.length] - mac[i]) * Math.random());
            ++i;
        }
        String macString = "";
        int i2 = 0;
        while (i2 < mac.length) {
            macString = String.valueOf(macString) + OID.format(mac[i2]);
            ++i2;
        }
        String root = rootOid;
        String suffix = String.valueOf(macString) + "." + System.currentTimeMillis() + "." + sequence;
        int maxSuffix = 55;
        if (suffix.length() > maxSuffix) {
            suffix = suffix.substring(0, maxSuffix);
        }
        String result = String.valueOf(root) + "." + suffix;
        return result.replaceAll("[.]0", ".1");
    }

    private static String format(byte b) {
        StringBuffer sb = new StringBuffer();
        if (b < 0) {
            b = (byte)(b * -1);
        }
        if (b < 10) {
            sb.append("00");
        } else if (b < 100) {
            sb.append('0');
        }
        sb.append(b);
        return sb.toString();
    }

    private static String format(int i) {
        i = Math.abs(i);
        StringBuffer sb = new StringBuffer(3);
        if (i < 10) {
            sb.append("0");
        }
        if (i < 100) {
            sb.append("0");
        }
        sb.append(i);
        return sb.toString();
    }

    public static void main(String[] argv) {
        System.out.println("         1         2         3         4         5         6   x");
        System.out.println("123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_");
        int i = 0;
        while (i < 15) {
            System.out.println(OID.createOID(null));
            ++i;
        }
        System.out.println();
        System.out.println("123456789_123456789_123456789_123456789_123456789_123456789_123456789_123456789_");
        i = 0;
        while (i < 15) {
            System.out.println(OID.createOIDGivenRoot("2.16.840.1.113883.3.18"));
            ++i;
        }
    }
}

