/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pix.source;

import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.pix.source.PixMsgADT;
import org.eclipse.ohf.ihe.pix.source.PixSourceException;

public class PixMsgMergePatient
extends PixMsgADT {
    private static Logger logger = Logger.getLogger(PixMsgMergePatient.class);
    private static final int version = 6;

    public PixMsgMergePatient(MessageManager globalFactory, CPConformanceProfile cpProfile, String patientId, String namespaceId, String universalId, String universalIdType, String patientClass, String priorPatientId) throws PixSourceException {
        super(globalFactory, cpProfile, 6, "A40", patientId, namespaceId, universalId, universalIdType);
        this.nodeType = 2;
        this.createA40Fields(patientClass, priorPatientId, namespaceId, universalId, universalIdType);
    }

    private void createA40Fields(String patientClass, String priorPatientId, String namespaceId, String universalId, String universalIdType) throws PixSourceException {
        try {
            this.getSegments().add("MRG");
            this.setField("MRG-1-1", priorPatientId);
            if (!PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                throw new PixSourceException("PixMsgMergePatient: createA40Fields - " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination ");
            }
            this.setField("MRG-1-4-1", namespaceId);
            this.setField("MRG-1-4-2", universalId);
            this.setField("MRG-1-4-3", universalIdType);
            this.getSegments().add("PV1");
            this.setField("PV1-2", patientClass);
        }
        catch (HL7V2Exception e) {
            throw new PixSourceException(e);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixMsgMergePatient: createA40Fields ");
        }
    }
}

