/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.ebxml._2._1.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExternalIdentifierType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExtrinsicObjectType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LeafRegistryObjectListType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LocalizedStringType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.SlotType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryFactory;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.SubmitObjectsRequestType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.util.RegistryResourceFactoryImpl;

public class SubmitTest {
    public static void main(String[] args) throws Exception {
        System.out.println("START TEST *******************************");
        System.out.println("reading *" + args[0] + "*");
        System.out.println("begin loading.");
        Resource resources = new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
        File file = new File(args[0]);
        byte[] input = new byte[(int)file.length()];
        new FileInputStream(file).read(input);
        resources.load((InputStream)new ByteArrayInputStream(input), null);
        EList list = resources.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        SubmitObjectsRequestType req = root.getSubmitObjectsRequest();
        LeafRegistryObjectListType lList = null;
        ExtrinsicObjectType extrObj = null;
        System.out.println("Done loading " + req.getClass().getName());
        lList = req.getLeafRegistryObjectList();
        System.out.println("Done loading " + lList.getClass().getName());
        extrObj = (ExtrinsicObjectType)lList.getExtrinsicObject().get(0);
        System.out.println("Done loading " + extrObj.getClass().getName());
        EList regs = lList.getRegistryPackage();
        System.out.println("Done loading RegPackage.");
        EList assocs = lList.getAssociation();
        System.out.println("Done loading Associations.");
        EList cls = lList.getClassification();
        System.out.println("Done loading Classifications.");
        resources.unload();
        System.out.println("Unload resources.\n");
        System.out.println("Print data:");
        System.out.println("ExrinsicObject ***************************");
        System.out.println("Slots:");
        SlotType1 slot2 = null;
        String value2 = null;
        for (SlotType1 slot2 : extrObj.getSlot()) {
            if (slot2 == null || slot2.getValueList() == null) continue;
            for (String value2 : slot2.getValueList().getValue()) {
                System.out.println(String.valueOf(slot2.getName()) + ": " + value2);
            }
        }
        System.out.println("\nClassifications:");
        ClassificationType c2 = null;
        for (ClassificationType c2 : extrObj.getClassification()) {
            System.out.println("UUID: " + c2.getClassificationScheme());
            System.out.println("Code: " + c2.getNodeRepresentation());
            if (c2.getName() == null || c2.getName().getLocalizedString() == null) continue;
            for (LocalizedStringType ls : c2.getName().getLocalizedString()) {
                System.out.println("Display: " + ls.getValue() + "(lang = " + ls.getLang() + ")");
            }
        }
        System.out.println("\nExternalIdentifiers:");
        ExternalIdentifierType e2 = null;
        for (ExternalIdentifierType e2 : extrObj.getExternalIdentifier()) {
            System.out.println("UUID: " + e2.getIdentificationScheme());
            System.out.println("ID: " + e2.getValue());
            if (e2.getName() == null || e2.getName().getLocalizedString() == null) continue;
            for (LocalizedStringType ls : e2.getName().getLocalizedString()) {
                System.out.println("Display: " + ls.getValue() + "(lang = " + ls.getLang() + ")");
            }
        }
        System.out.println("\n\nRegistryPackage ***************************");
        for (RegistryPackageType reg : regs) {
            System.out.println("ID: " + reg.getId());
            System.out.println("Slots:");
            slot2 = null;
            value2 = null;
            for (SlotType1 slot2 : reg.getSlot()) {
                if (slot2 == null || slot2.getValueList() == null) continue;
                for (String value2 : slot2.getValueList().getValue()) {
                    System.out.println(String.valueOf(slot2.getName()) + ": " + value2);
                }
            }
            System.out.println("\nClassifications:");
            c2 = null;
            for (ClassificationType c2 : reg.getClassification()) {
                System.out.println("UUID: " + c2.getClassificationScheme());
                System.out.println("Code: " + c2.getNodeRepresentation());
                if (c2.getName() == null || c2.getName().getLocalizedString() == null) continue;
                for (LocalizedStringType ls : c2.getName().getLocalizedString()) {
                    System.out.println("Display: " + ls.getValue() + "(lang = " + ls.getLang() + ")");
                }
            }
            System.out.println("\nExternalIdentifiers:");
            e2 = null;
            for (ExternalIdentifierType e2 : reg.getExternalIdentifier()) {
                System.out.println("UUID: " + e2.getIdentificationScheme());
                System.out.println("ID: " + e2.getValue());
                if (e2.getName() == null || e2.getName().getLocalizedString() == null) continue;
                for (LocalizedStringType ls : e2.getName().getLocalizedString()) {
                    System.out.println("Display: " + ls.getValue() + "(lang = " + ls.getLang() + ")");
                }
            }
            System.out.println("\n");
        }
        System.out.println("\n\nAssociations ***************************");
        Iterator i = assocs.iterator();
        AssociationType1 a = null;
        while (i.hasNext()) {
            a = (AssociationType1)i.next();
            System.out.println("UUID: " + a.getAssociationType());
            System.out.println("source: " + a.getSourceObject());
            System.out.println("target: " + a.getTargetObject());
        }
        System.out.println("\n\nClassifications ***************************");
        i = cls.iterator();
        c2 = null;
        while (i.hasNext()) {
            c2 = (ClassificationType)i.next();
            System.out.println("ClassifiedObject: " + c2.getClassifiedObject());
            System.out.println("ClassificationNode: " + c2.getClassificationNode());
            System.out.println("UUID: " + c2.getClassificationScheme());
            System.out.println("Code: " + c2.getNodeRepresentation());
            if (c2.getName() == null || c2.getName().getLocalizedString() == null) continue;
            for (LocalizedStringType ls : c2.getName().getLocalizedString()) {
                System.out.println("Display: " + ls.getValue() + "(lang = " + ls.getLang() + ")");
            }
        }
        System.out.println("\nDONE PRINT\n");
        System.out.println("Begin printing Submit Request back to file.");
        root = RegistryFactory.eINSTANCE.createDocumentRoot();
        root.setSubmitObjectsRequest(req);
        Resource resources3 = new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
        resources3.getContents().add((Object)root);
        System.out.println("writing *" + args[1] + "*");
        resources3.save((OutputStream)new FileOutputStream(args[1]), null);
        System.out.println("Done saving Submit request to file.");
        resources3.unload();
        System.out.println("Unload resources.");
        System.out.println("DONE TEST *******************************");
    }
}

