/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pdq.consumer;

import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.FieldList;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.CPMessageBuilder;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerResponse;

public class PdqConsumerQuery
extends PixPdqMessage {
    private static Logger logger;
    private MessageManager globalFactory;
    private CPConformanceProfile cpProfile = null;
    private static final int version = 8;
    public static final String MSH_9_1_PDQ = "Q22";
    public static final String MSH_9_2_PDQ = "QBP";
    public static final String MSH_9_3_PDQ = "QBP_Q21";
    public static final String QPD_1_1_PDQ = "Q22";
    public static final String QPD_1_2_PDQ = "Find Candidates";
    public static final String QPD_1_3_PDQ = "HL7";
    public static final int MAX_PATIENTS_RETURNED = 10;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public PdqConsumerQuery(MessageManager globalFactory, CPConformanceProfile cpProfile) throws PdqConsumerException {
        this.nodeType = 2;
        this.globalFactory = globalFactory;
        this.cpProfile = cpProfile;
        this.createQueryMsg();
    }

    public void changeDefaultMessageQueryName(String identifier, String text, String codingSystem, String alternateIdentifier, String alternateText, String alternateCodingSystem) throws PdqConsumerException {
        if (identifier != null && identifier.length() > 0) {
            try {
                this.setField("QPD-1-1", identifier);
            }
            catch (PixPdqMessageException e) {
                throw new PdqConsumerException(e);
            }
        } else {
            throw new PdqConsumerException("PdqConsumerQuery: changeDefaultMessageQueryName - " + identifier + " invalid parameter ");
        }
        try {
            this.setField("QPD-1-2", text);
            this.setField("QPD-1-3", codingSystem);
            this.setField("QPD-1-4", alternateIdentifier);
            this.setField("QPD-1-5", alternateText);
            this.setField("QPD-1-6", alternateCodingSystem);
        }
        catch (PixPdqMessageException e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: changeDefaultMessageQueryName ");
        }
    }

    public void changeDefaultQueryTag(String tag) throws PdqConsumerException {
        if (tag != null && tag.length() > 0) {
            try {
                this.setField("QPD-2", tag);
            }
            catch (PixPdqMessageException e) {
                throw new PdqConsumerException(e);
            }
        } else {
            throw new PdqConsumerException("PdqConsumerQuery: changeDefaultQueryTag - " + tag + " invalid parameter ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: changeDefaultQueryTag ");
        }
    }

    public void changeDefaultWhatDomainsReturned(String namespaceId, String universalId, String universalIdType) throws PdqConsumerException {
        if (PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
            try {
                this.getSegments().getByCodeAndIndex("QPD", 1).forceField(7).forceComponent(3).forceComponent(2);
            }
            catch (HL7V2Exception e) {
                throw new PdqConsumerException(e);
            }
            try {
                this.setField("QPD-8-4-1", namespaceId);
                this.setField("QPD-8-4-2", universalId);
                this.setField("QPD-8-4-3", universalIdType);
            }
            catch (PixPdqMessageException e) {
                throw new PdqConsumerException(e);
            }
        }
        throw new PdqConsumerException("PdqConsumerQuery: changeDefaultWhatDomainsReturned - " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination ");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: changeDefaultWhatDomainsReturned ");
        }
    }

    public void addQueryPatientID(String idNumber, String namespaceId, String universalId, String universalIdType) throws PdqConsumerException {
        if (idNumber != null && idNumber.length() > 0) {
            this.addOptionalDemographicSearch("PID-3-1", idNumber);
            if (PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                this.addOptionalDemographicSearch("PID-3-4-1", namespaceId);
                this.addOptionalDemographicSearch("PID-3-4-2", universalId);
                this.addOptionalDemographicSearch("PID-3-4-3", universalIdType);
            } else {
                logger.info((Object)("PdqConsumerQuery: addQueryPatientID - " + idNumber + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination "));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: addQueryPatientID ");
        }
    }

    public void addQueryPatientNameFamilyName(String familyName) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-5-1", familyName);
    }

    public void addQueryPatientNameGivenName(String givenName) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-5-2", givenName);
    }

    public void addQueryPatientNameOtherName(String otherName) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-5-3", otherName);
    }

    public void addQueryPatientNameSuffix(String suffix) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-5-4", suffix);
    }

    public void addQueryPatientNamePrefix(String prefix) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-5-5", prefix);
    }

    public void addQueryPatientNameDegree(String degree) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-5-6", degree);
    }

    public void addQueryPatientDateOfBirth(String dob) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-7-1", dob);
    }

    public void addQueryPatientSex(String sex) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-8", sex);
    }

    public void addQueryPatientAddressStreetAddress(String address) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-1", address);
    }

    public void addQueryPatientAddressOtherDesignation(String address) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-2", address);
    }

    public void addQueryPatientAddressCity(String city) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-3", city);
    }

    public void addQueryPatientAddressStateOrProvince(String stateOrProvince) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-4", stateOrProvince);
    }

    public void addQueryPatientAddressZipOrPostalCode(String zipOrPostalCode) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-5", zipOrPostalCode);
    }

    public void addQueryPatientAddressCountry(String country) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-6", country);
    }

    public void addQueryPatientAddressType(String type) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-7", type);
    }

    public void addQueryPatientAddressOtherGeographicDesignation(String otherDesignation) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-8", otherDesignation);
    }

    public void addQueryPatientAddressCountyParishCode(String countyParishCode) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-9", countyParishCode);
    }

    public void addQueryPatientAddressCensusTract(String censusTract) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-11-10", censusTract);
    }

    public void addQueryPatientPhoneHomeUnformattedTelephoneNumber(String homePhone) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-13-1", homePhone);
    }

    public void addQueryPatientPhoneBusinessUnformattedTelephoneNumber(String businessPhone) throws PdqConsumerException {
        this.addOptionalDemographicSearch("PID-14-1", businessPhone);
    }

    public void addQueryPatientAccountNumberId(String accountNumberId, String namespaceId, String universalId, String universalIdType) throws PdqConsumerException {
        if (accountNumberId != null && accountNumberId.length() > 0) {
            this.addOptionalDemographicSearch("PID-18-1", accountNumberId);
            if (PixPdqMessageUtilities.isHDParamValid((String)namespaceId, (String)universalId, (String)universalIdType)) {
                this.addOptionalDemographicSearch("PID-18-4-1", namespaceId);
                this.addOptionalDemographicSearch("PID-18-4-2", universalId);
                this.addOptionalDemographicSearch("PID-18-4-3", universalIdType);
            } else {
                logger.info((Object)("PdqConsumerQuery: addQueryPatientAccountNumberId - " + accountNumberId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " invalid parameter combination "));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: addQueryPatientAccountNumberId ");
        }
    }

    public void addOptionalDemographicSearch(String path, String data) throws PdqConsumerException {
        StringTokenizer st = new StringTokenizer(path, "-");
        String segmentCode = st.nextToken();
        if (segmentCode == null) {
            st = new StringTokenizer(path, ".");
            segmentCode = st.nextToken();
        }
        if (segmentCode == null) {
            throw new PdqConsumerException("PdqConsumerQuery: addOptionalDemographicSearch - unrecognized segment " + path);
        }
        if (segmentCode.compareTo("PID") != 0 && segmentCode.compareTo("PD1") != 0) {
            throw new PdqConsumerException("PdqConsumerQuery: addOptionalDemographicSearch - only supporting PID and PD1 segments, not " + segmentCode);
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("@");
            sb.append(path.replaceAll("-", "."));
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(2).forceComponent(1);
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(2).getComponents().item(0).forceElement("2");
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(2).getComponents().item(1).forceElement("2");
            Field field = this.getSegments().getByCodeAndIndex("QPD", 1).getFields().item(2).addRepeat(true);
            field.forceElement("1").setAsString(sb.toString());
            field.forceElement("2").setAsString(data);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PdqConsumerQuery: addOptionalDemographicSearch - " + sb.toString() + "^" + data));
            }
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: addOptionalDemographicSearch ");
        }
    }

    public void addOptionalQuantityLimit(int quantity) throws PdqConsumerException {
        if (quantity > 0) {
            try {
                this.setField("RCP-2-1", Integer.toString(quantity));
                this.setField("RCP-2-2-1", "RD");
            }
            catch (PixPdqMessageException e) {
                throw new PdqConsumerException(e);
            }
        } else {
            throw new PdqConsumerException("PdqConsumerQuery: addOptionalQuantityLimit - quantity " + Integer.toString(quantity) + " must be greater than 0. ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: addOptionalQuantityLimit ");
        }
    }

    public void addOptionalContinuationPointer(PdqConsumerResponse response) throws PdqConsumerException {
        if (response.getSegments().countByCode("DSC") < 1) {
            return;
        }
        try {
            this.getSegments().dropByCode("DSC");
            this.getSegments().add("DSC");
            FieldList fldList = response.getSegments().getByCodeAndIndex("DSC", 1).getFields();
            this.forceElement("DSC-1").setAsString(fldList.item(0).getAsString());
            this.forceElement("DSC-2").setAsString(fldList.item(1).getAsString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"addOptionalContinuationPointer:");
                logger.debug((Object)("DSC-1 = " + fldList.item(0).getAsString()));
                logger.debug((Object)("DSC-2 = " + fldList.item(1).getAsString()));
            }
        }
        catch (HL7V2Exception hL7V2Exception) {
            throw new PdqConsumerException("PdqConsumerQuery: addOptionalContinuationPointer ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: addOptionalContinuationPointer ");
        }
    }

    private void createQueryMsg() throws PdqConsumerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerQuery: createQueryMsg - Entry ");
        }
        try {
            this.clear();
            if (this.globalFactory != null) {
                this.setDefinitions(this.globalFactory.getVersionDefinitions());
            }
            this.setVersion(8);
            this.setEvent("Q22");
            this.setMessageType(MSH_9_2_PDQ);
            this.addMSHFromFields();
            if (this.cpProfile != null) {
                CPMessageBuilder builder = new CPMessageBuilder();
                builder.build(8, this.cpProfile.getInteractions().itemInteraction(0).getStaticDefinition(), true, (Message)this);
                this.getSegments().dropByCode("DSC");
            } else {
                this.getSegments().add("QPD");
                this.getSegments().add("RCP");
                this.setField("MSH-3-1", "IBMPixSource");
                this.setField("MSH-4-1", "IBM");
                this.setField("MSH-5-1", "PixMgr");
                this.setField("MSH-6-1", "IBM");
                this.setField("MSH-11-1", "P");
                this.setField("MSH-12", VersionDefnList.display((int)8));
                this.setField("MSH-18-1", "ASCII");
                this.setField("QPD-1-1", "Q22");
                this.setField("QPD-1-2", QPD_1_2_PDQ);
                this.setField("RCP-1", "I");
            }
            this.setField("MSH-7", PixPdqMessageUtilities.getCurrentDateTimeString());
            this.setNonNullElement("MSH-10", PixPdqMessageUtilities.getRandomFieldValue((int)20));
            this.setNonNullElement("QPD-2", PixPdqMessageUtilities.getRandomFieldValue((int)32));
            this.setNonNullElement("RCP-2-1", Integer.toString(10));
            this.setField("RCP-2-2-1", "RD");
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        catch (PixPdqMessageException e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug((Object)("PdqConsumerQuery: createQueryMsg \r" + PixPdqMessageUtilities.msgToString((Message)this)));
            }
            catch (PixPdqMessageException pixPdqMessageException) {
                logger.debug((Object)"PdqConsumerQuery: createQueryMsg \r");
            }
        }
    }
}

