/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.transport;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPMessage;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.log4j.Logger;

public class SoapSerializer {
    private static final Logger logger;
    private static final String BOUNDARY_START_MSG = "MIMEBoundary__";
    private static final String CRLF = "\r\n";
    private String defaultContentId;
    private String mimeBoundaryMsg;
    private SOAPMessage msg;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.atna.transport.SoapSerializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public SoapSerializer(SOAPMessage msg) {
        this.msg = msg;
        this.defaultContentId = UUIDGenerator.getUUID();
        this.mimeBoundaryMsg = BOUNDARY_START_MSG + UUIDGenerator.getUUID();
        this.mimeBoundaryMsg = this.mimeBoundaryMsg.replaceAll("urn:uuid:", "");
        this.setMessageStart();
    }

    public String getMessageBoundary() {
        return this.mimeBoundaryMsg;
    }

    private void setMessageStart() {
        String msgContentId = "";
        try {
            msgContentId = this.msg.getSOAPPart().getMimeHeader("Content-id")[0];
        }
        catch (Exception exception) {}
        if (msgContentId == null || msgContentId.equals("")) {
            msgContentId = this.defaultContentId;
        }
        this.defaultContentId = msgContentId;
    }

    public String getMessageStart() {
        return this.defaultContentId;
    }

    public byte[] serialize() throws Exception {
        if (this.msg.countAttachments() > 0) {
            return this.serializeWithAttachments();
        }
        logger.info((Object)"Starting SOAP Message Serialization");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.msg.writeTo((OutputStream)out);
        logger.info((Object)"SOAP message serialized successfully.  Exiting SOAP Serializer");
        return out.toByteArray();
    }

    public byte[] serializeWithAttachments() throws Exception {
        logger.info((Object)"Starting SOAP Message Serialization with Attachments");
        String msgContentId = this.getMessageStart();
        String msgBoundary = this.getMessageBoundary();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Writing SOAP Envelope");
        }
        out.write(CRLF.getBytes());
        out.write(new String("--" + msgBoundary).getBytes());
        out.write(CRLF.getBytes());
        out.write(new String("Content-Transfer-Encoding: 8bit").getBytes());
        out.write(CRLF.getBytes());
        out.write(new String("Content-Type: text/xml; charset=UTF-8").getBytes());
        out.write(CRLF.getBytes());
        out.write(new String("Content-Id: <" + msgContentId + ">").getBytes());
        out.write(CRLF.getBytes());
        out.write(CRLF.getBytes());
        this.msg.writeTo((OutputStream)out);
        out.write(CRLF.getBytes());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("SOAP Envelope Written: " + out.toString()));
        }
        out.write(new String("--" + msgBoundary).getBytes());
        out.write(CRLF.getBytes());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Writing SOAP Attachments");
        }
        Iterator attachmentIterator = this.msg.getAttachments();
        int count = 1;
        while (attachmentIterator.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)attachmentIterator.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Writing Attachment " + count));
            }
            out.write(new String("Content-Type: " + attachment.getContentType()).getBytes());
            out.write(CRLF.getBytes());
            out.write(new String("content-transfer-encoding: binary").getBytes());
            out.write(CRLF.getBytes());
            out.write(new String("Content-Id: <" + attachment.getContentId() + ">").getBytes());
            out.write(CRLF.getBytes());
            out.write(CRLF.getBytes());
            out.write(new String((String)attachment.getContent()).getBytes());
            out.write(CRLF.getBytes());
            out.write(new String("--" + msgBoundary + "--").getBytes());
            out.write(CRLF.getBytes());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attachment " + count + " written"));
            }
            ++count;
        }
        logger.info((Object)"SOAP message serialized successfully.  Exiting SOAP Serializer");
        return out.toByteArray();
    }
}

