/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pix.source;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.message.ParsingOptions;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.Client;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.pix.source.PixMsgAdmitInpatient;
import org.eclipse.ohf.ihe.pix.source.PixMsgMergePatient;
import org.eclipse.ohf.ihe.pix.source.PixMsgPreadmitInpatient;
import org.eclipse.ohf.ihe.pix.source.PixMsgRegisterOutpatient;
import org.eclipse.ohf.ihe.pix.source.PixMsgUpdatePatient;
import org.eclipse.ohf.ihe.pix.source.PixSourceException;
import org.eclipse.ohf.ihe.pix.source.PixSourceResponse;

public class PixSource
extends Client {
    private static Logger logger;
    private static final String MSH_CONTROL_ID = "MSH-10";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.pix.source.PixSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public PixSource() throws ClientException {
    }

    public PixSource(InputStream conformanceProfile) throws ClientException {
        super(conformanceProfile);
    }

    public PixMsgAdmitInpatient admitInpatient(String patientId) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Admit Inpatient A01 message - Entry patientId: " + patientId));
        }
        PixMsgAdmitInpatient admitMsg = new PixMsgAdmitInpatient(this.getMessageManager(), this.getCPProfile(), patientId, null, null, null);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = admitMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Admit Inpatient A01 message - Exit patientId: " + patientId + " controlId: " + controlId));
        }
        return admitMsg;
    }

    public PixMsgAdmitInpatient admitInpatient(String patientId, String namespaceId, String universalId, String universalIdType) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Admit Inpatient A01 message - Entry patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType));
        }
        PixMsgAdmitInpatient admitMsg = new PixMsgAdmitInpatient(this.getMessageManager(), this.getCPProfile(), patientId, namespaceId, universalId, universalIdType);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = admitMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Admit Inpatient A01 message - Exit patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " controlId: " + controlId));
        }
        return admitMsg;
    }

    public String sendAdmission(String rawHL7, boolean verify, String auditUser) throws PixSourceException {
        String pixRsp = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Admit Inpatient A01 message - Entry  run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendHL7(rawHL7, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixSource: send Admit Inpatient A01 message - Exit ");
        }
        return pixRsp;
    }

    public Message sendAdmission(Message msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        Message pixRsp = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Admit Inpatient A01 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendMsg(msg, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Admit Inpatient A01 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixSourceResponse sendAdmission(PixMsgAdmitInpatient msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Admit Inpatient A01 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        PixSourceResponse pixRsp = this.sendPixFeed((Message)msg, verify, auditUser);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Admit Inpatient A01 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixMsgRegisterOutpatient registerOutpatient(String patientId) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Register Outpatient A04 message - Entry patientId: " + patientId));
        }
        PixMsgRegisterOutpatient regMsg = new PixMsgRegisterOutpatient(this.getMessageManager(), this.getCPProfile(), patientId, null, null, null);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = regMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Register Outpatient A04 message - Exit patientId: " + patientId + " controlId: " + controlId));
        }
        return regMsg;
    }

    public PixMsgRegisterOutpatient registerOutpatient(String patientId, String namespaceId, String universalId, String universalIdType) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Register Outpatient A04 message - Entry patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType));
        }
        PixMsgRegisterOutpatient regMsg = new PixMsgRegisterOutpatient(this.getMessageManager(), this.getCPProfile(), patientId, namespaceId, universalId, universalIdType);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = regMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Register Outpatient A04 message - Exit patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " controlId: " + controlId));
        }
        return regMsg;
    }

    public String sendRegistration(String rawHL7, boolean verify, String auditUser) throws PixSourceException {
        String pixRsp = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Register Outpatient A04 message - Entry  run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendHL7(rawHL7, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixSource: send Register Outpatient A04 message - Exit ");
        }
        return pixRsp;
    }

    public Message sendRegistration(Message msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        Message pixRsp = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Register Outpatient A04 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendMsg(msg, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Register Outpatient A04 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixSourceResponse sendRegistration(PixMsgRegisterOutpatient msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Register Outpatient A04 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        PixSourceResponse pixRsp = this.sendPixFeed((Message)msg, verify, auditUser);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Register Outpatient A04 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixMsgPreadmitInpatient preadmitInpatient(String patientId) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Preadmit Inpatient A05 message - Entry patientId: " + patientId));
        }
        PixMsgPreadmitInpatient preadmitMsg = new PixMsgPreadmitInpatient(this.getMessageManager(), this.getCPProfile(), patientId, null, null, null);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = preadmitMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Preadmit Inpatient A05 message - Exit patientId: " + patientId + " controlId: " + controlId));
        }
        return preadmitMsg;
    }

    public PixMsgPreadmitInpatient preadmitInpatient(String patientId, String namespaceId, String universalId, String universalIdType) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Preadmit Inpatient A05 message - Entry patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType));
        }
        PixMsgPreadmitInpatient preadmitMsg = new PixMsgPreadmitInpatient(this.getMessageManager(), this.getCPProfile(), patientId, namespaceId, universalId, universalIdType);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = preadmitMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Preadmit Inpatient A05 message - Exit patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " controlId: " + controlId));
        }
        return preadmitMsg;
    }

    public String sendPreAdmission(String rawHL7, boolean verify, String auditUser) throws PixSourceException {
        String pixRsp = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Preadmit Inpatient A05 message - Entry  run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendHL7(rawHL7, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixSource: send Preadmit Inpatient A05 message - Exit ");
        }
        return pixRsp;
    }

    public Message sendPreAdmission(Message msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        Message pixRsp = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Preadmit Inpatient A05 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendMsg(msg, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Preadmit Inpatient A05 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixSourceResponse sendPreAdmission(PixMsgPreadmitInpatient msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Preadmit Inpatient A05 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        PixSourceResponse pixRsp = this.sendPixFeed((Message)msg, verify, auditUser);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Preadmit Inpatient A05 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixMsgUpdatePatient updatePatient(String patientId, String patientClass) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Update A08 message - Entry patientId: " + patientId + "class: " + patientClass));
        }
        PixMsgUpdatePatient updMsg = new PixMsgUpdatePatient(this.getMessageManager(), this.getCPProfile(), patientId, null, null, null, patientClass);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = updMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Update A08 message - Exit patientId: " + patientId + "class: " + patientClass + " controlId: " + controlId));
        }
        return updMsg;
    }

    public PixMsgUpdatePatient updatePatient(String patientId, String namespaceId, String universalId, String universalIdType, String patientClass) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Update Patient A08 message - Entry patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " class: " + patientClass));
        }
        PixMsgUpdatePatient updMsg = new PixMsgUpdatePatient(this.getMessageManager(), this.getCPProfile(), patientId, namespaceId, universalId, universalIdType, patientClass);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = updMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Update Patient A08 message - Exit patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + "class: " + patientClass + " controlId: " + controlId));
        }
        return updMsg;
    }

    public String sendUpdate(String rawHL7, boolean verify, String auditUser) throws PixSourceException {
        String pixRsp = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Update Patient A08 message - Entry  run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendHL7(rawHL7, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixSource: send Update Patient A08 message - Exit ");
        }
        return pixRsp;
    }

    public Message sendUpdate(Message msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        Message pixRsp = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Update Patient A08 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendMsg(msg, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Update Patient A08 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixSourceResponse sendUpdate(PixMsgUpdatePatient msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Update Patient A08 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        PixSourceResponse pixRsp = this.sendPixFeed((Message)msg, verify, auditUser);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Update Patient A08 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixMsgMergePatient mergePatient(String patientId, String patientClass, String priorId) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Merge A40 message - Entry patientId: " + patientId + " class: " + patientClass + " priorId: " + priorId));
        }
        PixMsgMergePatient mergeMsg = new PixMsgMergePatient(this.getMessageManager(), this.getCPProfile(), patientId, null, null, null, patientClass, priorId);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = mergeMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Merge A40 message - Exit patientId: " + patientId + "class: " + patientClass + " priorId: " + priorId + " controlId: " + controlId));
        }
        return mergeMsg;
    }

    public PixMsgMergePatient mergePatient(String patientId, String namespaceId, String universalId, String universalIdType, String patientClass, String priorId) throws PixSourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: create Merge Patient A40 message - Entry patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " class: " + patientClass + " priorId: " + priorId));
        }
        PixMsgMergePatient mergeMsg = new PixMsgMergePatient(this.getMessageManager(), this.getCPProfile(), patientId, namespaceId, universalId, universalIdType, patientClass, priorId);
        if (logger.isDebugEnabled()) {
            String controlId = null;
            try {
                controlId = mergeMsg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: create Merge Patient A40 message - Exit patient: " + patientId + ", " + namespaceId + ", " + universalId + ", " + universalIdType + " class: " + patientClass + " priorId: " + priorId + " controlId: " + controlId));
        }
        return mergeMsg;
    }

    public String sendMerge(String rawHL7, boolean verify, String auditUser) throws PixSourceException {
        String pixRsp = new String();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Merge Patient A40 message - Entry  run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendHL7(rawHL7, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PixSource: send Merge Patient A40 message - Exit ");
        }
        return pixRsp;
    }

    public Message sendMerge(Message msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        Message pixRsp = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Merge Patient A40 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        try {
            pixRsp = this.sendMsg(msg, verify, auditUser, "OHF_PixSource");
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Merge Patient A40 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    public PixSourceResponse sendMerge(PixMsgMergePatient msg, boolean verify, String auditUser) throws PixSourceException {
        String controlId = null;
        if (logger.isDebugEnabled()) {
            try {
                controlId = msg.getElement(MSH_CONTROL_ID).getAsString();
            }
            catch (HL7V2Exception hL7V2Exception) {}
            logger.debug((Object)("PixSource: send Merge Patient A40 message - Entry controlId: " + controlId + " run verification? " + verify + " user: " + auditUser));
        }
        PixSourceResponse pixRsp = this.sendPixFeed((Message)msg, verify, auditUser);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PixSource: send Merge Patient A40 message - Exit controlId: " + controlId));
        }
        return pixRsp;
    }

    private PixSourceResponse sendPixFeed(Message feed, boolean verify, String auditUser) throws PixSourceException {
        String hl7;
        Message msgResponse = null;
        PixSourceResponse feedResponse = new PixSourceResponse(this.getMessageManager());
        try {
            msgResponse = this.sendMsg(feed, verify, auditUser, "OHF_PixSource");
            hl7 = PixPdqMessageUtilities.msgToString((Message)msgResponse);
        }
        catch (ClientException e) {
            throw new PixSourceException(e);
        }
        catch (PixPdqMessageException e) {
            throw new PixSourceException(e);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(hl7.getBytes());
        ParsingOptions pOptions = new ParsingOptions();
        try {
            pOptions.setFormat(1);
            if (hl7.compareTo("") == 0) {
                return feedResponse;
            }
            this.getMessageManager().load((InputStream)inStream, (Message)feedResponse, pOptions);
            feedResponse.init();
        }
        catch (HL7V2Exception e) {
            throw new PixSourceException(e);
        }
        return feedResponse;
    }
}

