/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentGroup;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTable;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPDocument
extends CPElement {
    public static final int DOCUMENT_TYPE_UNKNOWN = 0;
    public static final int DOCUMENT_TYPE_PROFILE = 1;
    public static final int DOCUMENT_TYPE_MESSAGE = 2;
    public static final int DOCUMENT_TYPE_SEGMENTGROUP = 3;
    public static final int DOCUMENT_TYPE_SEGMENT = 4;
    public static final int DOCUMENT_TYPE_FIELD = 5;
    public static final int DOCUMENT_TYPE_COMPONENT = 6;
    public static final int DOCUMENT_TYPE_TABLE = 7;
    private int hl7Version;
    private String name;
    private String derivation;
    private int documentType;
    private CPElement content;

    public static String displayDocumentType(int value) {
        switch (value) {
            case 1: {
                return "Profile";
            }
            case 2: {
                return "Message";
            }
            case 3: {
                return "Segment Group";
            }
            case 4: {
                return "Segment";
            }
            case 5: {
                return "Field";
            }
            case 6: {
                return "Component";
            }
            case 7: {
                return "Table";
            }
        }
        return "unknown";
    }

    public CPDocument() {
        super(null);
    }

    public void clear() {
        this.hl7Version = 0;
        this.name = null;
        this.derivation = null;
        this.documentType = 0;
        this.content = null;
    }

    public int getHl7Version() {
        return this.hl7Version;
    }

    public void setHl7Version(int hl7Version) {
        this.hl7Version = hl7Version;
    }

    public CPElement getContent() {
        return this.content;
    }

    public void setContent(CPElement model) throws HL7V2Exception {
        this.documentType = this.documentTypeForElementType(model.elementType());
        this.content = model;
    }

    public int documentTypeForElementType(int type) throws HL7V2Exception {
        switch (type) {
            case 3: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 7;
            }
        }
        throw new HL7V2Exception("There is no document type for the element type " + CPElement.typeToString(type), 25);
    }

    public int elementTypeForDocumentType(int type) throws HL7V2Exception {
        switch (type) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 13;
            }
            case 7: {
                return 14;
            }
        }
        throw new HL7V2Exception("Invalid document type " + Integer.toString(type), 25);
    }

    public int getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(int documentType) {
        this.documentType = documentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDerivation() {
        return this.derivation;
    }

    public void setDerivation(String derivedFrom) {
        this.derivation = derivedFrom;
    }

    public void defaults() {
        this.hl7Version = 7;
        this.name = null;
        this.derivation = null;
        this.documentType = 0;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        CPDocument doc = (CPDocument)source;
        this.content = doc.content.cloneElement();
        this.hl7Version = doc.hl7Version;
        this.name = doc.name;
        this.derivation = doc.derivation;
        this.documentType = doc.documentType;
    }

    public CPDocument cloneDocument() throws CloneNotSupportedException {
        return (CPDocument)this.clone();
    }

    public int elementType() {
        return 2;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{1, 29, 28});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 1: {
                return this.getName();
            }
            case 29: {
                return this.getDerivation();
            }
            case 28: {
                return Integer.toString(this.getHl7Version());
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 1: {
                this.setName(value);
                break;
            }
            case 29: {
                this.setDerivation(value);
                break;
            }
            case 28: {
                this.setHl7Version(Integer.parseInt(value));
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Document";
    }

    public CPConformanceProfile getProfile() {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on token \"==\", = expected\n");
    }

    public CPStaticDefinition getMessage() {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on token \"==\", = expected\n");
    }

    public CPSegmentGroup getSegmentGroup() {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on token \"==\", = expected\n");
    }

    public CPSegment getSegment() {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on token \"==\", = expected\n");
    }

    public CPField getField() {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on token \"==\", = expected\n");
    }

    public CPComponent getComponent() {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on token \"==\", = expected\n");
    }

    public CPTable getTable() {
        throw new Error("Unresolved compilation problem: \n\tSyntax error on token \"==\", = expected\n");
    }

    public void createContent() throws HL7V2Exception {
        this.content = this.createContentByType();
    }

    private CPElement createContentByType() throws HL7V2Exception {
        switch (this.documentType) {
            case 1: {
                return new CPConformanceProfile();
            }
            case 2: {
                return new CPStaticDefinition(this);
            }
            case 3: {
                return new CPSegmentGroup(this);
            }
            case 4: {
                return new CPSegment(this);
            }
            case 5: {
                return new CPField(this);
            }
            case 6: {
                return new CPComponent(this);
            }
            case 7: {
                return new CPTable(this);
            }
        }
        throw new HL7V2Exception("unknown content type", 18);
    }
}

