/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPCell;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponents;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPFields;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPField
extends CPCell {
    private String itemNo;
    private int min;
    private int max;
    private CPComponents components;

    public CPField(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.itemNo = null;
        this.min = -1;
        this.max = -1;
        this.components = new CPComponents(this);
    }

    public String getItemNo() {
        return this.itemNo;
    }

    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public CPComponents getComponents() {
        return this.components;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{31, 25, 26, 46});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 31: {
                return this.getItemNo();
            }
            case 25: {
                return Integer.toString(this.getMin());
            }
            case 26: {
                return Integer.toString(this.getMax());
            }
            case 46: {
                return this.getCardinality();
            }
        }
        return super.getProperty(id);
    }

    public String getCardinality() {
        if (this.max < 0) {
            return String.valueOf(Integer.toString(this.min)) + "..*";
        }
        return String.valueOf(Integer.toString(this.min)) + ".." + Integer.toString(this.max);
    }

    public void setCardinality(String value) throws HL7V2Exception {
        String[] bits = StringUtils.split((String)value, (String)"..");
        this.condition(bits.length == 2 && StringUtils.isNumeric((String)bits[0]) && (StringUtils.isNumeric((String)bits[1]) || bits[1].equals("*")), "cardinality " + value + " is not valid", 19);
        this.min = Integer.parseInt(bits[0]);
        this.max = bits[1].equals("*") ? -1 : Integer.parseInt(bits[1]);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 31: {
                this.setItemNo(value);
                break;
            }
            case 25: {
                this.setMin(Integer.parseInt(value));
                break;
            }
            case 26: {
                this.setMax(Integer.parseInt(value));
                break;
            }
            case 46: {
                this.setCardinality(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Field";
    }

    public void defaults() {
        super.defaults();
        this.itemNo = null;
        this.min = 0;
        this.max = 1;
    }

    public int elementType() {
        return 12;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPField src = (CPField)source;
        if (src.components == null) {
            this.components = null;
        } else {
            this.components = src.components.cloneComponents();
            this.components.setOwner(this);
        }
        this.itemNo = src.itemNo;
        this.min = src.min;
        this.max = src.max;
    }

    public CPField cloneField() throws CloneNotSupportedException {
        return (CPField)this.clone();
    }

    public boolean isRequired() {
        return this.min > 0 || super.isRequired();
    }

    public int getIndex() {
        return ((CPFields)this.getOwner()).indexOf(this);
    }
}

