/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPDescribed;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTableItems;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPTable
extends CPDescribed {
    private String tableType;
    private String codeSystem;
    private String id;
    private String name;
    private CPTableItems items = new CPTableItems(this);

    public CPTable(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.tableType = null;
        this.codeSystem = null;
        this.id = null;
        this.name = null;
        this.items.clear();
    }

    public String getCodeSystem() {
        return this.codeSystem;
    }

    public void setCodeSystem(String codeSystem) {
        this.codeSystem = codeSystem;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public CPTableItems getItems() {
        return this.items;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{1, 11, 12, 13});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 1: {
                return this.getName();
            }
            case 11: {
                return this.getId();
            }
            case 12: {
                return this.getTableType();
            }
            case 13: {
                return this.getCodeSystem();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 1: {
                this.setName(value);
                break;
            }
            case 11: {
                this.setId(value);
                break;
            }
            case 12: {
                this.setTableType(value);
                break;
            }
            case 13: {
                this.setCodeSystem(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Table";
    }

    public void defaults() {
        super.defaults();
        this.tableType = null;
        this.codeSystem = null;
        this.id = null;
        this.name = null;
    }

    public int elementType() {
        return 14;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPTable src = (CPTable)source;
        if (src.items == null) {
            this.items = null;
        } else {
            this.items = src.items.cloneTableItems();
            this.items.setOwner(this);
        }
        this.tableType = src.tableType;
        this.codeSystem = src.codeSystem;
        this.id = src.id;
        this.name = src.name;
    }

    public CPTable cloneTable() throws CloneNotSupportedException {
        return (CPTable)this.clone();
    }
}

