/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.model;

import org.eclipse.ohf.hl7v2.core.definitions.model.NamedDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;

public class TableDefn
extends NamedDefn {
    private static final long serialVersionUID = 8400167023365097429L;
    private int id;
    private TableItemDefnList items = new TableItemDefnList();

    public TableDefn(VersionDefn version) {
        super(version);
    }

    public TableItemDefnList getItems() {
        return this.items;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String typeName() {
        return "tbl";
    }

    public boolean isValidTableCode(String value) {
        if (value == null) {
            return false;
        }
        if (this.id == 396) {
            if (value.equals("L") || value.substring(2).equals("99")) {
                return true;
            }
            int i = 0;
            while (i < this.items.size()) {
                TableItemDefn item = this.items.item(i);
                if (item.getName().equalsIgnoreCase(value)) {
                    return true;
                }
                if (value.length() > 5 && item.getName().length() > 5 && item.getName().substring(item.getName().length() - 4, item.getName().length()).equals("nnnn") && item.getName().substring(0, item.getName().length() - 4).equals(value.substring(0, item.getName().length() - 4))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.items.itemByNameNoCase(value) != null;
    }
}

