/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.utilities;

import org.eclipse.ohf.utilities.Iso8601DateUtilities;

public class HL7V2DateUtilities
extends Iso8601DateUtilities {
    public String checkDateByType(String content, String datatype, int version) {
        return this.checkDateByType(content, datatype, version, 2);
    }

    public String checkDateByType(String content, String datatype, int version, int timezone) {
        if (datatype == null) {
            return null;
        }
        if (datatype.equals("DT")) {
            if (version < 5) {
                return this.checkDateByMask(content, "YYYYMMDD", 3);
            }
            return this.checkDateByMask(content, "YYYYYMM[DD]", 3);
        }
        if (datatype.equals("TM")) {
            if (version < 5) {
                return this.checkDateByMask(content, "HHNN[SS[.SSSS]]", timezone);
            }
            return this.checkDateByMask(content, "HH[NN[SS[.S[S[S[S]]]]]]", timezone);
        }
        if (datatype.equals("TS")) {
            if (version < 8) {
                return this.checkDateByMask(content, "YYYY[MM[DD[HHNN[SS[.S[S[S[S]]]]]]]]", timezone);
            }
            return this.checkDateByMask(content, "YYYY[MM[DD[HH[NN[SS[.S[S[S[S]]]]]]]]]", timezone);
        }
        if (datatype.equals("DTM")) {
            return this.checkDateByMask(content, "YYYY[MM[DD[HH[NN[SS[.S[S[S[S]]]]]]]]]", timezone);
        }
        return null;
    }
}

