/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.element;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.syslog.util.SyslogUtil;
import org.eclipse.ohf.ihe.atna.audit.syslog.util.TimeStamp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EventIdentificationType {
    public static String DB_Event_Identification_Type = "event_identification";
    public static String DB_Event_Type_Code = "event_type_code";
    private Element eventIdentificationNode;
    protected CodedValueType eventID;
    protected List eventTypeCode;
    protected String eventActionCode;
    protected TimeStamp eventDateTime;
    protected int eventOutcomeIndicator;
    private Document doc;

    public EventIdentificationType() throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.newDocument();
        this.eventIdentificationNode = this.doc.createElement("EventIdentification");
    }

    public EventIdentificationType(int eventOutComeIndic) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.newDocument();
        this.eventIdentificationNode = this.doc.createElement("EventIdentification");
        this.eventActionCode = null;
        this.setEventDateTime();
        this.setEventOutcomeIndicator(eventOutComeIndic);
    }

    public void setEventID(CodedValueType value) {
        this.eventID = value;
        Element eventIDElement = this.doc.createElement("EventID");
        eventIDElement.setAttribute("code", value.getCode());
        if (value.getCodeSystem() != null && !value.getCodeSystem().equals("")) {
            eventIDElement.setAttribute("codeSystem", value.getCodeSystem());
        }
        if (value.getCodeSystemName() != null && !value.getCodeSystemName().equals("")) {
            eventIDElement.setAttribute("codeSystemName", value.getCodeSystemName());
        }
        if (value.getDisplayName() != null && !value.getDisplayName().equals("")) {
            eventIDElement.setAttribute("displayName", value.getDisplayName());
        }
        this.eventIdentificationNode.appendChild(eventIDElement);
    }

    public CodedValueType getEventID() {
        return this.eventID;
    }

    public List getEventTypeCode() {
        if (this.eventTypeCode == null) {
            this.eventTypeCode = new ArrayList();
        }
        return this.eventTypeCode;
    }

    public void setEventTypeCode(CodedValueType value) {
        this.eventTypeCode = this.getEventTypeCode();
        this.eventTypeCode.add(value);
        Element eventIDElement = this.doc.createElement("EventTypeCode");
        eventIDElement.setAttribute("code", value.getCode());
        if (value.getCodeSystem() != null && !value.getCodeSystem().equals("")) {
            eventIDElement.setAttribute("codeSystem", value.getCodeSystem());
        }
        if (value.getCodeSystemName() != null && !value.getCodeSystemName().equals("")) {
            eventIDElement.setAttribute("codeSystemName", value.getCodeSystemName());
        }
        if (value.getDisplayName() != null && !value.getDisplayName().equals("")) {
            eventIDElement.setAttribute("displayName", value.getDisplayName());
        }
        this.eventIdentificationNode.appendChild(eventIDElement);
    }

    public String getEventActionCode() {
        return this.eventActionCode;
    }

    public void setEventActionCode(String s) throws ATNAException {
        if (s.equals("C") || s.equals("c")) {
            this.eventActionCode = "C";
        } else if (s.equals("R") || s.equals("r")) {
            this.eventActionCode = "R";
        } else if (s.equals("U") || s.equals("u")) {
            this.eventActionCode = "U";
        } else if (s.equals("D") || s.equals("d")) {
            this.eventActionCode = "D";
        } else if (s.equals("E") || s.equals("e")) {
            this.eventActionCode = "E";
        } else {
            throw new ATNAException("Invalid EventActionCode", this);
        }
        this.eventIdentificationNode.setAttribute("EventActionCode", this.eventActionCode);
    }

    public TimeStamp getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(TimeStamp value) {
        this.eventDateTime = value;
        this.eventIdentificationNode.setAttribute("EventDateTime", this.eventDateTime.toString());
    }

    public void setEventDateTime() {
        this.setTime();
        this.eventIdentificationNode.setAttribute("EventDateTime", this.eventDateTime.toString());
    }

    public void setEventDateTime(String value) {
        if (value != null && !value.equals("")) {
            if (value.charAt(10) == ' ') {
                value = value.replace(value.charAt(10), 'T');
            }
            try {
                this.eventDateTime = new TimeStamp(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.eventIdentificationNode.setAttribute("EventDateTime", this.eventDateTime.toString());
        }
    }

    private void setTime() {
        if (this.eventDateTime == null) {
            this.eventDateTime = new TimeStamp();
        }
        try {
            this.eventDateTime.stringToDate(new TimeStamp().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getEventOutcomeIndicator() {
        return this.eventOutcomeIndicator;
    }

    public void setEventOutcomeIndicator(int value) throws ATNAException {
        switch (value) {
            case 0: 
            case 4: 
            case 8: 
            case 12: {
                this.eventOutcomeIndicator = value;
                this.eventIdentificationNode.setAttribute("EventOutcomeIndicator", new Integer(this.eventOutcomeIndicator).toString());
                break;
            }
            default: {
                throw new ATNAException("Invalid EventOutcomeIndicator", this);
            }
        }
    }

    public void setEventOutcomeIndicator(String value) throws ATNAException {
        this.setEventOutcomeIndicator(new Integer(value));
    }

    public String toXml() {
        return SyslogUtil.XMLElementToString(this.eventIdentificationNode);
    }

    public String toHtml() {
        StringBuffer stringHtml = new StringBuffer();
        int param = 1;
        stringHtml.append("<div class='Title EventIdentification'>Event identification :</div>" + (this.getEventActionCode() != null ? "<div class='EventIdentification_param" + param++ + " EventIdentification'>Event Action Code : " + this.getEventActionCodeName() + "(" + this.getEventActionCode() + ")</div>" : "") + "<div class='EventIdentification_param" + param++ + " EventIdentification'>Event Date Time : " + this.getEventDateTime().toString() + "</div>" + "<div class='EventIdentification_param" + param++ + " EventIdentification'>Event Outcome Indicator : " + this.getEventOutcomeIndicatorName() + "(" + this.getEventOutcomeIndicator() + ")</div>");
        if (this.getEventID() != null) {
            stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventID'>Event ID code : " + this.getEventID().getCode() + "</div>");
            if (this.getEventID().getCodeSystem() != null && !this.getEventID().getCodeSystem().trim().equals("")) {
                stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventID'>Code System :" + this.getEventID().getCodeSystem() + "</div>");
            }
            if (this.getEventID().getCodeSystemName() != null && !this.getEventID().getCodeSystem().trim().equals("")) {
                stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventID'>Code System Name:" + this.getEventID().getCodeSystemName() + "</div>");
            }
            if (this.getEventID().getDisplayName() != null && !this.getEventID().getDisplayName().trim().equals("")) {
                stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventID'>Code Display Name:" + this.getEventID().getDisplayName() + "</div>");
            }
            if (this.getEventID().getOriginalText() != null && !this.getEventID().getCodeSystem().trim().equals("")) {
                stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventID'>Original Text:" + this.getEventID().getOriginalText() + "</div>");
            }
        }
        int i = 0;
        while (this.getEventTypeCode() != null && i < this.getEventTypeCode().size()) {
            CodedValueType valueType = (CodedValueType)this.getEventTypeCode().get(i);
            if (valueType != null) {
                stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventTypeCode'>Event Type Code code : " + valueType.getCode() + "</div>");
                if (valueType.getCodeSystem() != null && !valueType.getCodeSystem().trim().equals("")) {
                    stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventTypeCode'>Code System :" + valueType.getCodeSystem() + "</div>");
                }
                if (valueType.getCodeSystemName() != null && !valueType.getCodeSystemName().trim().equals("")) {
                    stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventTypeCode'>Code System Name:" + valueType.getCodeSystemName() + "</div>");
                }
                if (valueType.getDisplayName() != null && !valueType.getDisplayName().trim().equals("")) {
                    stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventTypeCode'>Code Display Name:" + valueType.getDisplayName() + "</div>");
                }
                if (valueType.getOriginalText() != null && !valueType.getCodeSystem().trim().equals("")) {
                    stringHtml.append("<div class='EventIdentification_param" + param++ + " EventIdentification EventTypeCode'>Original Text:" + valueType.getOriginalText() + "</div>");
                }
            }
            ++i;
        }
        return stringHtml.toString();
    }

    public String getEventOutcomeIndicatorName() {
        switch (this.eventOutcomeIndicator) {
            case 0: {
                return "Success";
            }
            case 4: {
                return "Minor failure";
            }
            case 8: {
                return "Serious failure";
            }
            case 12: {
                return "Major failure; action made unavailable";
            }
        }
        return null;
    }

    public String getEventActionCodeName() {
        if (this.eventActionCode.equals("C")) {
            return "Create";
        }
        if (this.eventActionCode.equals("R")) {
            return "Read";
        }
        if (this.eventActionCode.equals("U")) {
            return "Update";
        }
        if (this.eventActionCode.equals("D")) {
            return "Delete";
        }
        if (this.eventActionCode.equals("E")) {
            return "Execute";
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            try {
                EventIdentificationType ev = new EventIdentificationType(0);
                ev.setEventActionCode("E");
                CodedValueType c = new CodedValueType();
                c.setCode("110112");
                c.setCodeSystemName("DCM");
                c.setDisplayName("Query");
                ev.setEventID(c);
                System.out.println(ev.toString());
            }
            catch (ATNAException e) {
                e.printStackTrace();
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
    }

    public Element getEventIdentificationNode() {
        return this.eventIdentificationNode;
    }

    public Document getDoc() {
        return this.doc;
    }

    public static boolean isValidElement(Element el) {
        if (el.getNodeName().equals("EventIdentification")) {
            if (el.getAttribute("EventOutcomeIndicator").equals("") || el.getAttribute("EventDateTime").equals("")) {
                return false;
            }
            NodeList list = el.getChildNodes();
            if (list != null) {
                int i = 0;
                while (i < list.getLength()) {
                    if (list.item(i).getNodeName().equals("EventID")) {
                        return true;
                    }
                    ++i;
                }
            }
        } else {
            return false;
        }
        return false;
    }

    public void parse(Element el) throws ATNAException {
        if (EventIdentificationType.isValidElement(el)) {
            this.setEventActionCode(el.getAttribute("EventActionCode"));
            this.setEventDateTime(el.getAttribute("EventDateTime"));
            this.setEventOutcomeIndicator(el.getAttribute("EventOutcomeIndicator"));
            NodeList list = el.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i).getNodeType() == 1) {
                    CodedValueType value;
                    Element childElement = (Element)list.item(i);
                    if (childElement.getNodeName().equals("EventID")) {
                        value = new CodedValueType();
                        value.parse(childElement);
                        this.setEventID(value);
                    }
                    if (childElement.getNodeName().equals("EventTypeCode")) {
                        value = new CodedValueType();
                        value.parse(childElement);
                        this.setEventTypeCode(value);
                    }
                }
                ++i;
            }
        }
    }
}

