/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditActiveParticipantRoleID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditParticipantObjectIDTypeCode;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.ParticipantObjectIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;

public class ExportMessage
extends AuditMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ExportMessage(String eventDateTime, int eventOutcomeIndicator, String userIDActiveParticipantExporter, String userIDActiveParticipantDestination, String participantObjectStudyInstanceUID, String participantObjectPatientId) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        EventIdentificationType eventId = new EventIdentificationType(0);
        eventId.setEventActionCode("R");
        eventId.setEventID(new AuditEventID.Export());
        eventId.setEventDateTime(eventDateTime);
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        this.setEventIdentification(eventId);
        ActiveParticipantType activeParticipantExporter = null;
        activeParticipantExporter = new ActiveParticipantType(userIDActiveParticipantExporter);
        activeParticipantExporter.setUserIsRequestor(true);
        activeParticipantExporter.setRoleIDCode(new AuditActiveParticipantRoleID.Source());
        this.setActiveParticipant(activeParticipantExporter);
        ActiveParticipantType activeParticipantDestination = null;
        activeParticipantDestination = new ActiveParticipantType(userIDActiveParticipantDestination);
        activeParticipantDestination.setUserIsRequestor(false);
        activeParticipantDestination.setRoleIDCode(new AuditActiveParticipantRoleID.DestinationMedia());
        this.setActiveParticipant(activeParticipantDestination);
        ParticipantObjectIdentificationType participantObjectStudyUID = new ParticipantObjectIdentificationType();
        participantObjectStudyUID.setParticipantObjectTypeCode((short)2);
        participantObjectStudyUID.setParticipantObjectTypeCodeRoleName("report");
        participantObjectStudyUID.setParticipantObjectIDTypeCode(new AuditParticipantObjectIDTypeCode.StudyInstanceUID());
        participantObjectStudyUID.setParticipantObjectID(participantObjectStudyInstanceUID);
        this.setParticipationObjectIdentification(participantObjectStudyUID);
        ParticipantObjectIdentificationType participantObjectPatient = new ParticipantObjectIdentificationType();
        participantObjectPatient.setParticipantObjectTypeCode((short)1);
        participantObjectPatient.setParticipantObjectTypeCodeRoleName("patient");
        CodedValueType value2 = new CodedValueType();
        value2.setCode("2");
        participantObjectPatient.setParticipantObjectIDTypeCode(value2);
        participantObjectPatient.setParticipantObjectID(participantObjectPatientId);
        this.setParticipationObjectIdentification(participantObjectPatient);
    }

    public ExportMessage() throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this.setMessagetype("export");
        if (this.getEventIdentification() != null) {
            this.getEventIdentification().setEventActionCode("R");
            CodedValueType eventIDValue = new CodedValueType();
            eventIDValue.setCode("110106");
            eventIDValue.setCodeSystemName("DCM");
            eventIDValue.setDisplayName("Export");
            this.getEventIdentification().setEventID(eventIDValue);
        }
    }
}

