/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.xml;

import java.io.IOException;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.eclipse.ohf.utilities.xml.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLWriterParser
extends XMLObjectParser {
    XMLWriter writer;

    public XMLWriterParser(XMLWriter writer) {
        this.writer = writer;
    }

    public void start(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        try {
            this.writer.start();
            this.startElement(namespace, name, defaultNamespace, attributes);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public XMLObjectParser startElement(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        try {
            int i = 0;
            while (i < attributes.getLength()) {
                this.writer.namespace(attributes.getURI(i));
                this.writer.attribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
                ++i;
            }
            this.writer.namespace(namespace);
            this.writer.open(namespace, name);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        return null;
    }

    public void endChild(XMLObjectParser child) throws SAXException {
        try {
            this.writer.close();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String namespace, String name) throws SAXException {
        try {
            this.writer.close();
            this.writer.flush();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void findText(char[] ch, int start, int length, boolean whitespace) throws SAXException {
        try {
            this.writer.text(String.valueOf(ch, start, length));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

