/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.source;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClient;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientDummy;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientException;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryErrorListType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryErrorType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryFactory;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryResponseType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.SubmitObjectsRequestType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.util.RegistryResourceFactoryImpl;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.transform.EbXML_2_1ProvideAndRegisterDocumentSetTransformer;
import org.eclipse.ohf.ihe.xds.soap.SoapAttachment;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapClient;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapClientAXIS2;
import org.eclipse.ohf.ihe.xds.source.SourceException;
import org.eclipse.ohf.ihe.xds.source.SubmitTransactionData;
import org.eclipse.ohf.ihe.xds.source.document.Document;

public class Source {
    private static final Logger logger;
    private java.net.URI repositoryURI = null;
    private XDSSoapClient sender = new XDSSoapClientAXIS2();
    private ATNAAuditClient auditor = new ATNAAuditClientDummy();
    private boolean DEBUG_UseEMFToProcessebXML21Response = true;
    private String ACTOR_NAME = "OHF_XDS_SOURCE";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.source.Source");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public Source(String repositoryURL, boolean doAudit) {
        try {
            this.repositoryURI = new java.net.URI(repositoryURL);
        }
        catch (URISyntaxException e) {
            logger.fatal((Object)("SOURCE URI CANNOT BE SET: \n" + e.getMessage()));
        }
        AtnaAgentFactory.getAtnaAgent().setDoAudit(doAudit);
    }

    public Source(String repositoryURL) {
        try {
            this.repositoryURI = new java.net.URI(repositoryURL);
        }
        catch (URISyntaxException e) {
            logger.fatal((Object)("SOURCE URI CANNOT BE SET: \n" + e.getMessage()));
        }
    }

    public Source(java.net.URI uri, boolean doAudit) {
        this.repositoryURI = uri;
        AtnaAgentFactory.getAtnaAgent().setDoAudit(doAudit);
    }

    public Source(java.net.URI uri) {
        this.repositoryURI = uri;
    }

    public boolean isDoAudit() {
        return AtnaAgentFactory.getAtnaAgent().isDoAudit();
    }

    public void setDoAudit(boolean doAudit) {
    }

    public String getRepositoryURL() {
        return this.repositoryURI.toString();
    }

    public void setRepositoryURL(String repositoryURL) {
        try {
            this.repositoryURI = new java.net.URI(repositoryURL);
        }
        catch (URISyntaxException e) {
            logger.fatal((Object)("SOURCE URI CANNOT BE SET: \n" + e.getMessage()));
        }
    }

    public java.net.URI getRepositoryURI() {
        return this.repositoryURI;
    }

    public void setRepositoryURI(java.net.URI repositoryURI) {
        this.repositoryURI = repositoryURI;
    }

    /*
     * Unable to fully structure code
     */
    public void submit(SubmitTransactionData txnData, String initiatingUser) throws Exception {
        block15: {
            block16: {
                if (this.isDoAudit()) {
                    this.auditor.auditActorStartEvent(0, this.ACTOR_NAME, initiatingUser);
                }
                if (this.repositoryURI == null) {
                    Source.logger.fatal((Object)"Repository URI is undefined.");
                    if (this.isDoAudit()) {
                        this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
                    }
                    throw new SourceException(3, "RepositoryURL has not been defined.");
                }
                if (this.isDoAudit()) {
                    if (initiatingUser == null) {
                        if (this.isDoAudit()) {
                            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
                        }
                        throw new ATNAAuditClientException("Auditing Enabled and initiating user is not specified.");
                    }
                    if (initiatingUser.length() == 0) {
                        if (this.isDoAudit()) {
                            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
                        }
                        throw new ATNAAuditClientException("Auditing Enabled and initiating user is not specified.");
                    }
                }
                setTransformer = new EbXML_2_1ProvideAndRegisterDocumentSetTransformer();
                meta = txnData.getMetadata();
                setTransformer.transform(meta);
                ebXMLMetadataString = this.unpackSubmitObjectsRequest(setTransformer.getSubmitReq());
                ebXMLMetadataString = ebXMLMetadataString.replaceAll("xml:lang=\"en-us\"", "");
                attachments = new SoapAttachment[txnData.getDocList().size()];
                i = txnData.getDocList().iterator();
                count = 0;
                while (i.hasNext()) {
                    docI = (Document)i.next();
                    attachments[count] = new SoapAttachment(docI.getDocumentData(), docI.getDescriptor().getMimeType(), docI.getDocumentEntryUUID());
                    ++count;
                }
                eventOutcome = 0;
                reply = null;
                try {
                    Source.logger.info((Object)("Submitting Provide and Register Document Set transaction to Repository: " + this.repositoryURI.toString()));
                    reply = this.sender.send(ebXMLMetadataString, attachments, this.repositoryURI);
                    break block15;
                }
                catch (Exception e) {
                    eventOutcome = 8;
                    Source.logger.error((Object)("Error sending SOAP message to the repository. Error was " + e.getMessage()), (Throwable)e);
                    if (!this.isDoAudit()) break block16;
                    iter = meta.getDocumentEntry().iterator();
                    ** while (iter.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    docEntry = (DocumentEntryType)iter.next();
                    this.auditor.auditPHIExportEvent(eventOutcome, initiatingUser, this.getRepositoryURL(), docEntry.getUniqueId(), HL7V2MessageFormat.toMessageString((CX)docEntry.getPatientId(), (char)'^', (char)'&'));
                    continue;
                }
lbl45:
                // 1 sources

                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
            }
            throw e;
        }
        if (this.isDoAudit()) {
            iter = meta.getDocumentEntry().iterator();
            while (iter.hasNext()) {
                docEntry = (DocumentEntryType)iter.next();
                this.auditor.auditPHIExportEvent(eventOutcome, initiatingUser, this.getRepositoryURL(), docEntry.getUniqueId(), HL7V2MessageFormat.toMessageString((CX)docEntry.getPatientId(), (char)'^', (char)'&'));
            }
        }
        this.processResponse(reply, txnData, initiatingUser);
        if (this.isDoAudit()) {
            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
        }
    }

    private void processResponse(byte[] xmlData, SubmitTransactionData txnData, String initiatingUser) throws SourceException, ATNAAuditClientException {
        String responseData = new String(xmlData);
        if (responseData == null || responseData.equals("")) {
            logger.error((Object)"Error: Response from Repository was null.");
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
            }
            throw new SourceException(7, "Error: Response from Repository was null.");
        }
        if (responseData.indexOf("urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1") != -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Using EMF to parse response.");
            }
            Resource resources = new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
            if (this.getHackMetadataFlag()) {
                XMLResource xResource = (XMLResource)resources;
                xResource.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            }
            try {
                byte[] replyBytes = responseData.getBytes();
                ByteArrayInputStream is = new ByteArrayInputStream(replyBytes);
                resources.load((InputStream)is, null);
            }
            catch (IOException e) {
                resources.unload();
                if (this.isDoAudit()) {
                    this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
                }
                throw new SourceException(7, "Error parsing Repository reply. " + e.getMessage());
            }
            EList list = resources.getContents();
            DocumentRoot root = (DocumentRoot)list.get(0);
            RegistryResponseType response = root.getRegistryResponse();
            RegistryErrorListType reasons = null;
            EList errorList = null;
            int count = 0;
            switch (response.getStatus().getValue()) {
                case 0: {
                    resources.unload();
                    if (this.isDoAudit()) {
                        Iterator iter = txnData.getMetadata().getDocumentEntry().iterator();
                        while (iter.hasNext()) {
                            DocumentEntryType docEntry = (DocumentEntryType)iter.next();
                            this.auditor.auditPHIExportEvent(0, initiatingUser, this.getRepositoryURL(), docEntry.getUniqueId(), HL7V2MessageFormat.toMessageString((CX)docEntry.getPatientId(), (char)'^', (char)'&'));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Success.");
                        }
                    }
                    return;
                }
                case 1: {
                    reasons = response.getRegistryErrorList();
                    errorList = reasons.getRegistryError();
                    StringBuffer errorMsg = new StringBuffer();
                    Iterator i = errorList.iterator();
                    while (i.hasNext()) {
                        RegistryErrorType error = (RegistryErrorType)i.next();
                        errorMsg.append("Error #" + ++count + " Severity=" + error.getSeverity() + " Code=" + error.getErrorCode() + " Location=" + error.getLocation() + " message was \"" + error.getValue() + "\"");
                    }
                    resources.unload();
                    if (this.isDoAudit()) {
                        Iterator iter = txnData.getMetadata().getDocumentEntry().iterator();
                        while (iter.hasNext()) {
                            DocumentEntryType docEntry = (DocumentEntryType)iter.next();
                            this.auditor.auditPHIExportEvent(4, initiatingUser, this.getRepositoryURL(), docEntry.getUniqueId(), HL7V2MessageFormat.toMessageString((CX)docEntry.getPatientId(), (char)'^', (char)'&'));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Failure.");
                        }
                    }
                    if (this.isDoAudit()) {
                        this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
                    }
                    throw new SourceException(1, "Repository Error(s). " + errorMsg.toString());
                }
                case 2: {
                    reasons = response.getRegistryErrorList();
                    errorList = reasons.getRegistryError();
                    StringBuffer errorMsg = new StringBuffer();
                    Iterator i = errorList.iterator();
                    while (i.hasNext()) {
                        RegistryErrorType error = (RegistryErrorType)i.next();
                        errorMsg.append("Error #" + ++count + " Severity=" + error.getSeverity() + " Code=" + error.getErrorCode() + " Location=" + error.getLocation() + " message was " + error.getValue() + "\"");
                    }
                    resources.unload();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Unavailable.");
                    }
                    if (this.isDoAudit()) {
                        Iterator iter = txnData.getMetadata().getDocumentEntry().iterator();
                        while (iter.hasNext()) {
                            DocumentEntryType docEntry = (DocumentEntryType)iter.next();
                            this.auditor.auditPHIExportEvent(8, initiatingUser, this.getRepositoryURL(), docEntry.getUniqueId(), HL7V2MessageFormat.toMessageString((CX)docEntry.getPatientId(), (char)'^', (char)'&'));
                        }
                    }
                    if (this.isDoAudit()) {
                        this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
                    }
                    throw new SourceException(5, "Repository Error(s). " + errorMsg.toString());
                }
            }
            resources.unload();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unknown Error.");
            }
            if (this.isDoAudit()) {
                Iterator iter = txnData.getMetadata().getDocumentEntry().iterator();
                while (iter.hasNext()) {
                    DocumentEntryType docEntry = (DocumentEntryType)iter.next();
                    this.auditor.auditPHIExportEvent(8, initiatingUser, this.getRepositoryURL(), docEntry.getUniqueId(), HL7V2MessageFormat.toMessageString((CX)docEntry.getPatientId(), (char)'^', (char)'&'));
                }
            }
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
            }
            throw new SourceException(4, "Repository response could not be interpreted. >>" + responseData + "<<");
        }
        if (responseData.indexOf("urn:oasis:names:tc:ebxml-regrep:xsd:rs:3.0") != -1) {
            logger.error((Object)"Processing of ebXML3.0 responses is not supported yet.");
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
            }
            throw new SourceException(4, "Processing of ebXML3.0 responses is not supported yet.");
        }
        if (this.isDoAudit()) {
            Iterator iter = txnData.getMetadata().getDocumentEntry().iterator();
            while (iter.hasNext()) {
                DocumentEntryType docEntry = (DocumentEntryType)iter.next();
                this.auditor.auditPHIExportEvent(8, initiatingUser, this.getRepositoryURL(), docEntry.getUniqueId(), HL7V2MessageFormat.toMessageString((CX)docEntry.getPatientId(), (char)'^', (char)'&'));
            }
        }
        logger.error((Object)"Repository response was coded with an unrecognized namespace: ");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Response was:");
            logger.debug((Object)responseData);
        }
        if (this.isDoAudit()) {
            this.auditor.auditActorStopEvent(0, this.ACTOR_NAME, initiatingUser);
        }
        throw new SourceException(6, "Registry response was coded with an unrecognized namespace.");
    }

    private boolean getHackMetadataFlag() {
        String val = System.getProperty("relax.validation");
        if (val == null) {
            return false;
        }
        if ((val = val.trim()).length() <= 0) {
            return false;
        }
        if (val.equals("true") || val.equals("yes")) {
            System.err.println("RELAXING VALIDATION");
            return true;
        }
        return false;
    }

    private String unpackSubmitObjectsRequest(SubmitObjectsRequestType submitObjectsRequest) throws IOException {
        DocumentRoot root = RegistryFactory.eINSTANCE.createDocumentRoot();
        root.setSubmitObjectsRequest(submitObjectsRequest);
        Resource resource = new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
        resource.getContents().add((Object)root);
        ByteArrayOutputStream os = null;
        HashMap<String, String> saveOpt = new HashMap<String, String>();
        saveOpt.put("FORMATTED", "FALSE");
        os = new ByteArrayOutputStream();
        resource.save((OutputStream)os, saveOpt);
        resource.unload();
        return os.toString();
    }
}

