/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.source;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.common.cdar2.DocumentRoot;
import org.eclipse.ohf.ihe.common.cdar2.util.CDAR2ResourceFactoryImpl;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExtrinsicObjectType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.FolderType;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.ProvideAndRegisterDocumentSetType;
import org.eclipse.ohf.ihe.xds.metadata.SubmissionSetType;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1FolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1InputStreamDocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1InputStreamFolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1InputStreamSubmissionSetExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1SubmissionSetExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.InputStreamDocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.InputStreamFolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.InputStreamSubmissionSetExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.extract.cdar2.CDAR2Extractor;
import org.eclipse.ohf.ihe.xds.metadata.transform.ByteArrayProvideAndRegisterDocumentSetTransformer;
import org.eclipse.ohf.ihe.xds.metadata.transform.MetadataTransformationException;
import org.eclipse.ohf.ihe.xds.source.SubmitTransactionCompositionException;
import org.eclipse.ohf.ihe.xds.source.document.Document;
import org.eclipse.ohf.ihe.xds.source.document.DocumentDescriptor;
import org.eclipse.ohf.ihe.xds.source.utils.UUID;

public class SubmitTransactionData {
    private static final Logger logger;
    protected ArrayList docList = new ArrayList();
    protected ProvideAndRegisterDocumentSetType metadata = MetadataFactory.eINSTANCE.createProvideAndRegisterDocumentSetType();
    protected static Map metadataExtractors;
    protected static Map metadataTransformers;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.source.SubmitTransactionData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        metadataExtractors = new HashMap();
        metadataExtractors.put(DocumentDescriptor.CDA_R2, "CDAR2_DE_EXTR");
        metadataExtractors.put(DocumentDescriptor.XDS_LAB, "CDAR2_DE_EXTR");
        metadataExtractors.put(DocumentDescriptor.XDS_MS, "CDAR2_DE_EXTR");
        metadataExtractors.put(DocumentDescriptor.XDS_SD, "CDAR2_DE_EXTR");
        metadataTransformers = new HashMap();
    }

    public SubmitTransactionData() {
        this.metadata.setSubmissionSet(MetadataFactory.eINSTANCE.createSubmissionSetType());
        this.metadata.getSubmissionSet().setEntryUUID(UUID.generateURN());
    }

    public List getDocList() {
        return this.docList;
    }

    public String addDocument(Document document) throws MetadataExtractionException, SubmitTransactionCompositionException {
        if (document == null) {
            logger.error((Object)"Cannot add a null document");
            throw new SubmitTransactionCompositionException("Cannot add a null document");
        }
        String method = "addDocument() ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "adding " + document.getCanonicalPath()));
        }
        if (this.docList.contains(document)) {
            logger.info((Object)(String.valueOf(method) + "document was previously added - it will not be added again"));
            return document.getDocumentEntryUUID();
        }
        DocumentEntryType docEntry = null;
        String deExtractorDescriptor = (String)metadataExtractors.get(document.getDescriptor());
        if (deExtractorDescriptor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No metadata extractor availiable for " + document.getDescriptor().toString()));
            }
            docEntry = MetadataFactory.eINSTANCE.createDocumentEntryType();
        } else if (deExtractorDescriptor.equals("CDAR2_DE_EXTR")) {
            try {
                ByteArrayInputStream input = new ByteArrayInputStream(document.getDocumentData().getBytes());
                Resource resources = new CDAR2ResourceFactoryImpl().createResource(URI.createURI((String)"urn:hl7-org:v3"));
                resources.load((InputStream)input, null);
                EList list = resources.getContents();
                DocumentRoot root = (DocumentRoot)list.get(0);
                CDAR2Extractor deExtractor = new CDAR2Extractor(root.getClinicalDocument());
                docEntry = deExtractor.extract();
            }
            catch (IOException e) {
                logger.error((Object)"An IOException occurred during the extraction process.", (Throwable)e);
                docEntry = MetadataFactory.eINSTANCE.createDocumentEntryType();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Metadata Extraction is not enabled at this time for " + document.getDescriptor().toString()));
        }
        String docEntryUUID = UUID.generateURN();
        docEntry.setEntryUUID(docEntryUUID);
        document.setDocumentEntryUUID(docEntryUUID);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DocumentEntry.entryUUID generated and set to: " + docEntryUUID));
        }
        docEntry.setMimeType(document.getDescriptor().getMimeType());
        this.metadata.getDocumentEntry().add((Object)docEntry);
        this.metadata.getSubmissionSet().getAssociatedDocuments().add((Object)docEntryUUID);
        this.docList.add(document);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "document was successfully added."));
        }
        return document.getDocumentEntryUUID();
    }

    public String loadDocumentWithMetadata(Document document, InputStream metadata) throws MetadataExtractionException, SubmitTransactionCompositionException {
        if (document == null) {
            logger.error((Object)"Cannot add a null document");
            throw new SubmitTransactionCompositionException("Cannot add a null document");
        }
        String method = "loadDocumentWithMetadata() ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "adding " + document.getCanonicalPath()));
        }
        if (this.docList.contains(document)) {
            logger.info((Object)(String.valueOf(method) + "document was previously added - it will not be added again"));
            return document.getDocumentEntryUUID();
        }
        InputStreamDocumentEntryExtractor deExtractor = new InputStreamDocumentEntryExtractor(metadata);
        DocumentEntryType docEntry = deExtractor.extract();
        if (docEntry.getEntryUUID() == null) {
            docEntry.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" DocumentEntry entryUUID generated.");
            }
        } else if (docEntry.getEntryUUID().length() == 0) {
            docEntry.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" DocumentEntry entryUUID generated.");
            }
        }
        docEntry.setMimeType(document.getDescriptor().getMimeType());
        document.setDocumentEntryUUID(docEntry.getEntryUUID());
        this.docList.add(document);
        this.metadata.getDocumentEntry().add((Object)docEntry);
        this.metadata.getSubmissionSet().getAssociatedDocuments().add((Object)docEntry.getEntryUUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Document metadata loaded. Current DocumentEntry entryUUID: " + docEntry.getEntryUUID() + "."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "document was successfully added."));
        }
        return document.getDocumentEntryUUID();
    }

    public String loadDocumentWithEbXMLMetadata(Document document, InputStream metadata) throws MetadataExtractionException, SubmitTransactionCompositionException {
        if (document == null) {
            logger.error((Object)"Cannot add a null document");
            throw new SubmitTransactionCompositionException("Cannot add a null document");
        }
        String method = "loadDocumentWithEbXMLMetadata() ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "adding " + document.getCanonicalPath()));
        }
        if (this.docList.contains(document)) {
            logger.info((Object)(String.valueOf(method) + "document was previously added - it will not be added again"));
            return document.getDocumentEntryUUID();
        }
        EbXML_2_1InputStreamDocumentEntryExtractor deExtractor = new EbXML_2_1InputStreamDocumentEntryExtractor(metadata);
        DocumentEntryType docEntry = deExtractor.extract();
        if (docEntry.getEntryUUID() == null) {
            docEntry.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" DocumentEntry entryUUID generated.");
            }
        } else if (docEntry.getEntryUUID().length() == 0) {
            docEntry.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" DocumentEntry entryUUID generated.");
            }
        }
        docEntry.setMimeType(document.getDescriptor().getMimeType());
        document.setDocumentEntryUUID(docEntry.getEntryUUID());
        this.docList.add(document);
        this.metadata.getDocumentEntry().add((Object)docEntry);
        this.metadata.getSubmissionSet().getAssociatedDocuments().add((Object)docEntry.getEntryUUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Document metadata loaded. Current DocumentEntry entryUUID: " + docEntry.getEntryUUID() + "."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "document was successfully added."));
        }
        return document.getDocumentEntryUUID();
    }

    public String loadDocumentWithEbXMLMetadata(Document document, ExtrinsicObjectType docData, AssociationType1 parentData) throws MetadataExtractionException, SubmitTransactionCompositionException {
        if (document == null) {
            logger.error((Object)"Cannot add a null document");
            throw new SubmitTransactionCompositionException("Cannot add a null document");
        }
        String method = "loadDocumentWithEbXMLMetadata() ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "adding " + document.getCanonicalPath()));
        }
        if (this.docList.contains(document)) {
            logger.info((Object)(String.valueOf(method) + "document was previously added - it will not be added again"));
            return document.getDocumentEntryUUID();
        }
        EbXML_2_1DocumentEntryExtractor deExtractor = new EbXML_2_1DocumentEntryExtractor(docData, parentData);
        DocumentEntryType docEntry = deExtractor.extract();
        if (docEntry.getEntryUUID() == null) {
            docEntry.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" DocumentEntry entryUUID generated.");
            }
        } else if (docEntry.getEntryUUID().length() == 0) {
            docEntry.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" DocumentEntry entryUUID generated.");
            }
        }
        docEntry.setMimeType(document.getDescriptor().getMimeType());
        document.setDocumentEntryUUID(docEntry.getEntryUUID());
        this.docList.add(document);
        this.metadata.getDocumentEntry().add((Object)docEntry);
        this.metadata.getSubmissionSet().getAssociatedDocuments().add((Object)docEntry.getEntryUUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Document metadata loaded. Current DocumentEntry entryUUID: " + docEntry.getEntryUUID() + "."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "document was successfully added."));
        }
        return document.getDocumentEntryUUID();
    }

    public void addExistingDocument(String documentEntryUUID) throws MetadataExtractionException {
        String method = "addExistingDocument() ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "adding existing document"));
        }
        Iterator i = this.metadata.getDocumentEntry().iterator();
        while (i.hasNext()) {
            if (!documentEntryUUID.equals(((DocumentEntryType)i.next()).getEntryUUID())) continue;
            logger.info((Object)(String.valueOf(method) + "document was previously added - it will not be added again"));
            return;
        }
        DocumentEntryType docEntry = MetadataFactory.eINSTANCE.createDocumentEntryType();
        docEntry.setEntryUUID(documentEntryUUID);
        docEntry.setExisting(true);
        this.metadata.getDocumentEntry().add((Object)docEntry);
        this.metadata.getSubmissionSet().getAssociatedDocuments().add((Object)documentEntryUUID);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Document metadata loaded. Current DocumentEntry entryUUID: " + docEntry.getEntryUUID() + "."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "document was successfully added."));
        }
    }

    public void deleteDocument(String documentEntryUUID) {
        Iterator i = this.metadata.getDocumentEntry().iterator();
        boolean present = false;
        while (i.hasNext()) {
            DocumentEntryType docEntry = (DocumentEntryType)i.next();
            if (!docEntry.getEntryUUID().equals(documentEntryUUID)) continue;
            present = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DocumentEntry metadata found for entryUUID: " + documentEntryUUID + ". Removing DocumentEntry metadata."));
            }
            this.metadata.getDocumentEntry().remove((Object)docEntry);
            this.metadata.getSubmissionSet().getAssociatedDocuments().remove((Object)documentEntryUUID);
            break;
        }
        if (!present) {
            logger.info((Object)("DocumentEntry metadata for entryUUID = " + documentEntryUUID + " does not exist."));
            return;
        }
        i = this.docList.iterator();
        while (i.hasNext()) {
            Document document = (Document)i.next();
            if (!document.getDocumentEntryUUID().equals(documentEntryUUID)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Document found for entryUUID: " + documentEntryUUID + ". Removing Document."));
            }
            this.docList.remove(document);
            break;
        }
        i = this.metadata.getFolder().iterator();
        block2: while (i.hasNext()) {
            FolderType fol = (FolderType)i.next();
            Iterator j = fol.getAssociatedDocuments().iterator();
            while (j.hasNext()) {
                String assocDoc = (String)i.next();
                if (!assocDoc.equals(documentEntryUUID)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Associated folder found for entryUUID: " + documentEntryUUID + ". Removing reference in folder:  ." + fol.getEntryUUID()));
                }
                fol.getAssociatedDocuments().remove((Object)documentEntryUUID);
                continue block2;
            }
        }
    }

    public DocumentEntryType getDocumentEntry(String documentEntryUUID) {
        Iterator i = this.metadata.getDocumentEntry().iterator();
        while (i.hasNext()) {
            DocumentEntryType docEntry = (DocumentEntryType)i.next();
            if (!docEntry.getEntryUUID().equals(documentEntryUUID)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DocumentEntry metadata found for entryUUID: " + documentEntryUUID + "."));
            }
            return docEntry;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DocumentEntry metadata NOT found for entryUUID: " + documentEntryUUID + "."));
        }
        return null;
    }

    public Document getDocument(String documentEntryUUID) {
        Iterator i = this.docList.iterator();
        while (i.hasNext()) {
            Document document = (Document)i.next();
            if (!document.getDocumentEntryUUID().equals(documentEntryUUID)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Document found for entryUUID: " + documentEntryUUID + "."));
            }
            return document;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Document NOT found for entryUUID: " + documentEntryUUID + "."));
        }
        return null;
    }

    public boolean isDocumentAdded(Document document) {
        return this.docList.contains(document);
    }

    public String addFolder() {
        FolderType folder = MetadataFactory.eINSTANCE.createFolderType();
        folder.setEntryUUID(UUID.generateURN());
        this.metadata.getFolder().add((Object)folder);
        this.metadata.getSubmissionSet().getAssociatedFolders().add((Object)folder.getEntryUUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Folder added with entryUUID: " + folder.getEntryUUID() + "."));
        }
        return folder.getEntryUUID();
    }

    public String loadFolder(InputStream folderStream) throws MetadataExtractionException {
        InputStreamFolderExtractor folExtractor = new InputStreamFolderExtractor(folderStream);
        FolderType folder = folExtractor.extract();
        if (folder.getEntryUUID() == null) {
            folder.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Folder entryUUID generated.");
            }
        } else if (folder.getEntryUUID().length() == 0) {
            folder.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Folder entryUUID generated.");
            }
        }
        this.metadata.getFolder().add((Object)folder);
        this.metadata.getSubmissionSet().getAssociatedFolders().add((Object)folder.getEntryUUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Folder metadata loaded. Current Folder entryUUID: " + folder.getEntryUUID() + "."));
        }
        return folder.getEntryUUID();
    }

    public String loadEbXMLFolder(InputStream folderStream) throws MetadataExtractionException {
        EbXML_2_1InputStreamFolderExtractor folExtractor = new EbXML_2_1InputStreamFolderExtractor(folderStream);
        FolderType folder = folExtractor.extract();
        if (folder.getEntryUUID() == null) {
            folder.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Folder entryUUID generated.");
            }
        } else if (folder.getEntryUUID().length() == 0) {
            folder.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Folder entryUUID generated.");
            }
        }
        this.metadata.getFolder().add((Object)folder);
        this.metadata.getSubmissionSet().getAssociatedFolders().add((Object)folder.getEntryUUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Folder metadata loaded. Current Folder entryUUID: " + folder.getEntryUUID() + "."));
        }
        return folder.getEntryUUID();
    }

    public String loadEbXMLFolder(RegistryPackageType folData) throws MetadataExtractionException {
        EbXML_2_1FolderExtractor folExtractor = new EbXML_2_1FolderExtractor(folData, null);
        FolderType folder = folExtractor.extract();
        if (folder.getEntryUUID() == null) {
            folder.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Folder entryUUID generated.");
            }
        } else if (folder.getEntryUUID().length() == 0) {
            folder.setEntryUUID(UUID.generateURN());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Folder entryUUID generated.");
            }
        }
        this.metadata.getFolder().add((Object)folder);
        this.metadata.getSubmissionSet().getAssociatedFolders().add((Object)folder.getEntryUUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Folder metadata loaded. Current Folder entryUUID: " + folder.getEntryUUID() + "."));
        }
        return folder.getEntryUUID();
    }

    public void addExistingFolder(String folderEntryUUID) throws MetadataExtractionException {
        String method = "addExistingDocument() ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "adding existing document"));
        }
        Iterator i = this.metadata.getFolder().iterator();
        while (i.hasNext()) {
            if (!folderEntryUUID.equals(((FolderType)i.next()).getEntryUUID())) continue;
            logger.info((Object)(String.valueOf(method) + "folder was previously added - it will not be added again"));
            return;
        }
        FolderType folder = MetadataFactory.eINSTANCE.createFolderType();
        folder.setEntryUUID(folderEntryUUID);
        folder.setExisting(true);
        this.metadata.getFolder().add((Object)folder);
        this.metadata.getSubmissionSet().getAssociatedFolders().add((Object)folder.getEntryUUID());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Document metadata loaded. Current DocumentEntry entryUUID: " + folder.getEntryUUID() + "."));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(method) + "document was successfully added."));
        }
    }

    public void deleteFolder(String folderEntryUUID) {
        Iterator i = this.metadata.getFolder().iterator();
        while (i.hasNext()) {
            FolderType folder = (FolderType)i.next();
            if (!folder.getEntryUUID().equals(folderEntryUUID)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Folder metadata found for entryUUID: " + folderEntryUUID + ". Removing Folder metadata."));
            }
            this.metadata.getFolder().remove((Object)folder);
            this.metadata.getSubmissionSet().getAssociatedFolders().remove((Object)folderEntryUUID);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Folder metadata NOT found for entryUUID: " + folderEntryUUID + "."));
        }
    }

    public FolderType getFolder(String folderEntryUUID) {
        Iterator i = this.metadata.getFolder().iterator();
        while (i.hasNext()) {
            FolderType folder = (FolderType)i.next();
            if (!folder.getEntryUUID().equals(folderEntryUUID)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Folder found for entryUUID: " + folderEntryUUID + "."));
            }
            return folder;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Folder NOT found for entryUUID: " + folderEntryUUID + "."));
        }
        return null;
    }

    public void addDocumentToFolder(String documentEntryUUID, String folderEntryUUID) {
        Iterator i = this.metadata.getFolder().iterator();
        while (i.hasNext()) {
            FolderType folder = (FolderType)i.next();
            if (!folder.getEntryUUID().equals(folderEntryUUID)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Folder found for entryUUID: " + folderEntryUUID + "."));
            }
            if (folder.getAssociatedDocuments().contains((Object)documentEntryUUID)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Folder contains document with entryUUID: " + documentEntryUUID + "."));
                }
                return;
            }
            folder.getAssociatedDocuments().add((Object)documentEntryUUID);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Document reference added to folder with entryUUID: " + documentEntryUUID + "."));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Folder NOT found for entryUUID: " + folderEntryUUID + "."));
        }
    }

    public void deleteDocumentFromFolder(String documentEntryUUID, String folderEntryUUID) {
        Iterator i = this.metadata.getFolder().iterator();
        while (i.hasNext()) {
            FolderType folder = (FolderType)i.next();
            if (!folder.getEntryUUID().equals(folderEntryUUID)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Folder found for entryUUID: " + folderEntryUUID + "."));
            }
            folder.getAssociatedDocuments().remove((Object)documentEntryUUID);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Document reference removed from folder with entryUUID: " + documentEntryUUID + "."));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Folder NOT found for entryUUID: " + folderEntryUUID + "."));
        }
    }

    public SubmissionSetType getSubmissionSet() {
        return this.metadata.getSubmissionSet();
    }

    public void loadSubmissionSet(InputStream submissionSetStream) throws MetadataExtractionException {
        InputStreamSubmissionSetExtractor ssExtractor = new InputStreamSubmissionSetExtractor(submissionSetStream);
        SubmissionSetType sSet = ssExtractor.extract();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Previous Submission entryUUID: " + this.metadata.getSubmissionSet().getEntryUUID() + "."));
        }
        if (sSet.getEntryUUID() == null) {
            sSet.setEntryUUID(this.metadata.getSubmissionSet().getEntryUUID());
        } else if (sSet.getEntryUUID().length() == 0) {
            sSet.setEntryUUID(this.metadata.getSubmissionSet().getEntryUUID());
        }
        this.metadata.setSubmissionSet(sSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Submission Set metadata loaded. Current Submission entryUUID: " + this.metadata.getSubmissionSet().getEntryUUID() + "."));
        }
    }

    public void loadEbXMLSubmissionSet(InputStream submissionSetStream) throws MetadataExtractionException {
        EbXML_2_1InputStreamSubmissionSetExtractor ssExtractor = new EbXML_2_1InputStreamSubmissionSetExtractor(submissionSetStream);
        SubmissionSetType sSet = ssExtractor.extract();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Previous Submission entryUUID: " + this.metadata.getSubmissionSet().getEntryUUID() + "."));
        }
        if (sSet.getEntryUUID() == null) {
            sSet.setEntryUUID(this.metadata.getSubmissionSet().getEntryUUID());
        } else if (sSet.getEntryUUID().length() == 0) {
            sSet.setEntryUUID(this.metadata.getSubmissionSet().getEntryUUID());
        }
        this.metadata.setSubmissionSet(sSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Submission Set metadata loaded. Current Submission entryUUID: " + this.metadata.getSubmissionSet().getEntryUUID() + "."));
        }
    }

    public void loadEbXMLSubmissionSet(RegistryPackageType setData) throws MetadataExtractionException {
        EbXML_2_1SubmissionSetExtractor ssExtractor = new EbXML_2_1SubmissionSetExtractor(setData, null, null);
        SubmissionSetType sSet = ssExtractor.extract();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Previous Submission entryUUID: " + this.metadata.getSubmissionSet().getEntryUUID() + "."));
        }
        if (sSet.getEntryUUID() == null) {
            sSet.setEntryUUID(this.metadata.getSubmissionSet().getEntryUUID());
        } else if (sSet.getEntryUUID().length() == 0) {
            sSet.setEntryUUID(this.metadata.getSubmissionSet().getEntryUUID());
        }
        this.metadata.setSubmissionSet(sSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Submission Set metadata loaded. Current Submission entryUUID: " + this.metadata.getSubmissionSet().getEntryUUID() + "."));
        }
    }

    public ProvideAndRegisterDocumentSetType getMetadata() {
        return this.metadata;
    }

    public void saveMetadataToFile(String path) throws MetadataTransformationException {
        ByteArrayProvideAndRegisterDocumentSetTransformer setTransformer = new ByteArrayProvideAndRegisterDocumentSetTransformer();
        setTransformer.transform(this.metadata);
        try {
            FileOutputStream fos = new FileOutputStream(new File(path));
            fos.write(setTransformer.getMetadataByteArray());
        }
        catch (FileNotFoundException e1) {
            logger.error((Object)("File not found: " + path));
            throw new MetadataTransformationException("File not found: " + path, (Throwable)e1);
        }
        catch (IOException e) {
            logger.error((Object)("IOException while writing to file: " + path), (Throwable)e);
            throw new MetadataTransformationException("IOException while writing to file: " + path, (Throwable)e);
        }
    }
}

