/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.hl7v2.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.ParsingOptions;
import org.eclipse.ohf.hl7v2.core.message.formats.VerticalBarComposer;
import org.eclipse.ohf.hl7v2.core.message.model.ComponentList;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;

public class PixPdqMessageUtilities {
    public static String msgToString(Message msg) throws PixPdqMessageException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        String strMessage = null;
        MessageManager globalFactory = MessageManager.getFactory();
        try {
            globalFactory.save((OutputStream)outStream, msg);
            strMessage = outStream.toString();
        }
        catch (HL7V2Exception e) {
            throw new PixPdqMessageException(e);
        }
        return strMessage;
    }

    public static Message stringToMsg(String hl7) throws PixPdqMessageException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(hl7.getBytes());
        ParsingOptions pOptions = new ParsingOptions();
        Message msgMessage = null;
        MessageManager globalFactory = MessageManager.getFactory();
        try {
            msgMessage = globalFactory.createMessage();
            pOptions.setFormat(1);
            globalFactory.load((InputStream)inStream, msgMessage, pOptions);
        }
        catch (HL7V2Exception e) {
            throw new PixPdqMessageException(e);
        }
        return msgMessage;
    }

    public static String getCurrentDateTimeString() {
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddkkmmssZ");
        return format.format(now);
    }

    public static String getRandomFieldValue(int length) {
        StringBuffer random = new StringBuffer();
        Random generator = new Random();
        int i = 1;
        while (i < length) {
            int r = generator.nextInt(10);
            random.append(String.valueOf(r));
            ++i;
        }
        return random.toString();
    }

    public static String getHL7Segment(Segment seg) {
        OutputStream outStream;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            VerticalBarComposer comp = new VerticalBarComposer((OutputStream)out);
            comp.compose(seg);
            outStream = comp.getStream();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (HL7V2Exception hL7V2Exception) {
            return null;
        }
        return outStream.toString();
    }

    public static String getHL7Field(Field fld) {
        OutputStream outStream;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            VerticalBarComposer comp = new VerticalBarComposer((OutputStream)out);
            comp.compose(fld);
            outStream = comp.getStream();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (HL7V2Exception hL7V2Exception) {
            return null;
        }
        return outStream.toString();
    }

    public static String[] getFieldComponents(Segment seg, int fieldIndex) throws PixPdqMessageException {
        return PixPdqMessageUtilities.getFieldComponentsInRepeat(seg, fieldIndex, 0);
    }

    public static int getRepeatCount(Segment seg, int fieldIndex) throws PixPdqMessageException {
        try {
            return seg.getFields().item(fieldIndex).getNonEmptyCount();
        }
        catch (HL7V2Exception e) {
            throw new PixPdqMessageException(e);
        }
    }

    public static String[] getFieldComponentsInRepeat(Segment seg, int fieldIndex, int repeatIndex) throws PixPdqMessageException {
        try {
            if (seg == null || fieldIndex < 0 || fieldIndex > seg.getFields().size() || repeatIndex > seg.getFields().item(fieldIndex).getNonEmptyCount()) {
                throw new PixPdqMessageException("ClientUtilities: getFieldComponentsInRepeat - invalid parameters");
            }
            Field fld = seg.getFields().item(fieldIndex).getRepeat(repeatIndex);
            if (fld == null) {
                throw new PixPdqMessageException("ClientUtilities: getFieldComponentsInRepeat - field " + (fieldIndex + 1) + " not found.");
            }
            ComponentList compList = fld.getComponents();
            int numComponents = compList.size();
            String[] values = new String[numComponents];
            int i = 0;
            while (i < numComponents) {
                try {
                    values[i] = compList.item(i).getAsString();
                }
                catch (HL7V2Exception hL7V2Exception) {
                    throw new PixPdqMessageException("ClientUtilities: getFieldComponentsInRepeat - HL7V2Exception on component at index " + i);
                }
                ++i;
            }
            return values;
        }
        catch (HL7V2Exception hL7V2Exception) {
            throw new PixPdqMessageException("");
        }
    }

    public static boolean isHDParamValid(String namespaceId, String universalId, String universalIdType) {
        boolean str0 = false;
        boolean str1 = false;
        boolean str2 = false;
        if (namespaceId != null && namespaceId.length() > 0) {
            str0 = true;
        }
        if (universalId != null && universalId.length() > 0) {
            str1 = true;
        }
        if (universalIdType != null && universalIdType.length() > 0) {
            str2 = true;
        }
        return str0 && !str1 && !str2 || str1 && str2 || str0 && str1 && str2;
    }
}

