/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.hl7v2.mllpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.conformance.CPDocument;
import org.eclipse.ohf.hl7v2.core.conformance.CPManager;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.definitions.DefinitionManager;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.formats.VerticalBarComposer;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.validators.CPValidator;
import org.eclipse.ohf.hl7v2.core.validators.DefinitionValidator;
import org.eclipse.ohf.hl7v2.core.validators.ValidationItemList;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClient;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientDummy;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageUtilities;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.common.mllp.MLLPDestination;
import org.eclipse.ohf.ihe.common.mllp.MLLPException;

public class Client {
    private static Logger logger;
    private ATNAAuditClient auditor = new ATNAAuditClientDummy();
    private MessageManager globalFactory;
    private CPDocument cpDoc;
    private CPConformanceProfile cpProfile;
    private CPValidator cpVal;
    private DefinitionValidator defVal;
    private boolean canVerifyConformanceProfile = false;
    private int maxVerifyEvent = 2;
    public static final int SEND_MLLP_DEST = 1;
    private int sendMethod;
    private MLLPDestination dMLLP;
    public static final String ATNA_PIXS_AUDITSOURCE = "OHF_PixSource";
    public static final String ATNA_PIXC_AUDITSOURCE = "OHF_PixConsumer";
    public static final String ATNA_PDQ_AUDITSOURCE = "OHF_PdqConsumer";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.common.hl7v2.mllpclient.Client");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public Client() throws ClientException {
        try {
            VersionDefnList versions = DefinitionManager.createDefinitionFromJavaCode();
            this.globalFactory = MessageManager.getFactory();
            this.globalFactory.setVersionDefinitions(versions);
            this.defVal = new DefinitionValidator();
            this.canVerifyConformanceProfile = false;
        }
        catch (HL7V2Exception e) {
            logger.error((Object)("Client: constructor - javaCode " + e.getLocalizedMessage()), (Throwable)e);
            throw new ClientException(e);
        }
    }

    public Client(InputStream conformanceProfile) throws ClientException {
        try {
            VersionDefnList versions = DefinitionManager.createDefinitionFromJavaCode();
            this.globalFactory = MessageManager.getFactory();
            this.globalFactory.setVersionDefinitions(versions);
            this.defVal = new DefinitionValidator();
            if (conformanceProfile != null) {
                this.cpDoc = CPManager.load((InputStream)conformanceProfile, (int)1);
                this.cpProfile = this.cpDoc.getProfile();
                this.cpVal = new CPValidator(this.cpProfile);
                this.canVerifyConformanceProfile = true;
            } else {
                logger.warn((Object)"Client: constructor - javaCode w/conformance encountered invalid conformance profile.");
                this.canVerifyConformanceProfile = false;
            }
        }
        catch (HL7V2Exception e) {
            logger.error((Object)("Client: constructor - javaCode w/conformance " + e.getLocalizedMessage()), (Throwable)e);
            throw new ClientException(e);
        }
    }

    public boolean isDoAudit() {
        return AtnaAgentFactory.getAtnaAgent().isDoAudit();
    }

    public void setDoAudit(boolean doAudit) {
    }

    public int getMaxVerifyEvent() {
        return this.maxVerifyEvent;
    }

    public void setMaxVerifyEvent(int maxVerifyEvent) {
        this.maxVerifyEvent = maxVerifyEvent;
    }

    public MLLPDestination getMLLPDestination() {
        return this.dMLLP;
    }

    public void setMLLPDestination(MLLPDestination MLLP) {
        this.dMLLP = MLLP;
        this.sendMethod = 1;
    }

    public URI getURI() {
        if (this.sendMethod == 1) {
            return this.dMLLP.getURI();
        }
        return null;
    }

    public void setMessageManager(MessageManager globalFactory) {
        this.globalFactory = globalFactory;
    }

    public MessageManager getMessageManager() {
        return this.globalFactory;
    }

    public CPConformanceProfile getCPProfile() {
        return this.cpProfile;
    }

    public boolean isCanVerifyConformanceProfile() {
        return this.canVerifyConformanceProfile;
    }

    public ValidationItemList getHL7DefinitionValidationItems(Message msg) throws ClientException {
        try {
            this.defVal.validate(msg);
        }
        catch (HL7V2Exception e) {
            logger.error((Object)"Client: verifyMessage - DefinitionValidator failed ");
            throw new ClientException(e);
        }
        return this.defVal.getItems();
    }

    public ValidationItemList getConformanceProfileValidationItems(Message msg) throws ClientException {
        if (!this.canVerifyConformanceProfile) {
            return null;
        }
        try {
            this.cpVal.validate(msg);
        }
        catch (HL7V2Exception e) {
            logger.error((Object)"Client: verifyMessage - CPValidator failed ");
            throw new ClientException(e);
        }
        return this.cpVal.getItems();
    }

    public String sendHL7(String rawHL7, boolean verify, String auditUser, String auditSource) throws ClientException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Client: sendHL7 - Entry ");
        }
        if (rawHL7 == null || rawHL7.length() < 1) {
            return null;
        }
        String response = new String();
        if (verify) {
            Message msg;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Client: sendHL7 - Verify Begin ");
            }
            try {
                msg = PixPdqMessageUtilities.stringToMsg(rawHL7);
            }
            catch (PixPdqMessageException e) {
                throw new ClientException((Throwable)((Object)e));
            }
            this.verifyMessage(msg);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Client: sendHL7 - Verify End ");
            }
        } else if (verify) {
            logger.warn((Object)"Client: sendHL7 - verification requested but not performed, lacking setup");
        }
        response = this.send(rawHL7, auditUser, auditSource);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Client: sendHL7 - Exit ");
        }
        return response;
    }

    public Message sendMsg(Message msg, boolean verify, String auditUser, String auditSource) throws ClientException {
        Message responseMsg;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Client: sendMsg -- Entry ");
        }
        if (msg == null) {
            logger.error((Object)"Client: sendMsg - encountered invalid Message (null)");
            throw new ClientException("Client: sendMsg - encountered invalid Message (null)");
        }
        String rawHL7 = new String();
        String response = new String();
        if (verify) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Client: sendMsg - Verify Begin ");
            }
            this.verifyMessage(msg);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Client: sendMsg - Verify End ");
            }
        }
        try {
            rawHL7 = PixPdqMessageUtilities.msgToString(msg);
        }
        catch (PixPdqMessageException e) {
            throw new ClientException((Throwable)((Object)e));
        }
        response = this.send(rawHL7, auditUser, auditSource);
        try {
            responseMsg = PixPdqMessageUtilities.stringToMsg(response);
        }
        catch (PixPdqMessageException e) {
            throw new ClientException((Throwable)((Object)e));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Client: sendMsg - Exit ");
        }
        return responseMsg;
    }

    public void setConformanceProfile(InputStream conformanceProfile) throws ClientException {
        try {
            if (conformanceProfile != null) {
                this.cpDoc = CPManager.load((InputStream)conformanceProfile, (int)1);
                this.cpProfile = this.cpDoc.getProfile();
                this.cpVal = new CPValidator(this.cpProfile);
                this.canVerifyConformanceProfile = true;
            } else {
                logger.warn((Object)"Client: setConformanceProfile - encountered invalid conformance profile, no change made.");
            }
        }
        catch (HL7V2Exception e) {
            logger.error((Object)("Client: setConformanceProfile " + e.getLocalizedMessage()), (Throwable)e);
            throw new ClientException(e);
        }
    }

    public void setConformanceProfileUseToFalse() {
        this.cpProfile = null;
        this.canVerifyConformanceProfile = false;
    }

    private void verifyMessage(Message msg) throws ClientException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Client: verifyMessage - Entry ");
        }
        boolean hl7DefsExceeded = false;
        boolean cpExceeded = false;
        hl7DefsExceeded = this.verifyHL7Defs(msg);
        if (this.canVerifyConformanceProfile) {
            cpExceeded = this.verifyConformanceProfile(msg);
        }
        if (hl7DefsExceeded && cpExceeded) {
            logger.error((Object)"Client: verifyMessage - Exceeded Max Error Level ");
            throw new ClientException("Both Definition and Conformance Profile verification errors blocking transmission ");
        }
        if (hl7DefsExceeded) {
            logger.error((Object)"Client: verifyMessage - Exceeded Max Error Level ");
            throw new ClientException("Definition verification errors blocking transmission ");
        }
        if (cpExceeded) {
            logger.error((Object)"Client: verifyMessage - Exceeded Max Error Level ");
            throw new ClientException("Conformance Profile verification errors blocking transmission ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Client: verifyMessage - Exit ");
        }
    }

    private boolean verifyHL7Defs(Message msg) throws ClientException {
        try {
            this.defVal.validate(msg);
        }
        catch (HL7V2Exception e) {
            logger.error((Object)"Client: verifyMessage - DefinitionValidator failed ");
            throw new ClientException(e);
        }
        ValidationItemList defItems = this.defVal.getItems();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Client: verifyMessage - definition validation check complete. There were " + defItems.size() + " events documented "));
        }
        boolean maxExceeded = false;
        int i = 0;
        while (i < defItems.size()) {
            try {
                logger.info((Object)("Client: verifyMessage - level " + defItems.item(i).getType() + " - " + defItems.item(i).getNode().elementName() + " - " + defItems.item(i).getMessage()));
            }
            catch (HL7V2Exception e) {
                throw new ClientException(e);
            }
            if (defItems.item(i).getType() > this.maxVerifyEvent) {
                maxExceeded = true;
            }
            ++i;
        }
        return maxExceeded;
    }

    private boolean verifyConformanceProfile(Message msg) throws ClientException {
        try {
            this.cpVal.validate(msg);
        }
        catch (HL7V2Exception e) {
            logger.error((Object)"Client: verifyMessage - CPValidator failed ");
            throw new ClientException(e);
        }
        ValidationItemList cpItems = this.cpVal.getItems();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Client: verifyMessage - cp validation check complete. There were " + cpItems.size() + " events documented "));
        }
        boolean maxExceeded = false;
        int i = 0;
        while (i < cpItems.size()) {
            if (logger.isDebugEnabled()) {
                try {
                    logger.info((Object)("Client: verifyMessage - level " + cpItems.item(i).getType() + " - " + cpItems.item(i).getNode().elementName() + " - " + cpItems.item(i).getMessage()));
                }
                catch (HL7V2Exception e) {
                    throw new ClientException(e);
                }
            }
            if (cpItems.item(i).getType() > this.maxVerifyEvent) {
                maxExceeded = true;
            }
            ++i;
        }
        return maxExceeded;
    }

    private String send(String hl7, String auditUser, String auditSource) throws ClientException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Client: send - Entry ");
        }
        if (this.isDoAudit()) {
            try {
                this.auditor.auditActorStartEvent(0, auditSource, auditUser);
            }
            catch (ATNAAuditClientException e) {
                logger.error((Object)"Failed application start audit event");
                throw new ClientException("Failed application start audit event", -1, e);
            }
            if (auditUser == null || auditUser.length() < 1) {
                logger.error((Object)"Failure in audit log: auditUser required");
                this.applicationStopEvent(auditUser, auditSource);
                throw new ClientException("Failure in audit log: auditUser required");
            }
            if (auditSource == null || auditSource.length() < 1) {
                logger.error((Object)"Failure in audit log: auditSource required");
                this.applicationStopEvent(auditUser, auditSource);
                throw new ClientException("Failure in audit log: auditSource required");
            }
            if (auditSource != ATNA_PIXS_AUDITSOURCE && auditSource != ATNA_PIXC_AUDITSOURCE && auditSource != ATNA_PDQ_AUDITSOURCE) {
                logger.error((Object)("Failure in audit log: auditSource " + auditSource + " invalid"));
                this.applicationStopEvent(auditUser, auditSource);
                throw new ClientException("Failure in audit log: auditSource " + auditSource + " invalid");
            }
        }
        String response = new String();
        if (this.sendMethod == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Client: send - Enter SEND_MLLP_DEST \r" + hl7));
            }
            if (this.dMLLP != null) {
                try {
                    response = this.dMLLP.sendMessage(hl7);
                }
                catch (MLLPException e2) {
                    logger.error((Object)"Client: send - MLLP.sendMessage ");
                    this.applicationStopEvent(auditUser, auditSource);
                    throw new ClientException("Message delivery failed ", -1, e2);
                }
            } else {
                this.applicationStopEvent(auditUser, auditSource);
                throw new ClientException("Missing MLLP Destination ");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Client: send - Exit SEND_MLLP_DEST ");
            }
        } else {
            logger.error((Object)"Client: send - unknown sendMethod ");
            this.applicationStopEvent(auditUser, auditSource);
            throw new ClientException("Missing ANY Destination ");
        }
        if (this.isDoAudit()) {
            int eventOutcome;
            if (response != null) {
                Message msg = null;
                try {
                    msg = PixPdqMessageUtilities.stringToMsg(response);
                }
                catch (PixPdqMessageException e) {
                    logger.error((Object)"got an exception when getting the message", (Throwable)((Object)e));
                    int e2 = 8;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("got message: " + msg));
                }
                if (msg == null) {
                    throw new IllegalArgumentException("message is null");
                }
                eventOutcome = msg.getSegments().countByCode("ERR") > 0 ? 8 : 0;
            } else {
                eventOutcome = 8;
            }
            if (auditSource == ATNA_PIXC_AUDITSOURCE || auditSource == ATNA_PDQ_AUDITSOURCE) {
                try {
                    this.auditor.auditQueryEvent(eventOutcome, auditUser, this.getURI().toString(), hl7);
                    this.auditor.auditPHIImportEvent(eventOutcome, auditUser, this.getURI().toString(), this.getImportPatientID(response), response);
                }
                catch (ATNAAuditClientException e) {
                    this.applicationStopEvent(auditUser, auditSource);
                    throw new ClientException(e);
                }
            }
            if (auditSource == ATNA_PIXS_AUDITSOURCE) {
                try {
                    this.auditor.auditPHIExportEvent(eventOutcome, auditUser, this.getURI().toString(), this.getExportPatientID(hl7), hl7);
                }
                catch (ATNAAuditClientException e) {
                    this.applicationStopEvent(auditUser, auditSource);
                    throw new ClientException(e);
                }
            }
            this.applicationStopEvent(auditUser, auditSource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Client: send - Exit ");
        }
        return response;
    }

    private void applicationStopEvent(String auditUser, String auditSource) throws ClientException {
        try {
            this.auditor.auditActorStopEvent(0, auditSource, auditUser);
        }
        catch (ATNAAuditClientException e) {
            logger.error((Object)"Failed application stop audit event");
            throw new ClientException("Failed application stop audit event", -1, e);
        }
    }

    private String[] getImportPatientID(String hl7) throws ClientException {
        int count;
        Message query = null;
        try {
            query = PixPdqMessageUtilities.stringToMsg(hl7);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating import patientIDs from: " + hl7));
            }
            count = query.getSegments().countByCode("PID");
        }
        catch (PixPdqMessageException e) {
            throw new ClientException((Throwable)((Object)e));
        }
        String[] patientID = new String[count];
        int i = 0;
        while (i < count) {
            Segment seg = query.getSegments().getByCodeAndIndex("PID", i + 1);
            patientID[i] = this.getFullPID3(seg);
            ++i;
        }
        return patientID;
    }

    private String getExportPatientID(String hl7) throws ClientException {
        String patientID = null;
        try {
            Message pixFeed = PixPdqMessageUtilities.stringToMsg(hl7);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating export patientID from: " + hl7));
            }
            Segment seg = pixFeed.getSegments().getByCodeAndIndex("PID", 1);
            patientID = this.getFullPID3(seg);
        }
        catch (PixPdqMessageException e) {
            throw new ClientException((Throwable)((Object)e));
        }
        return patientID;
    }

    private String getFullPID3(Segment seg) throws ClientException {
        VerticalBarComposer composer = null;
        ByteArrayOutputStream out = null;
        OutputStream outStream = null;
        try {
            Field fld = seg.getFields().item(2);
            if (fld.hasRepeats()) {
                fld = fld.getRepeats().item(0);
            }
            out = new ByteArrayOutputStream();
            composer = new VerticalBarComposer((OutputStream)out);
            composer.compose(fld);
            outStream = composer.getStream();
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
        catch (HL7V2Exception e) {
            throw new ClientException(e);
        }
        return outStream.toString();
    }
}

