/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.storedquery;

import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.xds.consumer.query.DateTimeRange;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.MalformedStoredQueryException;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQuery;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQueryBuilderUtils;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;

public class FindDocumentsQuery
extends StoredQuery {
    public FindDocumentsQuery(CX patientID, AvailabilityStatusType[] status) throws MalformedStoredQueryException {
        super("urn:uuid:14d4debf-8f97-4251-9a74-a90016b0af0d");
        if (patientID == null) {
            throw new MalformedStoredQueryException("Null patient ID. Cannot proceed with query.");
        }
        if (patientID.getIdNumber() == null) {
            throw new MalformedStoredQueryException("Empty patient ID number. Cannot proceed with query.");
        }
        if (patientID.getAssigningAuthorityUniversalId() == null) {
            throw new MalformedStoredQueryException("Empty patient ID assigning authority universal id. Cannot proceed with query.");
        }
        if (patientID.getAssigningAuthorityUniversalIdType() == null) {
            throw new MalformedStoredQueryException("Empty atient ID assigning authority universal id type. Cannot proceed with query.");
        }
        if (!patientID.getAssigningAuthorityUniversalIdType().equals("ISO")) {
            throw new MalformedStoredQueryException("Patient ID assigning authority universal id type is not 'ISO'. Cannot proceed with query.");
        }
        if (status == null) {
            throw new MalformedStoredQueryException("Empty status. Cannot proceed with query.");
        }
        if (status[0] == null) {
            throw new MalformedStoredQueryException("Empty status. Cannot proceed with query.");
        }
        StoredQueryBuilderUtils.addPatientIdParameter(this.queryParameters, patientID);
        StoredQueryBuilderUtils.addStatusParameter(this.queryParameters, status);
    }

    public FindDocumentsQuery(CX patientID, CodedMetadataType[] classCodes, DateTimeRange[] dateTimeRanges, CodedMetadataType[] practiceSettingCodes, CodedMetadataType[] healthCareFacilityCodes, CodedMetadataType[] eventCodeList, CodedMetadataType[] confidentialityCodes, CodedMetadataType[] formatCodes, AvailabilityStatusType[] status) throws MalformedStoredQueryException {
        this(patientID, status);
        if (classCodes != null && classCodes.length > 0) {
            StoredQueryBuilderUtils.addCodedParameters(this.queryParameters, "urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a", classCodes);
        }
        if (dateTimeRanges != null && dateTimeRanges.length > 0) {
            int i = 0;
            while (i < dateTimeRanges.length) {
                StoredQueryBuilderUtils.addDateTimeParameters(this.queryParameters, dateTimeRanges[i]);
                ++i;
            }
        }
        if (practiceSettingCodes != null && practiceSettingCodes.length > 0) {
            StoredQueryBuilderUtils.addCodedParameters(this.queryParameters, "urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead", practiceSettingCodes);
        }
        if (healthCareFacilityCodes != null && healthCareFacilityCodes.length > 0) {
            StoredQueryBuilderUtils.addCodedParameters(this.queryParameters, "urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1", healthCareFacilityCodes);
        }
        if (eventCodeList != null && eventCodeList.length > 0) {
            StoredQueryBuilderUtils.addCodedParameters(this.queryParameters, "urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4", eventCodeList);
        }
        if (confidentialityCodes != null && confidentialityCodes.length > 0) {
            StoredQueryBuilderUtils.addCodedParameters(this.queryParameters, "urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f", confidentialityCodes);
        }
        if (formatCodes != null && formatCodes.length > 0) {
            StoredQueryBuilderUtils.addCodedParameters(this.queryParameters, "urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d", formatCodes);
        }
    }
}

