/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.storedquery;

import java.util.HashMap;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.consumer.query.DateTimeRange;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.MalformedStoredQueryException;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;

public class StoredQueryBuilderUtils {
    public static String buildListArgs(String[] args) {
        StringBuffer list = new StringBuffer("");
        int i = 0;
        while (i < args.length) {
            list.append(args[i]);
            if (i < args.length - 1) {
                list.append(", ");
            }
            ++i;
        }
        return list.toString();
    }

    public static String checkForSingleQuote(String s) {
        StringBuffer buffer = new StringBuffer(s);
        int i = 0;
        while (i < buffer.length()) {
            if (buffer.charAt(i) == '\'') {
                buffer.insert(i, '\'');
                ++i;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void addPatientIdParameter(HashMap queryParameters, CX patientId) throws MalformedStoredQueryException {
        String clause = String.valueOf('\'') + HL7V2MessageFormat.toMessageString((CX)patientId, (char)'^', (char)'&') + '\'';
        queryParameters.put("$XDSDocumentEntryPatientId", clause);
    }

    public static void addStatusParameter(HashMap queryParameters, AvailabilityStatusType[] status) throws MalformedStoredQueryException {
        String[] statusString = new String[status.length];
        int i = 0;
        while (i < status.length) {
            statusString[i] = "'urn:oasis:names:tc:ebxml-regrep:StatusType:" + status[i].getName() + '\'';
            ++i;
        }
        String clause = String.valueOf('(') + StoredQueryBuilderUtils.buildListArgs(statusString) + ')';
        queryParameters.put("$XDSDocumentEntryStatus", clause);
    }

    public static void addCodedParameters(HashMap queryParameters, String codeUUID, CodedMetadataType[] codes) throws MalformedStoredQueryException {
        if (codeUUID == null) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        if (codes == null) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        if (codes.length == 0) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        if (queryParameters == null) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        String codeParameterName = null;
        String codeSchemeParameterName = null;
        if (codeUUID.equals("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a")) {
            codeParameterName = "$XDSDocumentEntryClassCode";
            codeSchemeParameterName = "$XDSDocumentEntryClassCodeScheme";
        } else if (codeUUID.equals("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f")) {
            codeParameterName = "$XDSDocumentEntryConfidentialityCode";
        } else if (codeUUID.equals("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4")) {
            codeParameterName = "$XDSDocumentEntryEventCodeList";
            codeSchemeParameterName = "$XDSDocumentEntryEventCodeListScheme";
        } else if (codeUUID.equals("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d")) {
            codeParameterName = "$XDSDocumentEntryFormatCode";
        } else if (codeUUID.equals("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1")) {
            codeParameterName = "$XDSDocumentEntryHealthcareFacilityTypeCode";
            codeSchemeParameterName = "$XDSDocumentEntryHealthcareFacilityTypeCodeScheme";
        } else if (codeUUID.equals("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead")) {
            codeParameterName = "$XDSDocumentEntryPracticeSettingCode";
            codeSchemeParameterName = "$XDSDocumentEntryPracticeSettingCodeScheme";
        } else if (!codeUUID.equals("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983") && !codeUUID.equals("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500")) {
            codeUUID.equals("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5");
        }
        if (codeParameterName == null) {
            throw new MalformedStoredQueryException("Unidentified codeUUID. Cannot proceed with query building.");
        }
        int valid = StoredQueryBuilderUtils.validCodeList(codes);
        switch (valid) {
            case -1: {
                throw new MalformedStoredQueryException("Number of coding schemes is neither zero nor equal to the number of code values.  Cannot proceed with query building.");
            }
            case 1: {
                String[] codesString;
                if (codeSchemeParameterName != null) {
                    codesString = new String[codes.length];
                    int i = 0;
                    while (i < codes.length) {
                        codesString[i] = String.valueOf('\'') + StoredQueryBuilderUtils.checkForSingleQuote(codes[i].getSchemeName()) + '\'';
                        ++i;
                    }
                    String clause = String.valueOf('(') + StoredQueryBuilderUtils.buildListArgs(codesString) + ')';
                    queryParameters.put(codeSchemeParameterName, clause);
                }
            }
            case 0: {
                String[] codesString = new String[codes.length];
                int i = 0;
                while (i < codes.length) {
                    codesString[i] = String.valueOf('\'') + StoredQueryBuilderUtils.checkForSingleQuote(codes[i].getCode()) + '\'';
                    ++i;
                }
                String clause = String.valueOf('(') + StoredQueryBuilderUtils.buildListArgs(codesString) + ')';
                queryParameters.put(codeParameterName, clause);
            }
        }
    }

    public static void addDateTimeParameters(HashMap queryParameters, DateTimeRange range) throws MalformedStoredQueryException {
        if (queryParameters == null) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        if (range == null) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        if (range.getSlotName() == null) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        if (range.getFrom() == null) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        if (range.getTo() == null) {
            throw new MalformedStoredQueryException("Null parameters.");
        }
        if (range.getSlotName().equals("creationTime")) {
            queryParameters.put("$XDSDocumentEntryCreationTimeFrom", range.getFrom());
            queryParameters.put("$XDSDocumentEntryCreationTimeTo", range.getTo());
        } else if (range.getSlotName().equals("serviceStartTime")) {
            queryParameters.put("$XDSDocumentEntryServiceStartTimeFrom", range.getFrom());
            queryParameters.put("$XDSDocumentEntryServiceStartTimeTo", range.getTo());
        } else if (range.getSlotName().equals("serviceStopTime")) {
            queryParameters.put("$XDSDocumentEntryServiceStopTimeFrom", range.getFrom());
            queryParameters.put("$XDSDocumentEntryServiceStopTimeTo", range.getTo());
        } else if (!range.getSlotName().equals("submissionTime") && !range.getSlotName().equals("lastUpdateTime")) {
            throw new MalformedStoredQueryException("Unidentified date/time slot name.");
        }
    }

    public static int validCodeList(CodedMetadataType[] codes) {
        int codeCount = 0;
        int schemeNameCount = 0;
        int i = 0;
        while (i < codes.length) {
            if (codes[i].getCode() != null) {
                ++codeCount;
                if (codes[i].getSchemeName() != null) {
                    ++schemeNameCount;
                }
            } else {
                return -1;
            }
            ++i;
        }
        if (schemeNameCount == 0) {
            return 0;
        }
        if (schemeNameCount == codeCount) {
            return 1;
        }
        return -1;
    }
}

