/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditActiveParticipantRoleID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditParticipantObjectIDTypeCode;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.ParticipantObjectIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;

public class QueryMessage
extends AuditMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public QueryMessage() throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this.setMessagetype("query");
        if (this.getEventIdentification() != null) {
            this.getEventIdentification().setEventActionCode("E");
            this.getEventIdentification().setEventID(new AuditEventID.Query());
        }
    }

    public QueryMessage(String timestamp, int eventOutcomeIndicator, String sendingUserID, String sendingUsername, String receivingUserID, String receivingUsername, String participantObjectId, String participantObjectQuery, String sourceId) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        super(sourceId);
        EventIdentificationType eventId = new EventIdentificationType(0);
        eventId.setEventActionCode("E");
        eventId.setEventID(new AuditEventID.Query());
        eventId.setEventDateTime(timestamp);
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        this.setEventIdentification(eventId);
        ActiveParticipantType source = null;
        source = new ActiveParticipantType();
        source.setUserID(sendingUserID);
        if (sendingUsername != null) {
            source.setUserName(sendingUsername);
        }
        source.setRoleIDCode(new AuditActiveParticipantRoleID.Source());
        this.setActiveParticipant(source);
        ActiveParticipantType destination = null;
        destination = new ActiveParticipantType();
        destination.setUserID(receivingUserID);
        if (receivingUsername != null) {
            destination.setUserName(receivingUsername);
        }
        destination.setUserIsRequestor(false);
        destination.setRoleIDCode(new AuditActiveParticipantRoleID.Destination());
        this.setActiveParticipant(destination);
        ParticipantObjectIdentificationType participantObject = new ParticipantObjectIdentificationType();
        participantObject.setParticipantObjectTypeCode((short)2);
        participantObject.setParticipantObjectTypeCodeRole((short)3);
        participantObject.setParticipantObjectIDTypeCode(new AuditParticipantObjectIDTypeCode.SOPClassUID());
        participantObject.setParticipantObjectID(participantObjectId);
        if (participantObjectQuery != null) {
            byte[] b = participantObjectQuery.getBytes();
            participantObject.setParticipantObjectQuery(b);
            this.setParticipationObjectIdentification(participantObject);
        } else {
            byte[] b = null;
            participantObject.setParticipantObjectQuery(b);
            this.setParticipationObjectIdentification(participantObject);
        }
    }
}

