/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.syslog.bsd;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.messages.QueryMessage;
import org.eclipse.ohf.ihe.atna.audit.syslog.bsd.BSDMessage;
import org.eclipse.ohf.ihe.atna.audit.util.TimeStamp;

public class BSDClient {
    private InetAddress addressToSend;
    private int portToSend;

    public BSDClient(InetAddress address, int port) {
        address = this.addressToSend;
        this.portToSend = port;
    }

    public BSDClient(String address, int port) throws UnknownHostException {
        this.addressToSend = InetAddress.getByName(address);
        this.portToSend = port;
    }

    public BSDClient(String addressAndPort) throws UnknownHostException {
        String address = addressAndPort.substring(0, addressAndPort.indexOf(":"));
        this.addressToSend = InetAddress.getByName(address);
        this.portToSend = new Integer(addressAndPort.substring(addressAndPort.indexOf(":") + 1));
    }

    public void sendMessage(BSDMessage message) throws IOException {
        DatagramSocket socket = new DatagramSocket();
        if (message != null) {
            byte[] buf = new byte[message.toString().getBytes().length];
            DatagramPacket packet = new DatagramPacket(buf, buf.length, this.addressToSend, this.portToSend);
            packet.setData(message.toString().getBytes());
            socket.send(packet);
        }
        socket.close();
    }

    public void sendMessage(String message) throws IOException {
        DatagramSocket socket = new DatagramSocket();
        if (message != null) {
            System.out.println(message.toString().getBytes().length);
            byte[] buf = new byte[message.toString().getBytes().length];
            DatagramPacket packet = new DatagramPacket(buf, buf.length, this.addressToSend, this.portToSend);
            packet.setData(message.toString().getBytes());
            socket.send(packet);
        }
        socket.close();
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 2 && args.length < 1) {
            System.out.println("Usage: java BSDClient <hostname> <port>");
            System.out.println("Or Usage: java BSDClient <hostname:port>");
            return;
        }
        BSDClient client = null;
        if (args.length == 2) {
            client = new BSDClient(args[0], (int)new Integer(args[1]));
        } else if (args.length == 1) {
            client = new BSDClient(args[0].substring(0, args[0].indexOf(":")), (int)new Integer(args[0].substring(args[0].indexOf(":") + 1)));
        }
        try {
            QueryMessage auditMessage = new QueryMessage(TimeStamp.generateUTCDateTime(), 0, "Homer", "Homer J Simpson", "Registry", null, "the patient", "select eo.id FROM...", "EHR_IBM");
            BSDMessage bsdMessage = new BSDMessage(InetAddress.getByName("lswin10.dfw.ibm.com"), "H_Simpson", auditMessage.toXml());
            client.sendMessage(bsdMessage);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (ATNAException e) {
            e.printStackTrace();
        }
    }

    public void sendMessageFromFile(String fromFile) throws IOException {
        BufferedReader input = new BufferedReader(new FileReader(fromFile));
        String line = null;
        while ((line = input.readLine()) != null) {
            System.out.println("Sending..." + line);
            this.sendMessage(line);
        }
    }
}

