/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.syslog.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TimeStamp {
    private Date today;
    private String result;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private SimpleDateFormat formatterBSD = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.US);

    public TimeStamp() {
        this.today = new Date();
    }

    public TimeStamp(String s) throws ParseException {
        this.today = null;
        this.stringToDate(s);
    }

    public String toString() {
        if (this.result == null) {
            this.result = this.formatter.format(this.today);
            StringBuffer sb = new StringBuffer(this.result);
            sb.insert(sb.length() - 2, ':');
            this.result = sb.toString();
        }
        return this.result;
    }

    public String bsdSyslogToString() {
        String lResult = this.formatterBSD.format(this.today);
        StringBuffer sb = new StringBuffer();
        if (lResult.charAt(4) == '0') {
            sb.append(lResult.substring(0, 4));
            sb.append(' ');
            sb.append(lResult.substring(5));
        } else {
            sb.append(lResult);
        }
        return sb.toString();
    }

    public String toXml() {
        return " timestamp='" + this.toString() + "' ";
    }

    public void stringToDate(String dated) throws ParseException {
        int checkIndex = dated.length() - 3;
        if (dated.charAt(checkIndex) == ':') {
            StringBuffer sb = new StringBuffer(dated);
            sb.deleteCharAt(checkIndex);
            dated = sb.toString();
        }
        this.result = null;
        this.today = this.formatter.parse(dated);
    }
}

