/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.transport;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.transport.ConnectionHandler;
import org.eclipse.ohf.ihe.atna.transport.service.transporter.TransporterService;
import org.eclipse.ohf.ihe.common.atna.ConfigurationManager;
import org.eclipse.ohf.ihe.common.atna.NoSecurityDomainException;
import org.eclipse.ohf.ihe.common.atna.SecurityDomain;

public class TransporterImpl
implements TransporterService {
    private static final Logger logger;
    private int MAX_RETRY_COUNT = 3;
    private int RETRY_WAIT = 2000;
    private int socketTimeoutMS = 0;
    private static ThreadLocal sConnectionHandlerContainer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.atna.transport.TransporterImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        sConnectionHandlerContainer = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return null;
            }
        };
    }

    public Socket getSocket(URI uri, boolean wantTLS) throws KeyManagementException, NoSecurityDomainException, NoSuchAlgorithmException, UnknownHostException, IOException {
        if (!ConfigurationManager.isTLSEnabled() && !ConfigurationManager.isNonTLSConnectionsPermitted()) {
            StringBuffer stringBuffer = new StringBuffer("TLS has been disabled for ATNA connections via ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.atna.ConfigurationManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new NoSuchAlgorithmException(stringBuffer.append(clazz.getName()).append(".setSetTLSEnabled(false)").toString());
        }
        boolean useTLS = wantTLS && ConfigurationManager.isTLSEnabled() || !ConfigurationManager.isNonTLSConnectionsPermitted();
        Socket socket = null;
        if (useTLS) {
            socket = this.createTLSSocket(uri);
            if (useTLS) {
                logger.info((Object)("Connection succesfully made using TLS to " + uri.toString()));
            }
        } else {
            socket = this.createSocket(uri);
        }
        return socket;
    }

    public SSLSocket createTLSSocket(URI uri) throws NoSecurityDomainException, NoSuchAlgorithmException, KeyManagementException, UnknownHostException, IOException {
        if (!ConfigurationManager.isTLSEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("TLS has been disabled for ATNA connections via ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.atna.ConfigurationManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new NoSuchAlgorithmException(stringBuffer.append(clazz.getName()).append(".setSetTLSEnabled(false)").toString());
        }
        SecurityDomain securityDomain = ConfigurationManager.getSecurityDomain((URI)uri);
        SSLSocketFactory factory = null;
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLSv1");
        }
        catch (NoSuchAlgorithmException e) {
            securityDomain.restoreSystemEnvironment();
            throw e;
        }
        ctx.init(securityDomain.getKeyManagerFactory().getKeyManagers(), securityDomain.getTrustManagerFactory().getTrustManagers(), null);
        factory = ctx.getSocketFactory();
        SSLSocket socket = null;
        factory.getSupportedCipherSuites();
        if (logger.isDebugEnabled()) {
            String[] supportedSuites = factory.getSupportedCipherSuites();
            logger.debug((Object)"\n\nSupported ciper suites are:");
            int i = 0;
            while (i < supportedSuites.length) {
                logger.debug((Object)("\t" + supportedSuites[i]));
                ++i;
            }
        }
        int retries = 0;
        while (retries < this.MAX_RETRY_COUNT) {
            try {
                socket = (SSLSocket)factory.createSocket(uri.getHost(), uri.getPort());
                socket.setEnabledProtocols(new String[]{"TLSv1"});
                socket.setEnabledCipherSuites(securityDomain.getCipherSuites());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\n\nEnabled Cipher suites for connection are: ");
                    String[] suites = socket.getEnabledCipherSuites();
                    int i = 0;
                    while (i < suites.length) {
                        logger.debug((Object)("\t" + suites[i]));
                        ++i;
                    }
                }
                socket.setSoTimeout(this.socketTimeoutMS);
                socket.setKeepAlive(true);
                socket.startHandshake();
                break;
            }
            catch (SSLHandshakeException e) {
                logger.error((Object)("Handshake failed with server " + uri.toString() + " reason " + e.getLocalizedMessage()));
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    logger.error((Object)("Error trying to close socket for " + uri.toString() + " reason " + e1.getLocalizedMessage()));
                }
                securityDomain.restoreSystemEnvironment();
                throw e;
            }
            catch (UnknownHostException e) {
                logger.error((Object)("Unable to establish connection to " + uri.toString() + " reason " + e.getLocalizedMessage()));
                securityDomain.restoreSystemEnvironment();
                throw e;
            }
            catch (SocketException e) {
                logger.error((Object)("Error connecting to " + uri.toString() + ". Will retry in " + this.RETRY_WAIT / 1000 + " seconds."), (Throwable)e);
                try {
                    Thread.sleep(this.RETRY_WAIT);
                    ++retries;
                }
                catch (InterruptedException interruptedException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Sleep awoken early");
                    }
                    ++retries;
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error connecting to " + uri.toString() + ". Will retry in " + this.RETRY_WAIT / 1000 + " seconds." + " reason " + e.getLocalizedMessage()));
                ++retries;
            }
        }
        if (retries > this.MAX_RETRY_COUNT) {
            securityDomain.restoreSystemEnvironment();
            throw new ConnectException("Secure socket retries exhausted ");
        }
        securityDomain.restoreSystemEnvironment();
        return socket;
    }

    private Socket createSocket(URI uri) throws SocketException, UnknownHostException {
        Socket socket = null;
        int retries = 0;
        Throwable cause = null;
        while (retries < this.MAX_RETRY_COUNT) {
            try {
                socket = new Socket(uri.getHost(), uri.getPort());
                socket.setSoTimeout(this.socketTimeoutMS);
                socket.setKeepAlive(true);
                break;
            }
            catch (UnknownHostException e) {
                logger.error((Object)("Unknown host. Unable to establish connection to " + uri.toString() + " reason " + e.getLocalizedMessage()));
                throw e;
            }
            catch (SocketException e) {
                logger.error((Object)("Error connecting to " + uri.toString() + ". Will retry in " + this.RETRY_WAIT / 1000 + " seconds. " + (this.MAX_RETRY_COUNT - retries) + " retries left. Cause: " + e.getLocalizedMessage()));
                try {
                    Thread.sleep(this.RETRY_WAIT);
                    ++retries;
                }
                catch (InterruptedException interruptedException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Sleep awoken early");
                    }
                    ++retries;
                    cause = e;
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error connecting to " + uri.toString() + ". Will retry in " + this.RETRY_WAIT / 1000 + " seconds. " + (this.MAX_RETRY_COUNT - retries) + " retries left. Cause: " + e.getLocalizedMessage()));
                ++retries;
                cause = e;
            }
        }
        if (retries == this.MAX_RETRY_COUNT) {
            throw new SocketException("Socket retries exhausted. " + (cause != null ? "Cause was: " + cause.getLocalizedMessage() : ""));
        }
        return socket;
    }

    public InputStream getInputStream(URI uri) throws NoSecurityDomainException, MalformedURLException, IOException, NoSuchAlgorithmException {
        boolean useTLS;
        if (!ConfigurationManager.isTLSEnabled() && !ConfigurationManager.isNonTLSConnectionsPermitted()) {
            StringBuffer stringBuffer = new StringBuffer("TLS has been disabled for ATNA connections via ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.atna.ConfigurationManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new NoSuchAlgorithmException(stringBuffer.append(clazz.getName()).append(".setSetTLSEnabled(false)").toString());
        }
        SecurityDomain securityDomain = null;
        boolean tlsURI = uri.getScheme().equalsIgnoreCase("https");
        boolean bl = useTLS = tlsURI && ConfigurationManager.isTLSEnabled() || !ConfigurationManager.isNonTLSConnectionsPermitted();
        if (useTLS) {
            securityDomain = ConfigurationManager.getSecurityDomain((URI)uri);
            securityDomain.setDomainEnvironment();
        }
        InputStream is = null;
        try {
            ConnectionHandler handler;
            URLConnection connection = uri.toURL().openConnection();
            if (useTLS && tlsURI) {
                ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String urlHostName, SSLSession session) {
                        logger.warn((Object)("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost()));
                        return true;
                    }
                });
            }
            if ((handler = (ConnectionHandler)sConnectionHandlerContainer.get()) != null) {
                handler.handleUrlConnection(connection);
            }
            is = connection.getInputStream();
            if (useTLS) {
                logger.info((Object)("Connection succesfully made using TLS to " + uri.toString()));
            }
        }
        catch (MalformedURLException e) {
            if (useTLS) {
                securityDomain.restoreSystemEnvironment();
            }
            throw e;
        }
        catch (IOException e) {
            if (useTLS) {
                securityDomain.restoreSystemEnvironment();
            }
            throw e;
        }
        if (useTLS) {
            securityDomain.restoreSystemEnvironment();
        }
        return is;
    }

    public static void setConnectionHandler(ConnectionHandler connectionHandler) {
        sConnectionHandlerContainer.set(connectionHandler);
    }
}

