/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.utilities.OHFException;

public class Iso8601DateUtilities {
    public static final String ISO_DATE_BASE_FORMAT = "yyyyMMddhhmmss";
    public static final String ISO_DATE_VALIDATION_FULL = "YYYY[MM[DD[HH[NN[SS[.U[U[U[U]]]]]]]]]";
    public static final int REQUIRED = 1;
    public static final int OPTIONAL = 2;
    public static final int PROHIBITED = 3;
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
    int milli;
    boolean inFraction;

    public String checkDateByMask(String content, String mask, int timezone) {
        String[] parts = new String[]{content};
        if (content.indexOf(43) > 0) {
            parts = StringUtils.split((String)content, (String)"+", (int)2);
        } else if (content.indexOf(45) > 0) {
            parts = StringUtils.split((String)content, (String)"-", (int)2);
        }
        String error = this.checkSections(parts[0], content, mask);
        if (error != null) {
            return error;
        }
        if (timezone == 1) {
            if (parts.length < 2) {
                return "No Timezone allowed, but a timezone found";
            }
            return this.checkDateByMask(parts[1], "TTtt", 3);
        }
        if (timezone == 2) {
            if (parts.length > 1) {
                return this.checkDateByMask(parts[1], "TTtt", 3);
            }
            return null;
        }
        if (parts.length == 2) {
            return "No Timezone allowed, but a timezone found";
        }
        return null;
    }

    private void clear() {
        this.year = 0;
        this.month = 0;
        this.day = 0;
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.milli = 0;
        this.inFraction = false;
    }

    private String checkSections(String content, String whole, String mask) {
        this.clear();
        String workingMask = StringUtils.strip((String)mask, (String)"]");
        String[] parts = new String[]{"", workingMask};
        boolean first = true;
        do {
            String token;
            if ((token = (parts = StringUtils.splitPreserveAllTokens((String)parts[1], (String)"[", (int)2))[0]) != null) {
                String section;
                String string = section = content == null || content.length() < token.length() ? null : content.substring(0, token.length());
                if (section == null) {
                    if (first) {
                        return "The section " + token + " in the Date format " + mask + " was not found in the value " + whole;
                    }
                } else {
                    if (section.length() < token.length()) {
                        return "The section " + token + " in the Date format " + mask + " was not completed in the value " + whole + " - value was " + section;
                    }
                    String error = this.checkSection(token, section);
                    if (error != null) {
                        return error;
                    }
                    content = section.length() >= content.length() ? null : content.substring(section.length());
                }
            }
            first = false;
        } while (parts.length > 1 && content != null);
        if (content != null) {
            return "The content " + content + " in the Date " + whole + " is not allowed by the format " + mask;
        }
        return null;
    }

    private boolean starts(String source, String test) {
        return source == null || source.length() < test.length() ? false : source.substring(0, test.length()).equals(test);
    }

    private String checkSection(String token, String content) {
        String error = null;
        if (this.starts(token, "YYYY")) {
            error = this.checkYear(content.substring(0, 4));
            if (error != null) {
                return error;
            }
            token = token.substring(4, token.length());
            content = content.substring(4, content.length());
        }
        if (this.starts(token, "MM")) {
            error = this.checkMonth(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "DD")) {
            error = this.checkDay(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "HH")) {
            error = this.checkHour(content.substring(0, 2), false);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "TT")) {
            error = this.checkHour(content.substring(0, 2), true);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "NN")) {
            error = this.checkMinute(content.substring(0, 2), false);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "tt")) {
            error = this.checkMinute(content.substring(0, 2), true);
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, "SS") && !this.inFraction) {
            error = this.checkSecond(content.substring(0, 2));
            if (error != null) {
                return error;
            }
            token = token.substring(2, token.length());
            content = content.substring(2, content.length());
        }
        if (this.starts(token, ".") && !this.inFraction) {
            error = this.checkDot(content.substring(0, 1));
            if (error != null) {
                return error;
            }
            token = token.substring(1, token.length());
            content = content.substring(1, content.length());
        }
        while (this.starts(token, "U") && this.inFraction) {
            error = this.checkFraction(content.substring(0, 1));
            if (error != null) {
                return error;
            }
            token = token.substring(1, token.length());
            content = content.substring(1, content.length());
        }
        if (token != null && !token.equals("")) {
            return "The Date Format fragment " + token + " is not known";
        }
        return null;
    }

    private String checkYear(String value) {
        if (value.length() != 4) {
            return "Year Value " + value + " is not 4 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Year Value " + value + "' is not numerical";
        }
        this.year = Integer.parseInt(value);
        if (this.year <= 0) {
            return "Year Value " + value + ": negative numbers are not supported";
        }
        return null;
    }

    private String checkMonth(String value) {
        if (value.length() != 2) {
            return "Month Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Month Value " + value + " is not numerical";
        }
        this.month = Integer.parseInt(value);
        if (this.month <= 0 || this.month > 12) {
            return "Month Value " + value + ": month must be 1 - 12";
        }
        return null;
    }

    private String checkDay(String value) {
        if (value.length() != 2) {
            return "Day Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Day Value " + value + " is not numerical";
        }
        this.day = Integer.parseInt(value);
        if (this.day <= 0) {
            return "Day Value " + value + ": Day must be >= 1";
        }
        if (this.month == 0) {
            return "Day Value " + value + ": Month must be known";
        }
        if (this.year == 0) {
            return "Day Value " + value + ": Year must be known";
        }
        if (this.day > this.getMaxDay()) {
            return "Day Value " + value + ": is illegal for the month " + Integer.toString(this.month) + "-" + Integer.toString(this.year);
        }
        return null;
    }

    private int getMaxDay() {
        int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (this.month == 2 && new GregorianCalendar().isLeapYear(this.year)) {
            return 29;
        }
        return daysInMonth[this.month - 1];
    }

    private String checkHour(String value, boolean max12) {
        if (value.length() != 2) {
            return "Hour Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Hour Value " + value + " is not numerical";
        }
        this.hour = Integer.parseInt(value);
        if (this.hour < 0) {
            return "Hour Value " + value + ": Hour must be >= 0";
        }
        if (max12 && this.hour > 12) {
            return "Hour Value " + value + ": Hour must be <= 12";
        }
        if (this.hour > 23) {
            return "Hour Value " + value + ": Hour must be <= 23";
        }
        return null;
    }

    private String checkMinute(String value, boolean inTimezone) {
        if (value.length() != 2) {
            return "Minute Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Minute Value " + value + " is not numerical";
        }
        this.minute = Integer.parseInt(value);
        if (inTimezone && this.minute != 0 && this.minute != 30) {
            return "Timezone Minute Value " + value + ": Minute must be 0 or 30";
        }
        if (this.minute < 0 || this.minute > 59) {
            return "Minute Value " + value + ": Minute must be 0 and 59";
        }
        return null;
    }

    private String checkSecond(String value) {
        if (value.length() != 2) {
            return "Second Value " + value + " is not 2 digits in length";
        }
        if (!StringUtils.isNumeric((String)value)) {
            return "Second Value " + value + " is not numerical";
        }
        this.second = Integer.parseInt(value);
        if (this.second < 0 || this.second > 59) {
            return "Second Value " + value + ": Second must be 0 and 59";
        }
        return null;
    }

    private String checkDot(String value) {
        if (value.equals(".")) {
            this.inFraction = true;
            return null;
        }
        return "Expected '.'";
    }

    private String checkFraction(String value) {
        if (!StringUtils.isNumeric((String)value)) {
            return "Fraction Value " + value + " is not numerical";
        }
        return null;
    }

    public static String format(Date value, String format) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(value);
        StringBuffer str = new StringBuffer();
        if (format.length() >= 4 && "yyyy".equalsIgnoreCase(format.substring(0, 4))) {
            str.append(StringUtils.leftPad((String)Integer.toString(cal.get(1)), (int)4, (String)"0"));
        }
        if (format.length() >= 6 && "mm".equalsIgnoreCase(format.substring(4, 6))) {
            str.append(StringUtils.leftPad((String)Integer.toString(cal.get(2)), (int)2, (String)"0"));
        }
        if (format.length() >= 8 && "dd".equalsIgnoreCase(format.substring(6, 8))) {
            str.append(StringUtils.leftPad((String)Integer.toString(cal.get(5)), (int)2, (String)"0"));
        }
        if (format.length() >= 10 && "hh".equalsIgnoreCase(format.substring(8, 10))) {
            str.append(StringUtils.leftPad((String)Integer.toString(cal.get(11)), (int)2, (String)"0"));
        }
        if (format.length() >= 12 && "nn".equalsIgnoreCase(format.substring(10, 12))) {
            str.append(StringUtils.leftPad((String)Integer.toString(cal.get(12)), (int)2, (String)"0"));
        }
        if (format.length() >= 14 && "ss".equalsIgnoreCase(format.substring(12, 14))) {
            str.append(StringUtils.leftPad((String)Integer.toString(cal.get(13)), (int)2, (String)"0"));
        }
        if (format.length() >= 18 && "sss".equalsIgnoreCase(format.substring(15, 18))) {
            str.append(".");
            str.append(StringUtils.leftPad((String)Integer.toString(cal.get(14)), (int)3, (String)"0"));
        } else if (format.length() == 17 && "ss".equalsIgnoreCase(format.substring(15, 17))) {
            str.append(".");
            str.append(StringUtils.leftPad((String)Integer.toString(cal.get(14) / 10), (int)2, (String)"0"));
        } else if (format.length() == 16 && "s".equalsIgnoreCase(format.substring(15, 16))) {
            str.append(".");
            str.append(Integer.toString(cal.get(14) / 100));
        }
        return str.toString();
    }

    public Date parse(String content, String mask, String path) throws OHFException {
        String msg = this.checkDateByMask(content, mask, 2);
        if (msg == null) {
            GregorianCalendar cal = new GregorianCalendar(this.year, this.month, this.day, this.hour, this.minute, this.second);
            return cal.getTime();
        }
        throw new OHFException(String.valueOf(msg) + " at " + path);
    }
}

