/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.xml;

import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLStringsParser
extends XMLObjectParser {
    private String namespace;
    private String name;
    private String[] content;
    private StringBuffer current = null;

    public XMLStringsParser(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public void endElement(String namespace, String name) throws SAXException {
        if (this.current != null) {
            this.addContent(this.current.toString());
        }
        this.current = null;
    }

    private void addContent(String string) {
        if (this.content == null) {
            this.content = new String[]{string};
        } else {
            String[] newContent = new String[this.content.length + 1];
            int i = 0;
            while (i < this.content.length) {
                newContent[i] = this.content[i];
                ++i;
            }
            newContent[this.content.length] = string;
            this.content = newContent;
        }
    }

    public XMLObjectParser startElement(String namespace, String name, String defaultNamespace, Attributes attributes) throws SAXException {
        if (namespace.equals(this.namespace) && name.equals(this.name)) {
            this.current = new StringBuffer();
            return null;
        }
        return super.startElement(namespace, name, defaultNamespace, attributes);
    }

    public void findText(char[] ch, int start, int length, boolean whitespace) throws SAXException {
        if (this.current == null) {
            super.findText(ch, start, length, whitespace);
        } else {
            this.current.append(ch, start, length);
        }
    }

    public String[] getContent() {
        return this.content;
    }

    public boolean hasText() throws SAXException {
        return true;
    }
}

