/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExternalIdentifierType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExtrinsicObjectType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.SlotType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.StatusType;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.Hl7v2Factory;
import org.eclipse.ohf.ihe.common.hl7v2.SourcePatientInfoType;
import org.eclipse.ohf.ihe.common.hl7v2.XAD;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.common.hl7v2.XON;
import org.eclipse.ohf.ihe.common.hl7v2.XPN;
import org.eclipse.ohf.ihe.common.hl7v2.XTN;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.metadata.AuthorType;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.ExtensionType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.ParentDocumentRelationshipType;
import org.eclipse.ohf.ihe.xds.metadata.ParentDocumentType;
import org.eclipse.ohf.ihe.xds.metadata.extract.DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;

public class EbXML_2_1DocumentEntryExtractor
implements DocumentEntryExtractor {
    public static final String DESCRIPTOR = "EBXML_DE_EXTR";
    private static final Logger logger;
    private ExtrinsicObjectType docData;
    private AssociationType1 parentData;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1DocumentEntryExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public EbXML_2_1DocumentEntryExtractor(ExtrinsicObjectType docData, AssociationType1 parentData) {
        this.docData = docData;
        this.parentData = parentData;
    }

    public DocumentEntryType extract() throws MetadataExtractionException {
        if (this.docData == null) {
            logger.error((Object)"ExtrinsicObject is null, cannot execute extraction.");
            throw new MetadataExtractionException("ExtrinsicObject is null, cannot execute extraction.");
        }
        DocumentEntryType docEntry = MetadataFactory.eINSTANCE.createDocumentEntryType();
        if (this.parentData != null) {
            String rel = this.parentData.getAssociationType();
            ParentDocumentType parentDoc = MetadataFactory.eINSTANCE.createParentDocumentType();
            if (rel.equals(ParentDocumentRelationshipType.XFRM_LITERAL.getName())) {
                parentDoc.setParentDocumentRelationship(ParentDocumentRelationshipType.XFRM_LITERAL);
            } else if (rel.equals(ParentDocumentRelationshipType.APND_LITERAL.getName())) {
                parentDoc.setParentDocumentRelationship(ParentDocumentRelationshipType.APND_LITERAL);
            } else if (rel.equals(ParentDocumentRelationshipType.RPLC_LITERAL.getName())) {
                parentDoc.setParentDocumentRelationship(ParentDocumentRelationshipType.RPLC_LITERAL);
            } else if (rel.equals(ParentDocumentRelationshipType.XFRMRPLC_LITERAL.getName())) {
                parentDoc.setParentDocumentRelationship(ParentDocumentRelationshipType.XFRMRPLC_LITERAL);
            } else {
                logger.error((Object)("AssociationType for parent document is not among the following: " + ParentDocumentRelationshipType.VALUES.toString()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Extracting parent document id from the Association.");
            }
            if (this.parentData.getTargetObject() != null) {
                parentDoc.setParentDocumentId(this.parentData.getTargetObject());
            } else {
                logger.error((Object)"Id for parent document is null");
            }
            if (this.parentData.getClassification() != null && !this.parentData.getClassification().isEmpty()) {
                String codeUUID;
                SlotType1 cSlot;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Extracting parent document relationship code from the Association.");
                }
                ClassificationType classification = (ClassificationType)this.parentData.getClassification().get(0);
                CodedMetadataType code = MetadataFactory.eINSTANCE.createCodedMetadataType();
                code.setCode(classification.getNodeRepresentation());
                code.setDisplayName(EbXML_2_1DocumentEntryExtractor.copy(classification.getName()));
                if (classification.getSlot() != null && classification.getSlot().size() > 0 && classification.getSlot().get(0) != null && (cSlot = (SlotType1)classification.getSlot().get(0)).getValueList() != null && cSlot.getValueList().getValue() != null && cSlot.getValueList().getValue().size() > 0) {
                    code.setSchemeName((String)cSlot.getValueList().getValue().get(0));
                }
                if ((codeUUID = classification.getClassificationScheme()) == null) {
                    logger.error((Object)("Required Classification/@classificationScheme attribute missing for following code: " + code.getCode() + ", " + code.getSchemeName() + ". Code will not be included in extracted content."));
                } else if (codeUUID == "urn:uuid:abd807a3-4432-4053-87b4-fd82c643d1f3") {
                    parentDoc.setParentDocumentRelationshipCode(code);
                } else {
                    logger.error((Object)("Required Classification/@classificationScheme attribute missing for following code: " + code.getCode() + ", " + code.getSchemeName() + ". Code will not be included in extracted content."));
                }
            }
            docEntry.setParentDocument(parentDoc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting attributes from the Extrinsic Object.");
        }
        this.extractExtrinsicObjectAttributes(docEntry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Name from the Extrinsic Object.");
        }
        docEntry.setTitle(EbXML_2_1DocumentEntryExtractor.copy(this.docData.getName()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting description from the Extrinsic Object.");
        }
        docEntry.setComments(EbXML_2_1DocumentEntryExtractor.copy(this.docData.getDescription()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Slot data from the Extrinsic Object.");
        }
        this.extractExtrinsicObjectSlots(docEntry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Classification data from the Extrinsic Object.");
        }
        this.extractExtrinsicObjectClassifications(docEntry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting ExternalIdentifier data from the Extrinsic Object.");
        }
        this.extractExtringsicObjectExternalIdentifiers(docEntry);
        return docEntry;
    }

    private void extractExtrinsicObjectAttributes(DocumentEntryType docEntry) {
        docEntry.setEntryUUID(this.docData.getId());
        if (this.docData.getStatus() != null) {
            if (this.docData.getStatus().equals(StatusType.APPROVED_LITERAL)) {
                docEntry.setAvailabilityStatus(AvailabilityStatusType.APPROVED_LITERAL);
            } else if (this.docData.getStatus().equals(StatusType.DEPRECATED_LITERAL)) {
                docEntry.setAvailabilityStatus(AvailabilityStatusType.DEPRECATED_LITERAL);
            } else if (this.docData.getStatus().equals(StatusType.SUBMITTED_LITERAL)) {
                docEntry.setAvailabilityStatus(AvailabilityStatusType.SUBMITTED_LITERAL);
            } else if (this.docData.getStatus().equals(StatusType.WITHDRAWN_LITERAL)) {
                docEntry.setAvailabilityStatus(AvailabilityStatusType.WITHDRAWN_LITERAL);
            }
        }
        docEntry.setMimeType(this.docData.getMimeType());
    }

    private void extractExtrinsicObjectSlots(DocumentEntryType docEntry) {
        EList slots = this.docData.getSlot();
        int i = 0;
        while (i < slots.size()) {
            SlotType1 slot = (SlotType1)slots.get(i);
            if (slot != null && slot.getName() != null && slot.getValueList() != null && slot.getValueList().getValue() != null && slot.getValueList().getValue().size() >= 1 && slot.getValueList().getValue().get(0) != null) {
                String slotName = slot.getName();
                if (slotName.equals("creationTime")) {
                    docEntry.setCreationTime((String)slot.getValueList().getValue().get(0));
                } else if (slotName.equals("hash")) {
                    docEntry.setHash((String)slot.getValueList().getValue().get(0));
                } else if (slotName.equals("languageCode")) {
                    docEntry.setLanguageCode((String)slot.getValueList().getValue().get(0));
                } else if (slotName.equals("legalAuthenticator")) {
                    String s = (String)slot.getValueList().getValue().get(0);
                    XCN authenticator = HL7V2MessageFormat.buildXCNFromMessageString((String)s, (char)'^', (char)'&');
                    docEntry.setLegalAuthenticator(authenticator);
                } else if (slotName.equals("repositoryUniqueId")) {
                    docEntry.setRepositoryUniqueId((String)slot.getValueList().getValue().get(0));
                } else if (slotName.equals("serviceStartTime")) {
                    docEntry.setServiceStartTime((String)slot.getValueList().getValue().get(0));
                } else if (slotName.equals("serviceStopTime")) {
                    docEntry.setServiceStopTime((String)slot.getValueList().getValue().get(0));
                } else if (slotName.equals("size")) {
                    docEntry.setSize((String)slot.getValueList().getValue().get(0));
                } else if (slotName.equals("sourcePatientId")) {
                    String s = (String)slot.getValueList().getValue().get(0);
                    CX sourcePatientId = HL7V2MessageFormat.buildCXFromMessageString((String)s, (char)'^', (char)'&');
                    docEntry.setSourcePatientId(sourcePatientId);
                } else if (slotName.equals("sourcePatientInfo")) {
                    int n = slot.getValueList().getValue().size();
                    SourcePatientInfoType sourcePatientInfo = Hl7v2Factory.eINSTANCE.createSourcePatientInfoType();
                    int j = 0;
                    while (j < n) {
                        XTN xtn;
                        String s = (String)slot.getValueList().getValue().get(j);
                        String itemNo = null;
                        if (s.startsWith("PID-10")) {
                            itemNo = "PID-10";
                        } else if (s.startsWith("PID-11")) {
                            itemNo = "PID-11";
                            if (s.length() > itemNo.length() + 1) {
                                XAD xad = HL7V2MessageFormat.buildXADFromMessageString((String)s.substring(itemNo.length() + 1), (char)'^');
                                sourcePatientInfo.setPatientAddress(xad);
                            }
                        } else if (s.startsWith("PID-12")) {
                            itemNo = "PID-12";
                        } else if (s.startsWith("PID-13")) {
                            itemNo = "PID-13";
                            if (s.length() > itemNo.length() + 1) {
                                xtn = HL7V2MessageFormat.buildXTNFromMessageString((String)s.substring(itemNo.length() + 1), (char)'^');
                                sourcePatientInfo.setPatientPhoneHome(xtn);
                            }
                        } else if (s.startsWith("PID-14")) {
                            itemNo = "PID-14";
                            if (s.length() > itemNo.length() + 1) {
                                xtn = HL7V2MessageFormat.buildXTNFromMessageString((String)s.substring(itemNo.length() + 1), (char)'^');
                                sourcePatientInfo.setPatientPhoneBusiness(xtn);
                            }
                        } else if (s.startsWith("PID-15")) {
                            itemNo = "PID-15";
                        } else if (s.startsWith("PID-16")) {
                            itemNo = "PID-16";
                        } else if (s.startsWith("PID-17")) {
                            itemNo = "PID-17";
                        } else if (s.startsWith("PID-18")) {
                            itemNo = "PID-18";
                        } else if (s.startsWith("PID-19")) {
                            itemNo = "PID-19";
                        } else if (s.startsWith("PID-1")) {
                            itemNo = "PID-1";
                        } else if (s.startsWith("PID-20")) {
                            itemNo = "PID-20";
                        } else if (s.startsWith("PID-21")) {
                            itemNo = "PID-21";
                        } else if (s.startsWith("PID-22")) {
                            itemNo = "PID-22";
                        } else if (s.startsWith("PID-23")) {
                            itemNo = "PID-23";
                        } else if (s.startsWith("PID-24")) {
                            itemNo = "PID-24";
                        } else if (s.startsWith("PID-25")) {
                            itemNo = "PID-25";
                        } else if (s.startsWith("PID-26")) {
                            itemNo = "PID-26";
                        } else if (s.startsWith("PID-27")) {
                            itemNo = "PID-27";
                        } else if (s.startsWith("PID-28")) {
                            itemNo = "PID-28";
                        } else if (s.startsWith("PID-29")) {
                            itemNo = "PID-29";
                        } else if (s.startsWith("PID-2")) {
                            itemNo = "PID-2";
                        } else if (s.startsWith("PID-30")) {
                            itemNo = "PID-30";
                        } else if (s.startsWith("PID-31")) {
                            itemNo = "PID-31";
                        } else if (s.startsWith("PID-32")) {
                            itemNo = "PID-32";
                        } else if (s.startsWith("PID-33")) {
                            itemNo = "PID-33";
                        } else if (s.startsWith("PID-34")) {
                            itemNo = "PID-34";
                        } else if (s.startsWith("PID-35")) {
                            itemNo = "PID-35";
                        } else if (s.startsWith("PID-36")) {
                            itemNo = "PID-36";
                        } else if (s.startsWith("PID-37")) {
                            itemNo = "PID-37";
                        } else if (s.startsWith("PID-38")) {
                            itemNo = "PID-38";
                        } else if (s.startsWith("PID-39")) {
                            itemNo = "PID-39";
                        } else if (s.startsWith("PID-3")) {
                            itemNo = "PID-3";
                            CX cx = HL7V2MessageFormat.buildCXFromMessageString((String)s.substring(itemNo.length() + 1), (char)'^', (char)'&');
                            sourcePatientInfo.getPatientIdentifier().add((Object)cx);
                        } else if (s.startsWith("PID-4")) {
                            itemNo = "PID-4";
                        } else if (s.startsWith("PID-5")) {
                            itemNo = "PID-5";
                            XPN xpn = HL7V2MessageFormat.buildXPNFromMessageString((String)s.substring(itemNo.length() + 1), (char)'^');
                            sourcePatientInfo.getPatientName().add((Object)xpn);
                        } else if (s.startsWith("PID-6")) {
                            itemNo = "PID-6";
                        } else if (s.startsWith("PID-7")) {
                            itemNo = "PID-7";
                            sourcePatientInfo.setPatientDateOfBirth(s.substring(itemNo.length() + 1));
                        } else if (s.startsWith("PID-8")) {
                            itemNo = "PID-8";
                            sourcePatientInfo.setPatientSex(s.substring(itemNo.length() + 1));
                        } else if (s.startsWith("PID-9")) {
                            itemNo = "PID-9";
                        }
                        ++j;
                    }
                    docEntry.setSourcePatientInfo(sourcePatientInfo);
                } else if (slotName.equals("URI")) {
                    Iterator iter = slot.getValueList().getValue().iterator();
                    HashMap<Integer, String> m = new HashMap<Integer, String>();
                    while (iter.hasNext()) {
                        String uriPiece = (String)iter.next();
                        StringTokenizer st = new StringTokenizer(uriPiece, "|");
                        if (st.countTokens() > 1) {
                            try {
                                int k = Integer.parseInt(st.nextToken().trim());
                                m.put(new Integer(k), st.nextToken());
                            }
                            catch (Exception e) {
                                logger.error((Object)"Mal-formatted URI. Slot content will not be included in extracted content.", (Throwable)e);
                            }
                            continue;
                        }
                        m.put(new Integer(1), st.nextToken());
                        break;
                    }
                    StringBuffer longURI = new StringBuffer();
                    int c = 0;
                    while (c < m.size()) {
                        longURI.append(m.get(new Integer(c + 1)));
                        ++c;
                    }
                    docEntry.setUri(longURI.toString());
                } else {
                    logger.warn((Object)("Unidentified Slot: " + slotName + ". Slot content is interpreted as 'extension metadata'."));
                    ExtensionType extension = MetadataFactory.eINSTANCE.createExtensionType();
                    extension.setName(slotName);
                    Iterator iter = slot.getValueList().getValue().iterator();
                    while (iter.hasNext()) {
                        extension.getValue().add(iter.next());
                    }
                }
            }
            ++i;
        }
    }

    private void extractExtrinsicObjectClassifications(DocumentEntryType docEntry) {
        EList eventCodes = docEntry.getEventCode();
        EList classifications = this.docData.getClassification();
        if (classifications == null) {
            return;
        }
        int i = 0;
        while (i < classifications.size()) {
            ClassificationType classification = (ClassificationType)classifications.get(i);
            if (classification != null) {
                if (classification.getClassificationScheme().equals("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d")) {
                    AuthorType author = MetadataFactory.eINSTANCE.createAuthorType();
                    int j = 0;
                    while (j < classification.getSlot().size()) {
                        SlotType1 slot = (SlotType1)classification.getSlot().get(j);
                        if (slot != null && slot.getName() != null && slot.getValueList() != null && slot.getValueList().getValue() != null && slot.getValueList().getValue().size() >= 1 && slot.getValueList().getValue().get(0) != null) {
                            String s;
                            String slotName = slot.getName();
                            if (slotName.equals("authorInstitution")) {
                                s = (String)slot.getValueList().getValue().get(0);
                                XON authorInstitution = HL7V2MessageFormat.buildXONFromMessageString((String)s, (char)'^', (char)'&');
                                author.getAuthorInstitution().add((Object)authorInstitution);
                            } else if (slotName.equals("authorPerson")) {
                                if (author.getAuthorPerson() != null) {
                                    logger.error((Object)"Duplicate Author.authorPerson. Will only use first full name in the extracted content.");
                                } else {
                                    s = (String)slot.getValueList().getValue().get(0);
                                    XCN authorPerson = HL7V2MessageFormat.buildXCNFromMessageString((String)s, (char)'^', (char)'&');
                                    author.setAuthorPerson(authorPerson);
                                }
                            } else if (slotName.equals("authorRole")) {
                                author.getAuthorRole().add((Object)((String)slot.getValueList().getValue().get(0)));
                            } else if (slotName.equals("authorSpecialty")) {
                                author.getAuthorSpeciality().add((Object)((String)slot.getValueList().getValue().get(0)));
                            }
                        }
                        ++j;
                    }
                    docEntry.setAuthor(author);
                } else {
                    String codeUUID;
                    SlotType1 cSlot;
                    CodedMetadataType code = MetadataFactory.eINSTANCE.createCodedMetadataType();
                    code.setCode(classification.getNodeRepresentation());
                    code.setDisplayName(EbXML_2_1DocumentEntryExtractor.copy(classification.getName()));
                    if (classification.getSlot() != null && classification.getSlot().size() > 0 && classification.getSlot().get(0) != null && (cSlot = (SlotType1)classification.getSlot().get(0)).getValueList() != null && cSlot.getValueList().getValue() != null && cSlot.getValueList().getValue().size() > 0) {
                        code.setSchemeName((String)cSlot.getValueList().getValue().get(0));
                    }
                    if ((codeUUID = classification.getClassificationScheme()) == null) {
                        logger.error((Object)("Required Classification/@classificationScheme attribute missing for following code: " + code.getCode() + ", " + code.getSchemeName() + ". Code will not be included in extracted content."));
                    }
                    if (codeUUID.equals("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a")) {
                        if (docEntry.getClassCode() != null) {
                            logger.error((Object)"Duplicate DocumentEntry.classCode. Will only use first code found in the extracted content.");
                        } else {
                            docEntry.setClassCode(code);
                        }
                    } else if (codeUUID.equals("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f")) {
                        docEntry.getConfidentialityCode().add((Object)code);
                    } else if (codeUUID.equals("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4")) {
                        eventCodes.add((Object)code);
                    } else if (codeUUID.equals("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d")) {
                        if (docEntry.getFormatCode() != null) {
                            logger.error((Object)"Duplicate DocumentEntry.formatCode. Will only use first code found in the extracted content.");
                        } else {
                            docEntry.setFormatCode(code);
                        }
                    } else if (codeUUID.equals("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1")) {
                        if (docEntry.getHealthCareFacilityTypeCode() != null) {
                            logger.error((Object)"Duplicate DocumentEntry.healthcareFacilityCode. Will only use first code found in the extracted content.");
                        } else {
                            docEntry.setHealthCareFacilityTypeCode(code);
                        }
                    } else if (codeUUID.equals("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead")) {
                        if (docEntry.getPracticeSettingCode() != null) {
                            logger.error((Object)"Duplicate DocumentEntry.practiceSettingCode. Will only use first code found in the extracted content.");
                        } else {
                            docEntry.setPracticeSettingCode(code);
                        }
                    } else if (codeUUID.equals("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983")) {
                        if (docEntry.getTypeCode() != null) {
                            logger.error((Object)"Duplicate DocumentEntry.typeCode. Will only use first code found in the extracted content.");
                        } else {
                            docEntry.setTypeCode(code);
                        }
                    } else {
                        logger.error((Object)("Unidentified Classification/@classificationScheme: " + codeUUID + ". " + code.getCode() + ", " + code.getSchemeName() + " will not be included in extracted content."));
                    }
                }
            }
            ++i;
        }
    }

    private void extractExtringsicObjectExternalIdentifiers(DocumentEntryType docEntry) {
        EList externalIdentifiers = this.docData.getExternalIdentifier();
        int i = 0;
        while (i < externalIdentifiers.size()) {
            ExternalIdentifierType exID = (ExternalIdentifierType)externalIdentifiers.get(i);
            if (exID != null) {
                String exUUID = exID.getIdentificationScheme();
                if (exUUID == null) {
                    logger.error((Object)("Required ExternalIdentifier/@identificationScheme attribute missing for following id: " + exID.getValue() + ". ID will not be included in extracted content."));
                }
                if (exUUID.equals("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427")) {
                    String s = exID.getValue();
                    CX patientId = HL7V2MessageFormat.buildCXFromMessageString((String)s, (char)'^', (char)'&');
                    docEntry.setPatientId(patientId);
                } else if (exUUID.equals("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab")) {
                    docEntry.setUniqueId(exID.getValue());
                } else {
                    logger.error((Object)("Unidentified ExternalIdentifier/@identificationScheme: " + exUUID + ". " + exID.getValue() + " will not be included in extracted content."));
                }
            }
            ++i;
        }
    }

    private static InternationalStringType copy(org.eclipse.ohf.ihe.common.ebxml._2._1.rim.InternationalStringType ist) {
        InternationalStringType result = MetadataFactory.eINSTANCE.createInternationalStringType();
        if (ist != null) {
            Iterator i = ist.getLocalizedString().iterator();
            while (i.hasNext()) {
                LocalizedStringType lst = MetadataFactory.eINSTANCE.createLocalizedStringType();
                org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LocalizedStringType original = (org.eclipse.ohf.ihe.common.ebxml._2._1.rim.LocalizedStringType)i.next();
                lst.setCharset(original.getCharset());
                lst.setLang(original.getLang());
                lst.setValue(original.getValue());
                result.getLocalizedString().add((Object)lst);
            }
        }
        return result;
    }
}

