/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.common.ebxml._3._0.lcm.SubmitObjectsRequestType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ExtrinsicObjectType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.IdentifiableType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RimFactory;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.FolderType;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.ParentDocumentRelationshipType;
import org.eclipse.ohf.ihe.xds.metadata.ProvideAndRegisterDocumentSetType;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0FolderExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0SubmissionSetExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.extract.ProvideAndRegisterDocumentSetExtractor;

public class EbXML_3_0ProvideAndRegisterDocumentSetExtractor
implements ProvideAndRegisterDocumentSetExtractor {
    public static final String DESCRIPTOR = "EBXML_3_0_PRDS_EXTR";
    private static final Logger logger;
    private SubmitObjectsRequestType transactionData;
    private ArrayList registryPackages;
    private ArrayList extrinsicObjects;
    private ArrayList classifications;
    private ArrayList associations;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0ProvideAndRegisterDocumentSetExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public EbXML_3_0ProvideAndRegisterDocumentSetExtractor(SubmitObjectsRequestType transactionData) {
        this.transactionData = transactionData;
    }

    public ProvideAndRegisterDocumentSetType extract() throws MetadataExtractionException {
        if (this.transactionData.getRegistryObjectList() == null) {
            logger.error((Object)"RegistryObjectList is null, cannot execute extraction.");
            throw new MetadataExtractionException("RegistryObjectList is null, cannot execute extraction.");
        }
        if (this.transactionData.getRegistryObjectList().getIdentifiable() == null) {
            logger.error((Object)"RegistryObjectList has no Identifiable sub-elements, cannot execute extraction.");
            throw new MetadataExtractionException("RegistryObjectList has no Identifiable sub-elements, cannot execute extraction.");
        }
        this.sortContent((List)this.transactionData.getRegistryObjectList().getIdentifiable());
        if (this.registryPackages == null) {
            logger.error((Object)"List of RegistryPackage is null, cannot execute extraction.");
            throw new MetadataExtractionException("List of RegistryPackage is null, cannot execute extraction.");
        }
        if (this.registryPackages.isEmpty()) {
            logger.error((Object)"List of RegistryPackage is empty, cannot execute extraction.");
            throw new MetadataExtractionException("List of RegistryPackage is empty, cannot execute extraction.");
        }
        if (this.classifications == null) {
            logger.error((Object)"List of Classification is null, cannot execute extraction.");
            throw new MetadataExtractionException("List of Classification is null, cannot execute extraction.");
        }
        if (this.classifications.isEmpty()) {
            logger.error((Object)"List of Classification is empty, cannot execute extraction.");
            throw new MetadataExtractionException("List of Classification is empty, cannot execute extraction.");
        }
        ProvideAndRegisterDocumentSetType docSet = MetadataFactory.eINSTANCE.createProvideAndRegisterDocumentSetType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting the Submission Set.");
        }
        this.extractSubmissionSet(docSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting the Document Entries.");
        }
        this.extractDocumentEntries(docSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting any Folders.");
        }
        this.extractFolders(docSet);
        return docSet;
    }

    private void sortContent(List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            IdentifiableType ident = (IdentifiableType)i.next();
            if (ident instanceof RegistryPackageType) {
                if (this.registryPackages == null) {
                    this.registryPackages = new ArrayList();
                }
                this.registryPackages.add(ident);
                continue;
            }
            if (ident instanceof ExtrinsicObjectType) {
                if (this.extrinsicObjects == null) {
                    this.extrinsicObjects = new ArrayList();
                }
                this.extrinsicObjects.add(ident);
                continue;
            }
            if (ident instanceof AssociationType1) {
                if (this.associations == null) {
                    this.associations = new ArrayList();
                }
                this.associations.add(ident);
                continue;
            }
            if (ident instanceof ClassificationType) {
                if (this.classifications == null) {
                    this.classifications = new ArrayList();
                }
                this.classifications.add(ident);
                continue;
            }
            logger.warn((Object)("SubmitObjectRequest contains unexpected element of type " + ident.getClass() + "."));
        }
    }

    private void extractSubmissionSet(ProvideAndRegisterDocumentSetType docSet) throws MetadataExtractionException {
        RegistryPackageType setData = this.findSubmissionSet();
        if (setData == null) {
            logger.fatal((Object)"Could not find SubmissionSet metadata in the SubmitObjectsRequest. Cannot procede with extraction.");
            throw new MetadataExtractionException("Could not find SubmissionSet metadata in the SubmitObjectsRequest. Cannot procede with extraction.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Begin finding present submission set associated documents and present associated folders.");
        }
        AssociationType1[] presentAssociations = this.findHasMemberAssociationsWithSource(setData.getId());
        Iterator i = this.classifications.iterator();
        ArrayList<String> folUUIDs = new ArrayList<String>();
        while (i.hasNext()) {
            ClassificationType c = (ClassificationType)i.next();
            if (!c.getClassificationNode().equals("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2")) continue;
            folUUIDs.add(c.getClassifiedObject());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number current folders found: " + folUUIDs.size()));
        }
        i = this.extrinsicObjects.iterator();
        ArrayList<String> docEntryUUIDs = new ArrayList<String>();
        while (i.hasNext()) {
            docEntryUUIDs.add(((ExtrinsicObjectType)i.next()).getId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number current documents found: " + docEntryUUIDs.size()));
        }
        ArrayList<AssociationType1> docs = new ArrayList<AssociationType1>();
        ArrayList<AssociationType1> folders = new ArrayList<AssociationType1>();
        int j = 0;
        while (j < presentAssociations.length) {
            boolean foundTarget = false;
            i = folUUIDs.iterator();
            while (i.hasNext()) {
                if (!((String)i.next()).equalsIgnoreCase(presentAssociations[j].getTargetObject())) continue;
                folders.add(presentAssociations[j]);
                foundTarget = true;
                break;
            }
            if (!foundTarget) {
                i = docEntryUUIDs.iterator();
                while (i.hasNext()) {
                    if (!((String)i.next()).equalsIgnoreCase(presentAssociations[j].getTargetObject())) continue;
                    docs.add(presentAssociations[j]);
                    foundTarget = true;
                    break;
                }
                if (foundTarget) {
                    // empty if block
                }
            }
            ++j;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Present (current) associations partitioned into " + docs.size() + " associated documents and " + folders.size() + " associated folders."));
        }
        ArrayList<AssociationType1> existingDocs = new ArrayList<AssociationType1>();
        ArrayList<AssociationType1> existingFolders = new ArrayList<AssociationType1>();
        AssociationType1[] list = this.findHasMemberAssociationsWithTarget(setData.getId());
        ArrayList<String> folderDocumentAssociationIds = new ArrayList<String>();
        int j2 = 0;
        while (j2 < list.length) {
            folderDocumentAssociationIds.add(list[j2].getSourceObject());
            ++j2;
        }
        i = this.associations.iterator();
        while (i.hasNext()) {
            AssociationType1 tempAssoc;
            AssociationType1 assoc = (AssociationType1)i.next();
            if (!folderDocumentAssociationIds.contains(assoc.getId())) continue;
            if (!docEntryUUIDs.contains(assoc.getTargetObject())) {
                DocumentEntryType de = MetadataFactory.eINSTANCE.createDocumentEntryType();
                de.setEntryUUID(assoc.getTargetObject());
                de.setExisting(true);
                docSet.getDocumentEntry().add((Object)de);
                tempAssoc = RimFactory.eINSTANCE.createAssociationType1();
                tempAssoc.setAssociationType("HasMember");
                tempAssoc.setSourceObject(setData.getId());
                tempAssoc.setTargetObject(assoc.getTargetObject());
                existingDocs.add(tempAssoc);
            }
            if (folUUIDs.contains(assoc.getSourceObject())) continue;
            FolderType folder = MetadataFactory.eINSTANCE.createFolderType();
            folder.setEntryUUID(assoc.getSourceObject());
            folder.setExisting(true);
            folder.getAssociatedDocuments().add((Object)assoc.getTargetObject());
            docSet.getFolder().add((Object)folder);
            tempAssoc = RimFactory.eINSTANCE.createAssociationType1();
            tempAssoc.setAssociationType("HasMember");
            tempAssoc.setSourceObject(setData.getId());
            tempAssoc.setTargetObject(assoc.getTargetObject());
            existingFolders.add(tempAssoc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + existingDocs.size() + " existing documents and " + existingFolders.size() + " existing folders."));
        }
        AssociationType1[] associatedDocs = new AssociationType1[docs.size() + existingDocs.size()];
        i = docs.iterator();
        int count = 0;
        while (i.hasNext()) {
            associatedDocs[count] = (AssociationType1)i.next();
            ++count;
        }
        i = existingDocs.iterator();
        while (i.hasNext()) {
            associatedDocs[count] = (AssociationType1)i.next();
            ++count;
        }
        AssociationType1[] associatedFols = new AssociationType1[folders.size() + existingFolders.size()];
        i = folders.iterator();
        count = 0;
        while (i.hasNext()) {
            associatedFols[count] = (AssociationType1)i.next();
            ++count;
        }
        i = existingFolders.iterator();
        while (i.hasNext()) {
            associatedFols[count] = (AssociationType1)i.next();
            ++count;
        }
        EbXML_3_0SubmissionSetExtractor ssExtractor = new EbXML_3_0SubmissionSetExtractor(setData, associatedDocs, associatedFols);
        docSet.setSubmissionSet(ssExtractor.extract());
    }

    private RegistryPackageType findSubmissionSet() throws MetadataExtractionException {
        Iterator i = this.classifications.iterator();
        String ssEntryUUID = null;
        while (i.hasNext()) {
            ClassificationType c = (ClassificationType)i.next();
            if (!c.getClassificationNode().equals("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd")) continue;
            ssEntryUUID = c.getClassifiedObject();
            break;
        }
        if (ssEntryUUID == null) {
            return null;
        }
        i = this.registryPackages.iterator();
        while (i.hasNext()) {
            RegistryPackageType reg = (RegistryPackageType)i.next();
            if (!reg.getId().equals(ssEntryUUID)) continue;
            return reg;
        }
        return null;
    }

    private void extractDocumentEntries(ProvideAndRegisterDocumentSetType docSet) throws MetadataExtractionException {
        if (this.extrinsicObjects == null) {
            logger.info((Object)"Metadata contains no ExtrinsicObjects");
        } else if (this.extrinsicObjects.isEmpty()) {
            logger.info((Object)"Metadata contains no ExtrinsicObjects");
        } else {
            Iterator i = this.extrinsicObjects.iterator();
            while (i.hasNext()) {
                ExtrinsicObjectType docData = (ExtrinsicObjectType)i.next();
                if (docData.getId() == null) {
                    logger.error((Object)"ExtrinsicObject found without the id attribute set. This data will not be included in the extraction.");
                    continue;
                }
                AssociationType1 parentData = this.findParent(docData.getId());
                EbXML_3_0DocumentEntryExtractor deExtractor = new EbXML_3_0DocumentEntryExtractor(docData, parentData);
                docSet.getDocumentEntry().add((Object)deExtractor.extract());
            }
        }
    }

    private AssociationType1 findParent(String documentEntryUUID) {
        Iterator i = this.associations.iterator();
        while (i.hasNext()) {
            String rel;
            AssociationType1 assoc = (AssociationType1)i.next();
            if (!assoc.getSourceObject().equals(documentEntryUUID) || !(rel = assoc.getAssociationType()).equals(ParentDocumentRelationshipType.APND_LITERAL.getName()) && !rel.equals(ParentDocumentRelationshipType.RPLC_LITERAL.getName()) && !rel.equals(ParentDocumentRelationshipType.XFRM_LITERAL.getName()) && !rel.equals(ParentDocumentRelationshipType.XFRMRPLC_LITERAL.getName())) continue;
            return assoc;
        }
        return null;
    }

    private void extractFolders(ProvideAndRegisterDocumentSetType docSet) throws MetadataExtractionException {
        if (this.registryPackages.size() <= 1) {
            logger.info((Object)"Metadata contains no Folders");
            return;
        }
        RegistryPackageType[] folders = this.findFolders();
        if (folders == null) {
            logger.info((Object)"Could not find folder metadata in the SubmitObjectsRequest.");
            return;
        }
        int i = 0;
        while (i < folders.length) {
            if (folders[i].getId() == null) {
                logger.error((Object)"Folder RegistryPackage found without the id attribute set. This data will not be included in the extraction.");
            } else {
                AssociationType1[] documentsInFolderI = this.findHasMemberAssociationsWithSource(folders[i].getId());
                EbXML_3_0FolderExtractor folExtractor = new EbXML_3_0FolderExtractor(folders[i], documentsInFolderI);
                docSet.getFolder().add((Object)folExtractor.extract());
            }
            ++i;
        }
    }

    private RegistryPackageType[] findFolders() throws MetadataExtractionException {
        Iterator i = this.classifications.iterator();
        ArrayList<String> folEntryUUIDs = new ArrayList<String>();
        while (i.hasNext()) {
            ClassificationType c = (ClassificationType)i.next();
            if (!c.getClassificationNode().equals("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2")) continue;
            folEntryUUIDs.add(c.getClassifiedObject());
        }
        if (folEntryUUIDs.isEmpty()) {
            return null;
        }
        i = this.registryPackages.iterator();
        ArrayList<RegistryPackageType> regs = new ArrayList<RegistryPackageType>();
        block1: while (i.hasNext()) {
            RegistryPackageType reg = (RegistryPackageType)i.next();
            Iterator j = folEntryUUIDs.iterator();
            while (j.hasNext()) {
                if (!reg.getId().equals((String)j.next())) continue;
                regs.add(reg);
                continue block1;
            }
        }
        if (regs.isEmpty()) {
            return null;
        }
        RegistryPackageType[] retVal = new RegistryPackageType[regs.size()];
        i = regs.iterator();
        int count = 0;
        while (i.hasNext()) {
            retVal[count] = (RegistryPackageType)i.next();
            ++count;
        }
        return retVal;
    }

    private AssociationType1[] findHasMemberAssociationsWithSource(String sourceObjectID) {
        Iterator i = this.associations.iterator();
        ArrayList<AssociationType1> assocs = new ArrayList<AssociationType1>();
        while (i.hasNext()) {
            AssociationType1 assoc = (AssociationType1)i.next();
            if (!assoc.getSourceObject().equals(sourceObjectID) || !assoc.getAssociationType().equals("HasMember")) continue;
            assocs.add(assoc);
        }
        if (assocs.isEmpty()) {
            return null;
        }
        AssociationType1[] retVal = new AssociationType1[assocs.size()];
        i = assocs.iterator();
        int count = 0;
        while (i.hasNext()) {
            retVal[count] = (AssociationType1)i.next();
            ++count;
        }
        return retVal;
    }

    private AssociationType1[] findHasMemberAssociationsWithTarget(String targetObjectID) {
        Iterator i = this.associations.iterator();
        ArrayList<AssociationType1> assocs = new ArrayList<AssociationType1>();
        while (i.hasNext()) {
            AssociationType1 assoc = (AssociationType1)i.next();
            if (!assoc.getSourceObject().equals(targetObjectID) || !assoc.getAssociationType().equals("HasMember")) continue;
            assocs.add(assoc);
        }
        if (assocs.isEmpty()) {
            return null;
        }
        AssociationType1[] retVal = new AssociationType1[assocs.size()];
        i = assocs.iterator();
        int count = 0;
        while (i.hasNext()) {
            retVal[count] = (AssociationType1)i.next();
            ++count;
        }
        return retVal;
    }
}

