/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.formats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.ohf.hl7v2.core.conformance.CPDocument;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPConformanceProfileStarterParser;
import org.eclipse.ohf.hl7v2.core.conformance.formats.CPDocumentParser;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.utilities.xml.XMLObjectParser;
import org.eclipse.ohf.utilities.xml.XMLReader;
import org.xml.sax.SAXException;

public class CPConformanceProfileXML {
    private InputStream stream;

    public CPConformanceProfileXML() {
    }

    public CPConformanceProfileXML(InputStream stream) {
        this.setStream(stream);
    }

    public CPConformanceProfileXML(String filename) throws HL7V2Exception {
        this.setFilename(filename);
    }

    private void setFilename(String filename) throws HL7V2Exception {
        try {
            this.setStream(new FileInputStream(new File(filename)));
        }
        catch (FileNotFoundException e) {
            throw new HL7V2Exception(e, 19);
        }
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public void parse(CPConformanceProfile profile) throws SAXException {
        new XMLReader((XMLObjectParser)new CPConformanceProfileStarterParser(profile)).parse(this.stream);
    }

    public CPConformanceProfile parse() throws SAXException {
        CPConformanceProfile result = new CPConformanceProfile();
        this.parse(result);
        return result;
    }

    public void parse(CPDocument model) throws HL7V2Exception {
        try {
            new XMLReader((XMLObjectParser)new CPDocumentParser(model)).parse(this.getStream());
        }
        catch (Exception e) {
            throw new HL7V2Exception(e, 22);
        }
    }
}

