/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.formats.embedded;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.ohf.hl7v2.core.definitions.formats.Loader;
import org.eclipse.ohf.hl7v2.core.definitions.formats.MSAccess;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventMessageDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;

public class EmbeddedLoaderGeneratorFromDefns {
    private static String GENERATE_PATH = "E:/Dev/org.eclipse.ohf.hl7v2.core/src/org/eclipse/ohf/hl7v2/core/definitions/formats/embedded/";
    private static String HEADER = "/*******************************************************************************\n* Copyright (c) 2000, 2005 Jiva Medical and others.\n* All rights reserved. This program and the accompanying materials\n* are made available under the terms of the Eclipse Public License v1.0\n* which accompanies this distribution, and is available at\n* http://www.eclipse.org/legal/epl-v10.html\n*\n* Contributors:\n*     Jiva Medical - initial API and implementation\n******************************************************************************/\npackage org.eclipse.ohf.hl7v2.core.definitions.formats.embedded;\n\nimport org.eclipse.ohf.hl7v2.core.definitions.model.*;\nimport org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;";
    private List defns = new ArrayList();
    private List tables = new ArrayList();
    private List comps = new ArrayList();
    private List dataElements = new ArrayList();
    private List segments = new ArrayList();
    private List dataTypes = new ArrayList();
    private List structs = new ArrayList();
    private List events = new ArrayList();
    private List msgTypes = new ArrayList();
    private List msgStructs = new ArrayList();
    private int tableCount;
    private int structCount;
    private int segmentCount;
    private int eventCount;
    private int msgStructCount;
    private PrintWriter writer = null;
    private VersionDefnList versionList;

    public static void main(String[] args) {
        try {
            MSAccess loader = new MSAccess("E:\\temp\\hl7_60.mdb");
            VersionDefnList versionList = ((Loader)loader).load();
            System.out.println("Load successfully");
            EmbeddedLoaderGeneratorFromDefns generator = new EmbeddedLoaderGeneratorFromDefns(versionList);
            generator.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static String escapeSqlString(String st) {
        if (st == null || st.equalsIgnoreCase("null")) {
            return null;
        }
        return "\"" + StringEscapeUtils.escapeJava((String)st) + "\"";
    }

    public EmbeddedLoaderGeneratorFromDefns(VersionDefnList versionList) {
        this.versionList = versionList;
    }

    private void initGenerator() throws IOException {
        this.defns.clear();
        this.tables.clear();
        this.comps.clear();
        this.dataElements.clear();
        this.segments.clear();
        this.dataTypes.clear();
        this.structs.clear();
        this.events.clear();
        this.msgTypes.clear();
        this.msgStructs.clear();
    }

    private void openWriter(String name) throws Exception {
        this.writer = new PrintWriter(new FileOutputStream(String.valueOf(GENERATE_PATH) + name + ".java"));
        this.writer.println(HEADER);
        this.writer.println("\npublic class " + name + " {");
        this.writer.println();
    }

    private void closeWriter() throws Exception {
        this.writer.println("}");
        this.writer.close();
    }

    public void generate() throws Exception {
        this.initGenerator();
        int i = 0;
        while (i < this.versionList.count()) {
            this.generateDefnInit(this.versionList.item(i));
            ++i;
        }
        this.openWriter("VersionDefnInit");
        this.generateDefnListInit();
        this.closeWriter();
    }

    private void generateDefnListInit() {
        this.writer.println("\n\tpublic static void init(VersionDefnList list) throws HL7V2Exception {");
        Iterator iter = this.defns.iterator();
        while (iter.hasNext()) {
            this.writer.println("\t\tlist.add(" + iter.next().toString() + "(list));");
        }
        this.writer.println("\t}");
    }

    private void generateDefnInit(VersionDefn defn) throws Exception {
        String version = VersionDefnList.display(defn.getVersion());
        String versionSt = version.replace('.', '_');
        String defnClassName = "VersionDefn" + versionSt;
        this.defns.add(String.valueOf(defnClassName) + ".initDefn");
        this.tableCount = 0;
        this.structCount = 0;
        this.segmentCount = 0;
        this.eventCount = 0;
        this.msgStructCount = 0;
        this.openWriter(defnClassName);
        this.writer.println("\tprivate static transient VersionDefn version;");
        this.writer.println("\tprivate static transient TableDefn table;");
        this.writer.println("\tprivate static transient StructureDefn struct;");
        this.writer.println("\tprivate static transient SegmentDefn segment;");
        this.writer.println("\tprivate static transient EventDefn event;");
        this.writer.println("\tprivate static transient MessageStructureDefn msgStruct;");
        this.writer.println();
        int i = 0;
        while (i < defn.getTables().size()) {
            this.tables.add(this.generateTableInits(defn.getTables().item(i), versionSt));
            ++i;
        }
        i = 0;
        while (i < defn.getDataTypes().size()) {
            this.dataTypes.add(this.generateDataTypeInits(defn.getDataTypes().item(i)));
            ++i;
        }
        i = 0;
        while (i < defn.getComponents().size()) {
            this.comps.add(this.generateComponentInits(defn.getComponents().item(i)));
            ++i;
        }
        i = 0;
        while (i < defn.getStructures().size()) {
            this.structs.add(this.generateStructInits(defn.getStructures().item(i), versionSt));
            ++i;
        }
        i = 0;
        while (i < defn.getDataElements().size()) {
            this.dataElements.add(this.generateDataElementInits(defn.getDataElements().item(i)));
            ++i;
        }
        i = 0;
        while (i < defn.getSegments().size()) {
            this.segments.add(this.generateSegmentInits(defn.getSegments().item(i), versionSt));
            ++i;
        }
        i = 0;
        while (i < defn.getMessageStructures().size()) {
            this.msgStructs.add(this.generateMsgStructInits(defn.getMessageStructures().item(i), versionSt));
            ++i;
        }
        i = 0;
        while (i < defn.getEvents().size()) {
            this.events.add(this.generateEventInits(defn.getEvents().item(i), versionSt));
            ++i;
        }
        i = 0;
        while (i < defn.getMessageTypes().size()) {
            this.msgTypes.add(this.generateMsgTypeInits(defn.getMessageTypes().item(i)));
            ++i;
        }
        ArrayList<Object> initBody = new ArrayList<Object>();
        initBody.add(this.generateCreateMethods("Tables", versionSt, this.tables));
        initBody.add(this.generateCreateMethods("DataTypes", versionSt, this.dataTypes));
        initBody.add(this.generateCreateMethods("Components", versionSt, this.comps));
        initBody.add(this.generateCreateMethods("Structs", versionSt, this.structs));
        initBody.add(this.generateCreateMethods("DataElements", versionSt, this.dataElements));
        initBody.add(this.generateCreateMethods("Segments", versionSt, this.segments));
        initBody.add(this.generateCreateMethods("MsgStructs", versionSt, this.msgStructs));
        initBody.add(this.generateCreateMethods("Events", versionSt, this.events));
        initBody.add(this.generateCreateMethods("MsgTypes", versionSt, this.msgTypes));
        this.writer.println("\n\tpublic static VersionDefn initDefn(VersionDefnList list) throws HL7V2Exception {");
        this.writer.println("\t\tversion = new VersionDefn(list);");
        this.writer.println("\t\tversion.setVersion(VersionDefnList.getVersion(\"" + version + "\"));\n");
        int i2 = 0;
        while (i2 < initBody.size()) {
            this.writer.println("\t\t" + initBody.get(i2) + ";");
            ++i2;
        }
        initBody.clear();
        this.writer.println("\t\tversion.crossLink();");
        this.writer.println("\t\treturn version;");
        this.writer.println("\t}");
        this.closeWriter();
    }

    private Object generateCreateMethods(String name, String version, List methodBody) {
        String methodName = "create" + name + "ForVersion" + version + "()";
        this.writer.println("\n\tpublic static void " + methodName + " throws HL7V2Exception {");
        int i = 0;
        while (i < methodBody.size()) {
            this.writer.println("\t\t" + methodBody.get(i) + ";");
            ++i;
        }
        methodBody.clear();
        this.writer.println("\t}\n");
        return methodName;
    }

    private String generateMsgTypeInits(MessageTypeDefn defn) {
        String name = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getName());
        String desc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDescription());
        return "EmbeddedLoaderUtil.createMessageType(version, " + name + ", " + desc + ");";
    }

    private String generateEventInits(EventDefn defn, String versionSt) {
        String name = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getName());
        String desc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDescription());
        String methodName = "createEvent" + this.eventCount + "_version_" + versionSt + "()";
        ++this.eventCount;
        this.writer.println("\n\t/* Event name=" + name + ", count = " + this.eventCount + " */");
        this.writer.println("\tpublic static void " + methodName + " throws HL7V2Exception {");
        this.writer.println("\t\tevent = EmbeddedLoaderUtil.createEvent(version, " + name + ", " + desc + ");");
        int i = 0;
        while (i < defn.getMessages().size()) {
            EventMessageDefn eMsgDefn = defn.getMessages().item(i);
            String msg = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(eMsgDefn.getMessage());
            String code = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(eMsgDefn.getStructureCode());
            String reply = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(eMsgDefn.getReply());
            String replyCode = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(eMsgDefn.getReplyStructureCode());
            this.writer.println("\t\tEmbeddedLoaderUtil.createEventMessage(version, event, " + msg + ", " + code + ", " + reply + ", " + replyCode + ");");
            ++i;
        }
        this.writer.println("\t}\n");
        return methodName;
    }

    private String generateMsgStructInits(MessageStructureDefn defn, String versionSt) {
        String name = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getName());
        String desc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDescription());
        String exEvents = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getExampleEvent());
        String exMsgType = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getExampleMessageType());
        String action = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getAction());
        String methodName = "createMsgStruct" + this.msgStructCount + "_version_" + versionSt + "()";
        ++this.msgStructCount;
        String body = "";
        SegmentGroupDefn segmentGroupDefn = defn.getMap();
        if (segmentGroupDefn != null) {
            String segName = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(segmentGroupDefn.getName());
            String segDesc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(segmentGroupDefn.getDescription());
            boolean isOpt = segmentGroupDefn.isOptional();
            boolean isRepeating = segmentGroupDefn.isRepeating();
            int groupType = segmentGroupDefn.getGroupType();
            body = String.valueOf(body) + "\t\tSegmentGroupDefn defn = EmbeddedLoaderUtil.createSegmentGroup(" + "version, " + segName + ", " + segDesc + ", " + isOpt + ", " + isRepeating + ", " + groupType + ");\n";
            if (segmentGroupDefn.getChildren().size() > 0) {
                body = String.valueOf(body) + "\t\t" + this.generateSegmentGroupChildrenInit("createSegmentGroupChildren_version" + versionSt + "MsgStruct" + this.msgStructCount + "_", 1, segmentGroupDefn.getChildren()) + "\n";
            }
            body = String.valueOf(body) + "\t\tmsgStruct.setMap(defn);\n";
        }
        this.writer.println("\n\t/* MessageStruct name=" + name + ", count = " + this.msgStructCount + " */");
        this.writer.println("\tpublic static void " + methodName + " throws HL7V2Exception {");
        this.writer.println("\t\tmsgStruct = EmbeddedLoaderUtil.createMessageStructure(version, " + name + ", " + desc + ", " + exEvents + ", " + exMsgType + ", " + action + ");");
        this.writer.print(body);
        this.writer.println("\t}\n");
        return methodName;
    }

    private String generateSegmentGroupChildrenInit(String prefix, int count, SegmentGroupDefnList defnList) {
        String methodName = String.valueOf(prefix) + "_" + count;
        ArrayList<String> methodBody = new ArrayList<String>();
        boolean moreChildren = false;
        int i = 0;
        while (i < defnList.size()) {
            SegmentGroupDefn childDefn = defnList.item(i);
            String segName = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(childDefn.getName());
            String segDesc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(childDefn.getDescription());
            boolean isOpt = childDefn.isOptional();
            boolean isRepeating = childDefn.isRepeating();
            int groupType = childDefn.getGroupType();
            if (childDefn.getChildren().size() > 0) {
                methodBody.add("\t\tdefn = EmbeddedLoaderUtil.createSegmentGroupChildren(version, parent, " + segName + ", " + segDesc + ", " + isOpt + ", " + isRepeating + ", " + groupType + ");\n");
                moreChildren = true;
                methodBody.add("\t\t" + this.generateSegmentGroupChildrenInit(methodName, i, childDefn.getChildren()) + "\n");
            } else {
                methodBody.add("\t\tEmbeddedLoaderUtil.createSegmentGroupChildren(version, parent, " + segName + ", " + segDesc + ", " + isOpt + ", " + isRepeating + ", " + groupType + ");\n");
            }
            ++i;
        }
        this.writer.println("\n\t/* SegmentGroup name=" + methodName + " */");
        this.writer.println("\tpublic static void " + methodName + "(SegmentGroupDefn parent) throws HL7V2Exception {");
        if (moreChildren) {
            this.writer.println("\t\tSegmentGroupDefn defn;");
        }
        i = 0;
        while (i < methodBody.size()) {
            this.writer.print(methodBody.get(i));
            ++i;
        }
        this.writer.println("\t}\n");
        return String.valueOf(methodName) + "(defn);";
    }

    private String generateSegmentInits(SegmentDefn defn, String versionSt) {
        String name = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getName());
        String desc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDescription());
        String segmentMethodName = "createSegment" + this.segmentCount + "_version_" + versionSt + "()";
        ++this.segmentCount;
        this.writer.println("\n\t/* Segment name=" + name + " */");
        this.writer.println("\tpublic static void " + segmentMethodName + " throws HL7V2Exception {");
        this.writer.println("\t\tsegment = EmbeddedLoaderUtil.createSegment(version, " + name + ", " + desc + ");");
        int i = 0;
        while (i < defn.getFields().size()) {
            FieldDefn fieldDefn = defn.getFields().item(i);
            int id = fieldDefn.getDataElementId();
            int repeatCount = fieldDefn.getRepeatCount();
            int no = fieldDefn.getNumber();
            boolean isRepeatable = fieldDefn.isRepeatable();
            boolean isRequired = fieldDefn.isRequired();
            this.writer.println("\t\tEmbeddedLoaderUtil.createSegmentField(version, segment, " + id + ", " + isRepeatable + ", " + repeatCount + ", " + isRequired + ", " + no + ");");
            ++i;
        }
        this.writer.println("\t}\n");
        return segmentMethodName;
    }

    private String generateDataElementInits(DataElementDefn defn) {
        String desc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDescription());
        String code = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getStructureCode());
        int id = defn.getId();
        int len = defn.getLength();
        int tableId = defn.getTableId();
        return "EmbeddedLoaderUtil.createDataElement(version, " + desc + ", " + code + ", " + id + ", " + len + ", " + tableId + ");";
    }

    private String generateStructInits(StructureDefn defn, String versionSt) {
        int structId = defn.getId();
        String name = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getName());
        String desc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDescription());
        String code = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDataTypeCode());
        String structMethodName = "createStruct" + this.structCount + "_version_" + versionSt + "()";
        ++this.structCount;
        this.writer.println("\n\t/* Struct id=" + structId + " */");
        this.writer.println("\tpublic static void " + structMethodName + " throws HL7V2Exception {");
        this.writer.println("\t\tstruct = EmbeddedLoaderUtil.createStruct(version, " + name + ", " + desc + ", " + code + ", " + structId + ");");
        int i = 0;
        while (i < defn.getComponents().size()) {
            ComponentDefn compDefn = defn.getComponents().item(i);
            int itemNo = compDefn.getNumber();
            this.writer.println("\t\tstruct.getComponents().add(version.getComponents().itemByNumber(" + itemNo + "));");
            ++i;
        }
        this.writer.println("\t}\n");
        return structMethodName;
    }

    private String generateComponentInits(ComponentDefn defn) {
        String name = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getName());
        String code = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDataTypeCode());
        int no = defn.getNumber();
        int tableId = defn.getTableId();
        return "EmbeddedLoaderUtil.createComponent(version, " + name + ", " + code + ", " + no + ", " + tableId + ");";
    }

    private String generateDataTypeInits(DataTypeDefn defn) {
        int len = defn.getLength();
        String name = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getName());
        String desc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDescription());
        return "EmbeddedLoaderUtil.createDataType(version, " + name + ", " + desc + ", " + len + ");";
    }

    private String generateTableInits(TableDefn defn, String version) {
        int tableId = defn.getId();
        String tableName = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getName());
        String tableDesc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(defn.getDescription());
        String tableMethodName = "createTable" + this.tableCount + "_version_" + version + "()";
        ++this.tableCount;
        this.writer.println("\n\t/* Table id=" + tableId + " */");
        this.writer.println("\tpublic static void " + tableMethodName + " throws HL7V2Exception {");
        this.writer.println("\t\ttable = EmbeddedLoaderUtil.createTableDefn(version, " + tableId + ", " + tableName + ", " + tableDesc + ");");
        int i = 0;
        while (i < defn.getItems().size()) {
            TableItemDefn itemDefn = defn.getItems().item(i);
            int itemId = itemDefn.getId();
            String itemName = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(itemDefn.getName());
            String itemDesc = EmbeddedLoaderGeneratorFromDefns.escapeSqlString(itemDefn.getDescription());
            this.writer.println("\t\tEmbeddedLoaderUtil.createTableItemDefn(version, table, " + itemId + ", " + itemName + ", " + itemDesc + ");");
            ++i;
        }
        this.writer.println("\t}\n");
        return tableMethodName;
    }
}

