/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.formats.embedded;

import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventMessageDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageTypeDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentGroupDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class EmbeddedLoaderUtil {
    public static TableDefn createTableDefn(VersionDefn version, int id, String name, String desc) throws HL7V2Exception {
        TableDefn result = new TableDefn(version);
        result.setId(id);
        result.setName(name);
        result.setDescription(desc);
        version.getTables().add(result);
        return result;
    }

    public static TableItemDefn createTableItemDefn(VersionDefn version, TableDefn table, int id, String name, String desc) throws HL7V2Exception {
        TableItemDefn result = new TableItemDefn(version);
        result.setId(id);
        result.setName(name);
        result.setDescription(desc);
        table.getItems().add(result);
        return result;
    }

    public static void createDataType(VersionDefn version, String name, String desc, int len) throws HL7V2Exception {
        DataTypeDefn result = new DataTypeDefn(version);
        result.setName(name);
        result.setDescription(desc);
        result.setLength(len);
        version.getDataTypes().add(result);
    }

    public static void createComponent(VersionDefn version, String name, String code, int no, int tableId) throws HL7V2Exception {
        ComponentDefn defn = new ComponentDefn(version);
        defn.setName(name);
        defn.setDataTypeCode(code);
        defn.setNumber(no);
        defn.setTableId(tableId);
        version.getComponents().add(defn);
    }

    public static StructureDefn createStruct(VersionDefn version, String name, String desc, String code, int id) throws HL7V2Exception {
        StructureDefn result = new StructureDefn(version);
        result.setName(name);
        result.setDescription(desc);
        result.setDataTypeCode(code);
        result.setId(id);
        version.getStructures().add(result);
        return result;
    }

    public static void createDataElement(VersionDefn version, String desc, String code, int id, int len, int tableId) throws HL7V2Exception {
        DataElementDefn defn = new DataElementDefn(version);
        defn.setDescription(desc);
        defn.setId(id);
        defn.setStructureCode(code);
        defn.setLength(len);
        defn.setTableId(tableId);
        version.getDataElements().add(defn);
    }

    public static SegmentDefn createSegment(VersionDefn version, String name, String desc) throws HL7V2Exception {
        SegmentDefn result = new SegmentDefn(version);
        result.setName(name);
        result.setDescription(desc);
        version.getSegments().add(result);
        return result;
    }

    public static void createSegmentField(VersionDefn version, SegmentDefn segment, int id, boolean isRepeatable, int repeatCount, boolean isRequired, int no) throws HL7V2Exception {
        FieldDefn defn = new FieldDefn(version);
        defn.setDataElementId(id);
        defn.setRepeatable(isRepeatable);
        defn.setRepeatCount(repeatCount);
        defn.setRequired(isRequired);
        defn.setNumber(no);
        segment.getFields().add(defn);
    }

    public static MessageStructureDefn createMessageStructure(VersionDefn version, String name, String desc, String exEvents, String exMsg, String action) throws HL7V2Exception {
        MessageStructureDefn result = new MessageStructureDefn(version);
        result.setName(name);
        result.setDescription(desc);
        result.setExampleEvent(exEvents);
        result.setExampleMessageType(exMsg);
        result.setAction(action);
        version.getMessageStructures().add(result);
        return result;
    }

    public static SegmentGroupDefn createSegmentGroup(VersionDefn version, String name, String desc, boolean isOptional, boolean isRepeating, int groupType) throws HL7V2Exception {
        SegmentGroupDefn result = new SegmentGroupDefn(version);
        result.setName(name);
        result.setDescription(desc);
        result.setOptional(isOptional);
        result.setRepeating(isRepeating);
        result.setGroupType(groupType);
        return result;
    }

    public static SegmentGroupDefn createSegmentGroupChildren(VersionDefn version, SegmentGroupDefn parent, String name, String desc, boolean isOptional, boolean isRepeating, int groupType) throws HL7V2Exception {
        SegmentGroupDefn result = EmbeddedLoaderUtil.createSegmentGroup(version, name, desc, isOptional, isRepeating, groupType);
        parent.getChildren().add(result);
        return result;
    }

    public static EventDefn createEvent(VersionDefn version, String name, String desc) throws HL7V2Exception {
        EventDefn result = new EventDefn(version);
        result.setName(name);
        result.setDescription(desc);
        version.getEvents().add(result);
        return result;
    }

    public static void createEventMessage(VersionDefn version, EventDefn event, String msg, String code, String reply, String replyCode) throws HL7V2Exception {
        EventMessageDefn defn = new EventMessageDefn(version);
        defn.setMessage(msg);
        defn.setStructureCode(code);
        defn.setReply(reply);
        defn.setReplyStructureCode(replyCode);
        event.getMessages().add(defn);
    }

    public static void createMessageType(VersionDefn version, String name, String desc) throws HL7V2Exception {
        MessageTypeDefn defn = new MessageTypeDefn(version);
        defn.setName(name);
        defn.setDescription(desc);
        version.getMessageTypes().add(defn);
    }
}

