/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.definitions.model;

import java.io.Serializable;
import org.eclipse.ohf.hl7v2.core.definitions.model.BaseDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataElementDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.DataTypeDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.EventMessageDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageTypeDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.StructureDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefnList;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class VersionDefn
implements Serializable {
    private static final long serialVersionUID = 3571103647223720425L;
    private VersionDefnList context;
    private int version;
    private TableDefnList tables = new TableDefnList();
    private ComponentDefnList components = new ComponentDefnList();
    private DataElementDefnList dataElements = new DataElementDefnList();
    private SegmentDefnList segments = new SegmentDefnList();
    private DataTypeDefnList dataTypes = new DataTypeDefnList();
    private StructureDefnList structures = new StructureDefnList();
    private EventDefnList events = new EventDefnList();
    private MessageTypeDefnList MessageTypes = new MessageTypeDefnList();
    private MessageStructureDefnList messageStructures = new MessageStructureDefnList();

    public VersionDefn(VersionDefnList context) {
        this.context = context;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public ComponentDefnList getComponents() {
        return this.components;
    }

    public DataElementDefnList getDataElements() {
        return this.dataElements;
    }

    public DataTypeDefnList getDataTypes() {
        return this.dataTypes;
    }

    public EventDefnList getEvents() {
        return this.events;
    }

    public MessageTypeDefnList getMessageTypes() {
        return this.MessageTypes;
    }

    public MessageStructureDefnList getMessageStructures() {
        return this.messageStructures;
    }

    public SegmentDefnList getSegments() {
        return this.segments;
    }

    public StructureDefnList getStructures() {
        return this.structures;
    }

    public TableDefnList getTables() {
        return this.tables;
    }

    public void crossLink() {
        int j;
        int i = 0;
        while (i < this.getComponents().size()) {
            ComponentDefn component = this.getComponents().item(i);
            if (component.getTableId() != 0) {
                component.setTable(this.getTables().itemById(component.getTableId()));
            }
            component.setDatatype(this.getDataTypes().itemByName(component.getDataTypeCode()));
            component.setStructure(this.getStructures().itemByName(component.getDataTypeCode()));
            ++i;
        }
        i = 0;
        while (i < this.getDataElements().size()) {
            DataElementDefn dataElement = this.getDataElements().item(i);
            if (dataElement.getTableId() != 0) {
                dataElement.setTable(this.getTables().itemById(dataElement.getTableId()));
            }
            dataElement.setStructure(this.getStructures().itemByName(dataElement.getStructureCode()));
            ++i;
        }
        i = 0;
        while (i < this.getSegments().size()) {
            SegmentDefn segment = this.getSegments().item(i);
            j = 0;
            while (j < segment.getFields().size()) {
                FieldDefn field = segment.getFields().item(j);
                field.setDataElement(this.getDataElements().itemById(field.getDataElementId()));
                field.setSegment(segment);
                field.setIndex(j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.getStructures().size()) {
            StructureDefn structure = this.getStructures().item(i);
            structure.setDataType(this.getDataTypes().itemByName(structure.getDataTypeCode()));
            ++i;
        }
        i = 0;
        while (i < this.getEvents().size()) {
            EventDefn event = this.getEvents().item(i);
            j = 0;
            while (j < event.getMessages().size()) {
                EventMessageDefn message = event.getMessages().item(j);
                message.setStructure(this.getMessageStructures().itemByName(message.getStructureCode()));
                message.setReplyStructure(this.getMessageStructures().itemByName(message.getReplyStructureCode()));
                ++j;
            }
            ++i;
        }
    }

    public String getPath() {
        return String.valueOf(this.context.getName()) + "-" + VersionDefnList.display(this.version);
    }

    public BaseDefn getByPath(String type, String name) throws HL7V2Exception {
        BaseDefn result;
        if (type.equals("cmp")) {
            result = this.getComponents().itemByName(name);
        } else if (type.equals("de")) {
            result = this.getDataElements().itemById(name);
        } else if (type.equals("dt")) {
            result = this.getDataTypes().itemByName(name);
        } else if (type.equals("ev")) {
            result = this.getEvents().itemByName(name);
        } else if (type.equals("msgtype")) {
            result = this.getMessageTypes().itemByName(name);
        } else if (type.equals("msg")) {
            result = this.getMessageStructures().itemByName(name);
        } else if (type.equals("seg")) {
            result = this.getSegments().itemByName(name);
        } else if (type.equals("strc")) {
            result = this.getStructures().itemByName(name);
        } else if (type.equals("tbl")) {
            result = this.getTables().itemById(name);
        } else {
            throw new HL7V2Exception("unrecognised definition type " + type, 19);
        }
        if (result == null) {
            throw new HL7V2Exception("unable to find item " + type + "/" + name, 19);
        }
        return result;
    }
}

