/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.validators;

import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;
import org.eclipse.ohf.hl7v2.core.validators.CPValidator;
import org.eclipse.ohf.hl7v2.core.validators.ValidationItemList;
import org.eclipse.ohf.hl7v2.core.validators.Validator;
import org.eclipse.ohf.hl7v2.core.validators.ValidatorList;

public class ValidationManager
extends Worker {
    public static final int VALIDATOR_CONFORMANCE = 1;
    private ValidatorList validators = new ValidatorList();
    private static ValidationManager globalFactory;

    public static ValidationManager getFactory() {
        if (globalFactory == null) {
            globalFactory = new ValidationManager();
        }
        return globalFactory;
    }

    public Validator createValidator(int type) throws HL7V2Exception {
        switch (type) {
            case 1: {
                return new CPValidator();
            }
        }
        throw new HL7V2Exception("Invalid Validator Type " + Integer.toString(type), 19);
    }

    public void registerValidator(Validator val) {
        this.validators.add(val);
    }

    public void validate(Message message, ValidationItemList items) throws HL7V2Exception {
        items.clear();
        int i = 0;
        while (i < this.validators.size()) {
            this.validators.item(i).setItems(items);
            this.validators.item(i).validate(message);
            ++i;
        }
    }
}

