/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.ebxml._2._1.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ohf.ihe.common.ebxml._2._1.query.GetContentResponseType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryErrorListType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryErrorType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryFactory;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryResponseType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.util.RegistryResourceFactoryImpl;

public class SubmitResponse {
    public static void main(String[] args) throws Exception {
        System.out.println("START TEST *******************************");
        System.out.println("reading *" + args[0] + "*");
        System.out.println("begin loading.");
        Resource resources = new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
        File file = new File(args[0]);
        byte[] input = new byte[(int)file.length()];
        new FileInputStream(file).read(input);
        if (args.length > 2 && args[2] != null && args[2].equalsIgnoreCase("ignore")) {
            System.out.println("Ignore feature on.");
            XMLResource xResource = (XMLResource)resources;
            xResource.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        resources.load((InputStream)new ByteArrayInputStream(input), null);
        EList list = resources.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        System.out.println("Registry Response:");
        RegistryResponseType resp = root.getRegistryResponse();
        if (resp.getStatus() != null) {
            System.out.println("Status = " + resp.getStatus().getName());
        }
        if (resp.getRegistryErrorList() != null) {
            System.out.println("\nError List: ");
            RegistryErrorListType eList = resp.getRegistryErrorList();
            if (eList.getHighestSeverity() != null) {
                System.out.println("Highest Severity = " + eList.getHighestSeverity().getName());
            }
            if (eList.getRegistryError() != null) {
                Iterator i = eList.getRegistryError().iterator();
                while (i.hasNext()) {
                    RegistryErrorType e = (RegistryErrorType)i.next();
                    System.out.println("\nRegistryError: ");
                    System.out.println("code context = " + e.getCodeContext());
                    System.out.println("error code = " + e.getErrorCode());
                    System.out.println("location = " + e.getLocation());
                    System.out.println("value = " + e.getValue());
                    System.out.println("severity = " + (Object)((Object)e.getSeverity()));
                }
            }
        } else if (resp.getGetContentResponse() != null) {
            GetContentResponseType cont = resp.getGetContentResponse();
            System.out.println("\nContent Response:");
            System.out.println(cont.toString());
        }
        System.out.println("\nDONE PRINT\n");
        System.out.println("Begin printing Submit Request back to file.");
        root = RegistryFactory.eINSTANCE.createDocumentRoot();
        root.setRegistryResponse(resp);
        Resource resources3 = new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
        resources3.getContents().add((Object)root);
        System.out.println("writing *" + args[1] + "*");
        resources3.save((OutputStream)new FileOutputStream(args[1]), null);
        System.out.println("Done saving Submit request to file.");
        resources3.unload();
        System.out.println("Unload resources.");
        System.out.println("DONE TEST *******************************");
    }
}

