/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.soap;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.util.XMLUtils;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.common.ws.OHFSOAPAttachmentSender;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapClient;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapClientException;
import org.w3c.dom.Element;

public abstract class AbstractXDSSoapClient
implements XDSSoapClient {
    private static final Logger logger;
    private OHFSOAPAttachmentSender sender;
    private String serializedRequestBody;
    private String serializedResponseBody;
    private List responseAttachments;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.soap.AbstractXDSSoapClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public AbstractXDSSoapClient(OHFSOAPAttachmentSender sender) {
        this.sender = sender;
    }

    protected abstract Map buildRequestAttachments(OMElement var1, List var2) throws Exception;

    protected abstract OMElement buildResponseAttachments(OMElement var1, boolean var2) throws Exception;

    public abstract List getAttachments() throws Exception;

    protected List getResponseAttachments() {
        return this.responseAttachments;
    }

    public Element send(Element request, List attachments, URI uri) throws Exception {
        return this.send(request, attachments, uri, null);
    }

    public Element send(Element request, List attachments, URI uri, String action) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Beginning XDS SOAP Send");
        }
        OMElement bodyOMElement = XMLUtils.toOM((Element)request);
        Map attachmentMap = this.buildRequestAttachments(bodyOMElement, attachments);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bodyOMElement.serialize((OutputStream)baos);
        this.serializedRequestBody = baos.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"****** SOAP REQUEST BODY ******");
            logger.debug((Object)this.serializedRequestBody);
            logger.debug((Object)"********************************");
        }
        SOAPEnvelope requestEnvelope = this.sender.createEnvelope();
        SOAPBody requestBody = requestEnvelope.getBody();
        requestBody.addChild((OMNode)bodyOMElement);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SOAP Envelope Set");
        }
        this.sender.setEndpoint(uri);
        SOAPEnvelope responseEnvelope = this.sender.send(requestEnvelope, attachmentMap, action);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Received SOAP Response");
        }
        if (responseEnvelope == null) {
            logger.error((Object)"NULL SOAP ENVELOPE");
            throw new XDSSoapClientException("NULL SOAP ENVELOPE");
        }
        SOAPBody responseBody = responseEnvelope.getBody();
        if (responseBody == null) {
            logger.error((Object)"NULL SOAP BODY");
            throw new XDSSoapClientException("NULL SOAP BODY");
        }
        OMElement responseOMElement = responseEnvelope.getBody().getFirstElement();
        if (responseOMElement == null) {
            logger.error((Object)"NO PAYLOAD WITHIN SOAP BODY. EMPTY RESPONSE.");
            throw new XDSSoapClientException("NO PAYLOAD WITHIN SOAP BODY. EMPTY RESPONSE.");
        }
        baos = new ByteArrayOutputStream();
        responseOMElement.serialize((OutputStream)baos);
        this.serializedResponseBody = baos.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"****** SOAP RESPONSE BODY ******");
            logger.debug((Object)this.serializedResponseBody);
            logger.debug((Object)"********************************");
        }
        if (responseBody.hasFault()) {
            SOAPFault fault = responseBody.getFault();
            logger.error((Object)("Fault Message:\n" + this.serializedResponseBody), (Throwable)fault.getException());
            throw new XDSSoapClientException("SOAP FAULT", fault.getException());
        }
        responseOMElement = this.buildResponseAttachments(responseOMElement, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Ending XDS SOAP Processing");
        }
        return XMLUtils.toDOM((OMElement)responseOMElement);
    }

    protected void setResponseAttachments(List responseAttachments) {
        this.responseAttachments = responseAttachments;
    }
}

