/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.DefaultDOMHandlerImpl;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClient;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientImpl;
import org.eclipse.ohf.ihe.common.ebxml._2._1.query.AdhocQueryResponseType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.RegistryObjectListType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.RegistryResponseType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rs.util.RegistryResourceFactoryImpl;
import org.eclipse.ohf.ihe.common.ebxml._3._0.query.AdhocQueryRequestType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.query.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._3._0.query.QueryFactory;
import org.eclipse.ohf.ihe.common.ebxml._3._0.query.ResponseOptionType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.query.ReturnTypeType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.query.util.QueryResourceFactoryImpl;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AdhocQueryType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ExtrinsicObjectType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ObjectRefType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RimFactory;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.SlotType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ValueListType;
import org.eclipse.ohf.ihe.xds.XDSResponseParser;
import org.eclipse.ohf.ihe.xds.XDSUtils;
import org.eclipse.ohf.ihe.xds.consumer.ConsumerException;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQuery;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.response.DocumentEntryResponseType;
import org.eclipse.ohf.ihe.xds.response.ResponseFactory;
import org.eclipse.ohf.ihe.xds.response.XDSQueryResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractConsumer {
    private static Logger logger;
    protected java.net.URI regURI;
    protected ATNAAuditClient auditor = new ATNAAuditClientImpl();
    private String ACTOR_NAME = "OHF_ABSTRACT_XDS_CONSUMER";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.consumer.AbstractConsumer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public AbstractConsumer(java.net.URI regURI) {
        this.regURI = regURI;
    }

    public boolean isDoAudit() {
        return AtnaAgentFactory.getAtnaAgent().isDoAudit();
    }

    public String getRegURL() {
        return this.regURI.toString();
    }

    public void setRegURL(String regURL) {
        try {
            this.regURI = new java.net.URI(regURL);
        }
        catch (URISyntaxException e) {
            logger.fatal((Object)("CONSUMER URI CANNOT BE SET: \n" + e.getMessage()));
        }
    }

    public java.net.URI getRegURI() {
        return this.regURI;
    }

    public void setRegURI(java.net.URI regURI) {
        this.regURI = regURI;
    }

    public abstract XDSQueryResponseType invokeStoredQuery(StoredQuery var1, boolean var2) throws Exception;

    protected Element formEbXMLStoredQuery(StoredQuery q, boolean returnReferencesOnly) throws Exception {
        if (this.isDoAudit()) {
            this.auditor.auditActorStartEvent(0, this.ACTOR_NAME);
        }
        if (q == null) {
            logger.fatal((Object)"NULL QUERY");
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            }
            throw new ConsumerException("NULL QUERY");
        }
        ReturnTypeType returnType = null;
        returnType = returnReferencesOnly ? ReturnTypeType.OBJECT_REF_LITERAL : ReturnTypeType.LEAF_CLASS_LITERAL;
        Element ebXMLQuery = null;
        try {
            ebXMLQuery = this.formatEBXML_3_0QueryString(q, returnType);
        }
        catch (IOException e) {
            logger.fatal((Object)"Could not format ebXML for the query string.", (Throwable)e);
            if (this.isDoAudit()) {
                this.auditor.auditActorStopEvent(0, this.ACTOR_NAME);
            }
            throw e;
        }
        return ebXMLQuery;
    }

    private Element formatEBXML_3_0QueryString(StoredQuery query, ReturnTypeType returnType) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"creating the ebXML for the query");
        }
        AdhocQueryRequestType adhqr = QueryFactory.eINSTANCE.createAdhocQueryRequestType();
        ResponseOptionType respType = QueryFactory.eINSTANCE.createResponseOptionType();
        respType.setReturnComposedObjects(true);
        respType.setReturnType(returnType);
        adhqr.setResponseOption(respType);
        AdhocQueryType adhq = RimFactory.eINSTANCE.createAdhocQueryType();
        adhqr.setAdhocQuery(adhq);
        adhq.setId(query.getQueryUUID());
        if (query.getHomeCommunityId() != null && query.getHomeCommunityId().length() > 0) {
            adhq.setHome(query.getHomeCommunityId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setting query parameters in the ebXML");
        }
        Iterator i = query.getQueryParameters().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry queryParameter = i.next();
            SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
            ValueListType vList = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(vList);
            slot.setName((String)queryParameter.getKey());
            slot.getValueList().getValue().add((Object)((String)queryParameter.getValue()));
            adhq.getSlot().add((Object)slot);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"serializing the ebXML for the to a string");
        }
        DocumentRoot root = QueryFactory.eINSTANCE.createDocumentRoot();
        root.setAdhocQueryRequest(adhqr);
        XMLResource resource = (XMLResource)new QueryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:xsd:query:3.0"));
        resource.getContents().add((Object)root);
        Document domDocument = XDSUtils.createDomDocument();
        resource.save(domDocument, new HashMap(), (DOMHandler)new DefaultDOMHandlerImpl());
        resource.unload();
        return domDocument.getDocumentElement();
    }

    protected void processEbXML_2_1QueryResults(Element results, XDSQueryResponseType xdsResponse) throws IOException, ConsumerException, MetadataExtractionException {
        RegistryObjectListType rolist;
        EList list;
        org.eclipse.ohf.ihe.common.ebxml._2._1.rs.DocumentRoot root;
        XMLResource resources = (XMLResource)new RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:registry:xsd:2.1"));
        if (XDSResponseParser.getHackMetadataFlag() && resources instanceof XMLResource) {
            XMLResource xResource = resources;
            xResource.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        try {
            resources.load((Node)results, null);
        }
        catch (IOException e) {
            String error = new String("");
            logger.fatal((Object)("Registry response is not ebXML v2.1. Response is: " + error));
            throw new ConsumerException("Registry Response is not ebXML v2.1. Response is: " + error, e);
        }
        EList elist = resources.getContents();
        Object ob = elist.get(0);
        AdhocQueryResponseType rc = null;
        if (ob instanceof org.eclipse.ohf.ihe.common.ebxml._2._1.rs.DocumentRoot) {
            root = (org.eclipse.ohf.ihe.common.ebxml._2._1.rs.DocumentRoot)elist.get(0);
            RegistryResponseType response = root.getRegistryResponse();
            rc = response.getAdhocQueryResponse();
        } else if (ob instanceof org.eclipse.ohf.ihe.common.ebxml._2._1.query.DocumentRoot) {
            root = (org.eclipse.ohf.ihe.common.ebxml._2._1.query.DocumentRoot)ob;
            rc = root.getAdhocQueryResponse();
        } else {
            resources.unload();
            logger.fatal((Object)("Unexpected class found as document root " + ob.getClass().getName()));
            throw new ConsumerException("Unexpected class found as document root " + ob.getClass().getName());
        }
        resources.unload();
        if (rc == null) {
            logger.error((Object)"AdhocQueryResponse is null: Success response with no data.");
            throw new ConsumerException("AdhocQueryResponse is null: Success response with no data.");
        }
        if (rc.getSQLQueryResult() == null) {
            logger.error((Object)"AdhocQueryResponse.SQLQueryResult is null: Success response with no data.");
            throw new ConsumerException("AdhocQueryResponse.SQLQueryResult is null: Success response with no data.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Found ebXML v2.1 AdhocQueryResponse element.");
        }
        if ((list = (rolist = rc.getSQLQueryResult()).getExtrinsicObject()).size() > 0) {
            logger.info((Object)("Found " + list.size() + " extrinsic objects"));
            int i = 0;
            while (i < list.size()) {
                Object o = list.get(i);
                if (o instanceof org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExtrinsicObjectType) {
                    EbXML_2_1DocumentEntryExtractor deExtractor = new EbXML_2_1DocumentEntryExtractor((org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExtrinsicObjectType)o, null);
                    DocumentEntryResponseType deResponse = ResponseFactory.eINSTANCE.createDocumentEntryResponseType();
                    deResponse.setDocumentEntry(deExtractor.extract());
                    xdsResponse.getDocumentEntryResponses().add((Object)deResponse);
                }
                ++i;
            }
        } else {
            list = rolist.getObjectRef();
            if (list.size() > 0) {
                logger.info((Object)("Found " + list.size() + " object references"));
                int i = 0;
                while (i < list.size()) {
                    Object o = list.get(i);
                    if (o instanceof org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ObjectRefType) {
                        org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ObjectRefType originalRef = (org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ObjectRefType)o;
                        ObjectRefType objRef = RimFactory.eINSTANCE.createObjectRefType();
                        objRef.setId(originalRef.getId());
                        xdsResponse.getReferences().add((Object)objRef);
                    }
                    ++i;
                }
            } else if (rolist.getAssociation().size() > 0 || rolist.getAuditableEvent().size() > 0 || rolist.getClassification().size() > 0 || rolist.getClassificationNode().size() > 0 || rolist.getClassificationScheme().size() > 0 || rolist.getExternalIdentifier().size() > 0 || rolist.getExternalLink().size() > 0 || rolist.getOrganization().size() > 0 || rolist.getRegistryEntry().size() > 0 || rolist.getRegistryObject().size() > 0) {
                logger.error((Object)("Unexpected return data. Registry must return list of either ExtrinsicObjects or ObjectRefs; neither was encountered.\n\n Returned data is as follows" + rolist.toString()));
            } else {
                logger.info((Object)"NO DOCUMENTS FOUND");
            }
        }
    }

    protected void processEbXML_3_0QueryResults(Element results, XDSQueryResponseType xdsResponse) throws IOException, ConsumerException, MetadataExtractionException {
        XMLResource resources = (XMLResource)new org.eclipse.ohf.ihe.common.ebxml._3._0.rs.util.RegistryResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:xsd:rs:3.0"));
        if (XDSResponseParser.getHackMetadataFlag() && resources instanceof XMLResource) {
            XMLResource xResource = resources;
            xResource.getDefaultLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        try {
            resources.load((Node)results, null);
        }
        catch (IOException e) {
            String error = new String("");
            logger.fatal((Object)("Registry response is not ebXML v3.0. Response is: " + error));
            throw new ConsumerException("Registry Response is not ebXML v3.0. Response is: " + error, e);
        }
        EList list = resources.getContents();
        Object ob = list.get(0);
        org.eclipse.ohf.ihe.common.ebxml._3._0.query.AdhocQueryResponseType rc = null;
        if (!(ob instanceof DocumentRoot)) {
            resources.unload();
            logger.fatal((Object)("Unexpected class found as document root " + ob.getClass().getName()));
            throw new ConsumerException("Unexpected class found as document root " + ob.getClass().getName());
        }
        DocumentRoot root = (DocumentRoot)ob;
        rc = root.getAdhocQueryResponse();
        resources.unload();
        if (rc == null) {
            logger.error((Object)"AdhocQueryResponse is null: Success response with no data.");
            throw new ConsumerException("AdhocQueryResponse is null: Success response with no data.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Found ebXML v3.0 AdhocQueryResponse element.");
        }
        if (rc.getRegistryObjectList() == null) {
            logger.info((Object)"AdhocQueryResponse.RegistryObjectList is null: Success response with no data.");
            return;
        }
        if (rc.getRegistryObjectList().getIdentifiable() == null) {
            logger.info((Object)"AdhocQueryResponse.RegistryObjectList.Identifiable is null: Success response with no data.");
            return;
        }
        if (rc.getRegistryObjectList().getIdentifiable().isEmpty()) {
            logger.info((Object)"AdhocQueryResponse.RegistryObjectList.Identifiable is empty: Success response with no data.");
            return;
        }
        EList idlist = rc.getRegistryObjectList().getIdentifiable();
        ArrayList extObjs = new ArrayList();
        ArrayList objRefs = new ArrayList();
        ArrayList associations = new ArrayList();
        Iterator i = idlist.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ExtrinsicObjectType) {
                extObjs.add(o);
                continue;
            }
            if (o instanceof ObjectRefType) {
                objRefs.add(o);
                continue;
            }
            if (!(o instanceof AssociationType1)) continue;
            associations.add(o);
        }
        boolean found = false;
        if (extObjs.size() > 0) {
            logger.info((Object)("Found " + extObjs.size() + " extrinsic objects"));
            i = extObjs.iterator();
            while (i.hasNext()) {
                ExtrinsicObjectType exObj = (ExtrinsicObjectType)i.next();
                EbXML_3_0DocumentEntryExtractor deExtractor = new EbXML_3_0DocumentEntryExtractor(exObj, null);
                DocumentEntryResponseType deResponse = ResponseFactory.eINSTANCE.createDocumentEntryResponseType();
                deResponse.setDocumentEntry(deExtractor.extract());
                deResponse.setHomeCommunityId(exObj.getHome());
                xdsResponse.getDocumentEntryResponses().add((Object)deResponse);
            }
            found = true;
        }
        if (objRefs.size() > 0) {
            logger.info((Object)("Found " + objRefs.size() + " object references"));
            i = objRefs.iterator();
            while (i.hasNext()) {
                xdsResponse.getReferences().add((Object)((ObjectRefType)i.next()));
            }
            found = true;
        }
        if (associations.size() > 0) {
            i = associations.iterator();
            while (i.hasNext()) {
                xdsResponse.getAssociations().add((Object)((AssociationType1)i.next()));
            }
            found = true;
        }
        if (!found) {
            logger.info((Object)"NO QUERY RESULTS FOUND");
        }
    }
}

