/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.storedquery;

import org.eclipse.ohf.ihe.xds.consumer.storedquery.MalformedStoredQueryException;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQuery;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQueryBuilderUtils;
import org.eclipse.ohf.ihe.xds.metadata.ParentDocumentRelationshipType;

public class GetRelatedDocumentsQuery
extends StoredQuery {
    public GetRelatedDocumentsQuery(String docID, boolean isUUID, ParentDocumentRelationshipType[] relationshipTypes) throws MalformedStoredQueryException {
        super("urn:uuid:d90e5407-b356-4d91-a89f-873917b4b0e6");
        if (docID == null) {
            throw new MalformedStoredQueryException("Null document ID. Cannot proceed with query.");
        }
        if (docID.length() == 0) {
            throw new MalformedStoredQueryException("No document ID. Cannot proceed with query.");
        }
        String clause = String.valueOf('\'') + docID + '\'';
        if (isUUID) {
            this.queryParameters.put("$XDSDocumentEntryEntryUUID", clause);
        } else {
            this.queryParameters.put("$XDSDocumentEntryUniqueId", clause);
        }
        String[] assocValues = new String[relationshipTypes.length];
        int i = 0;
        while (i < relationshipTypes.length) {
            assocValues[i] = "'urn:oasis:names:tc:ebxml-regrep:AssociationType:" + relationshipTypes[i].getName() + '\'';
            ++i;
        }
        clause = String.valueOf('(') + StoredQueryBuilderUtils.buildListArgs(assocValues) + ')';
        this.queryParameters.put("$AssociationTypes", clause);
    }

    public GetRelatedDocumentsQuery(String docID, boolean isUUID, ParentDocumentRelationshipType[] relationshipTypes, String homeCommunityId) throws MalformedStoredQueryException {
        this(docID, isUUID, relationshipTypes);
        if (homeCommunityId != null && homeCommunityId.length() > 0) {
            this.homeCommunityId = homeCommunityId;
        }
    }
}

