/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.client;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClient;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientException;
import org.eclipse.ohf.ihe.atna.audit.client.IHEEventTypeCodes;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.messages.ActorStartMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.ActorStopMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.ExportMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.ImportMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.PatientRecordMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.QueryMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.UserAuthenticationMessage;
import org.eclipse.ohf.ihe.atna.audit.util.TimeStamp;

public class ATNAAuditClientImpl
implements ATNAAuditClient {
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.equals("");
    }

    private void checkInitiatingUser(String initiatingUser) throws ATNAAuditClientException {
        if (this.isNullOrEmpty(initiatingUser)) {
            logger.error((Object)"Unable to produce audit message.  The initiating user is not set.");
            throw new ATNAAuditClientException("The initiating user is not set.");
        }
    }

    public void audit(int eventOutcome, String transactionPayload) {
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        logger.info((Object)("AUDIT: " + eventOutcome + ", " + initiatingUser + ", " + transactionPayload));
    }

    public void auditQueryEvent(int eventOutcome, String registryID, String queryText) throws ATNAAuditClientException {
        this.auditQueryEvent(eventOutcome, registryID, queryText, null, null, null);
    }

    public void auditQueryEvent(int eventOutcome, String registryID, String queryText, String participantObjectId, String patientId, IHEEventTypeCodes transaction) throws ATNAAuditClientException {
        QueryMessage qMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            qMessage = new QueryMessage(TimeStamp.generateUTCDateTime(), eventOutcome, initiatingUser, null, registryID, null, participantObjectId, queryText, auditSourceId, patientId, (CodedValueType)transaction);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending QueryEvent Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)qMessage);
    }

    public void auditPHIImportEvent(int eventOutcome, String dataSourceId, String patientId, String[] importedData, IHEEventTypeCodes transaction) throws ATNAAuditClientException {
        ImportMessage iMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            iMessage = new ImportMessage(TimeStamp.generateUTCDateTime(), eventOutcome, initiatingUser, dataSourceId, patientId, importedData, auditSourceId, (CodedValueType)transaction);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PHIImportEvent Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)iMessage);
    }

    public void auditPHIExportEvent(int eventOutcome, String dataRecipientId, String exportedDataId, String patientId, String participantObjectIdTypeCode, IHEEventTypeCodes transaction) throws ATNAAuditClientException {
        ExportMessage eMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            eMessage = new ExportMessage(TimeStamp.generateUTCDateTime(), eventOutcome, initiatingUser, dataRecipientId, exportedDataId, patientId, auditSourceId, participantObjectIdTypeCode, (CodedValueType)transaction);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PHIExportEvent Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)eMessage);
    }

    public void auditActorStartEvent(int eventOutcome, String applicationName) throws ATNAAuditClientException {
        ActorStartMessage sMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            sMessage = new ActorStartMessage(TimeStamp.generateUTCDateTime(), eventOutcome, applicationName, initiatingUser, auditSourceId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending ActorStartStopMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)sMessage);
    }

    public void auditActorStopEvent(int eventOutcome, String applicationName) throws ATNAAuditClientException {
        ActorStopMessage sMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            sMessage = new ActorStopMessage(TimeStamp.generateUTCDateTime(), eventOutcome, applicationName, initiatingUser, auditSourceId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending ActorStartStopMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)sMessage);
    }

    public void auditPatientRecordReadEvent(int eventOutcome, String patientId) throws ATNAAuditClientException {
        PatientRecordMessage pMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            pMessage = new PatientRecordMessage(TimeStamp.generateUTCDateTime(), eventOutcome, "R", initiatingUser, patientId, auditSourceId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)pMessage);
    }

    public void auditPatientRecordCreateEvent(int eventOutcome, String patientId) throws ATNAAuditClientException {
        PatientRecordMessage pMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            pMessage = new PatientRecordMessage(TimeStamp.generateUTCDateTime(), eventOutcome, "C", initiatingUser, patientId, auditSourceId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)pMessage);
    }

    public void auditPatientRecordUpdateEvent(int eventOutcome, String patientId) throws ATNAAuditClientException {
        PatientRecordMessage pMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            pMessage = new PatientRecordMessage(TimeStamp.generateUTCDateTime(), eventOutcome, "U", initiatingUser, patientId, auditSourceId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)pMessage);
    }

    public void auditPatientRecordDeleteEvent(int eventOutcome, String patientId) throws ATNAAuditClientException {
        PatientRecordMessage pMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            pMessage = new PatientRecordMessage(TimeStamp.generateUTCDateTime(), eventOutcome, "D", initiatingUser, patientId, auditSourceId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)pMessage);
    }

    public void auditUserAuthenticationLoginEvent(int eventOutcome, String initiatingUserName, String initiatingUserNodeIP, String authenticatingNodeIP) throws ATNAAuditClientException {
        UserAuthenticationMessage uMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            uMessage = new UserAuthenticationMessage(TimeStamp.generateUTCDateTime(), eventOutcome, true, initiatingUser, initiatingUserName, 2, initiatingUserNodeIP, authenticatingNodeIP, auditSourceId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)uMessage);
    }

    public void auditUserAuthenticationLogoutEvent(int eventOutcome, String initiatingUserName, String initiatingUserNodeIP, String authenticatingNodeIP) throws ATNAAuditClientException {
        UserAuthenticationMessage uMessage;
        String initiatingUser = AtnaAgentFactory.getAtnaAgent().getInitiatingUser();
        this.checkInitiatingUser(initiatingUser);
        String auditSourceId = AtnaAgentFactory.getAtnaAgent().getAuditSourceId();
        try {
            uMessage = new UserAuthenticationMessage(TimeStamp.generateUTCDateTime(), eventOutcome, false, initiatingUser, initiatingUserName, 2, initiatingUserNodeIP, authenticatingNodeIP, auditSourceId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)uMessage);
    }
}

