/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.element;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.syslog.util.SyslogUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ActiveParticipantType {
    public static String DB_Active_Participant_Type = "active_participant";
    public static String DB_Role_ID = "role_id_code";
    private Element activeParticipantNode;
    protected List roleIDCode;
    protected String alternativeUserID;
    protected String networkAccessPointID;
    protected short networkAccessPointTypeCode;
    protected String userID;
    protected boolean userIsRequestor;
    protected String userName;
    private Document doc;

    public ActiveParticipantType() throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.newDocument();
        this.activeParticipantNode = this.doc.createElement("ActiveParticipant");
        this.networkAccessPointTypeCode = (short)-1;
    }

    public ActiveParticipantType(String userID) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.newDocument();
        this.activeParticipantNode = this.doc.createElement("ActiveParticipant");
        this.setUserID(userID);
        this.setUserIsRequestor(true);
    }

    public List getRoleIDCode() {
        if (this.roleIDCode == null) {
            this.roleIDCode = new ArrayList();
        }
        return this.roleIDCode;
    }

    public void setRoleIDCode(CodedValueType value) {
        if (value != null) {
            this.getRoleIDCode().add(value);
            Element eventIDElement = this.doc.createElement("RoleIDCode");
            eventIDElement.setAttribute("code", value.getCode());
            if (value.getCodeSystem() != null && !value.getCodeSystem().equals("")) {
                eventIDElement.setAttribute("codeSystem", value.getCodeSystem());
            }
            if (value.getCodeSystemName() != null && !value.getCodeSystemName().equals("")) {
                eventIDElement.setAttribute("codeSystemName", value.getCodeSystemName());
            }
            if (value.getDisplayName() != null && !value.getDisplayName().equals("")) {
                eventIDElement.setAttribute("displayName", value.getDisplayName());
            }
            this.activeParticipantNode.appendChild(eventIDElement);
        }
    }

    public String getAlternativeUserID() {
        return this.alternativeUserID;
    }

    public void setAlternativeUserID(String value) {
        this.alternativeUserID = value;
        if (value != null && !value.equals("")) {
            this.activeParticipantNode.setAttribute("AlternativeUserID", value);
        }
    }

    public String getNetworkAccessPointID() {
        return this.networkAccessPointID;
    }

    public void setNetworkAccessPointID(String value) {
        this.networkAccessPointID = value;
        if (value != null && !value.equals("")) {
            this.activeParticipantNode.setAttribute("NetworkAccessPointID", value);
        }
    }

    public short getNetworkAccessPointTypeCode() {
        return this.networkAccessPointTypeCode;
    }

    public String getNetworkAccessPointTypeName() {
        if (this.networkAccessPointTypeCode == 1) {
            return "Machine Name, including DNS name";
        }
        if (this.networkAccessPointTypeCode == 2) {
            return "IP Address";
        }
        if (this.networkAccessPointTypeCode == 3) {
            return "Telephone Number";
        }
        return null;
    }

    public void setNetworkAccessPointTypeCode(short value) throws ATNAException {
        switch (value) {
            case -1: 
            case 1: 
            case 2: 
            case 3: {
                this.networkAccessPointTypeCode = value;
                if (value != -1) {
                    this.activeParticipantNode.setAttribute("NetworkAccessPointTypeCode", new Short(value).toString());
                }
                return;
            }
        }
        throw new ATNAException("Invalid value for NetworkAccessPointTypeCode", this);
    }

    public void setNetworkAccessPointTypeCode(String value) throws ATNAException {
        this.setNetworkAccessPointTypeCode(new Short(value));
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String value) {
        this.userID = value;
        if (this.userID != null && !value.equals("")) {
            this.activeParticipantNode.setAttribute("UserID", this.userID);
        }
    }

    public boolean isUserIsRequestor() {
        return this.userIsRequestor;
    }

    public void setUserIsRequestor(boolean value) {
        this.userIsRequestor = value;
        this.activeParticipantNode.setAttribute("UserIsRequestor", this.userIsRequestor ? "true" : "false");
    }

    public void setUserIsRequestor(String value) throws ATNAException {
        if (value.equals("true")) {
            this.setUserIsRequestor(true);
        } else if (value.equals("false")) {
            this.setUserIsRequestor(false);
        } else {
            throw new ATNAException("Invalid value for UserIsRequestor", this);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String value) {
        this.userName = value;
        if (value != null && !value.equals("")) {
            this.activeParticipantNode.setAttribute("UserName", value);
        }
    }

    public String toXML() {
        return SyslogUtil.XMLElementToString(this.activeParticipantNode);
    }

    public String toHtml(int participantNumber) {
        StringBuffer stringHtml = new StringBuffer();
        int param = 1;
        stringHtml.append("<div class='Title ActiveParticipant'>Active Participant " + participantNumber + ":</div>");
        if (this.getUserID() != null && !this.getUserID().trim().equals("")) {
            stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant'>User ID : " + this.getUserID() + "</div>");
        }
        if (this.getAlternativeUserID() != null && !this.getAlternativeUserID().trim().equals("")) {
            stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant'>Alternative UserID : " + this.getAlternativeUserID() + "</div>");
        }
        if (this.getUserName() != null && !this.getUserName().trim().equals("")) {
            stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant'>User Name : " + this.getUserName() + "</div>");
        }
        stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant'>User is Requestor : " + this.isUserIsRequestor() + "</div>");
        if (this.getNetworkAccessPointID() != null && !this.getNetworkAccessPointID().trim().equals("")) {
            stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant'>Network Access PointID : " + this.getNetworkAccessPointID() + "</div>");
        }
        if (this.getNetworkAccessPointTypeCode() != -1) {
            stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant'>Network Access PointCode : " + this.getNetworkAccessPointTypeCode() + "</div>");
        }
        int i = 0;
        while (this.getRoleIDCode() != null && i < this.getRoleIDCode().size()) {
            CodedValueType valueType = (CodedValueType)this.getRoleIDCode().get(i);
            if (valueType != null) {
                stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant RoleIDCode'>Role ID Code code : " + valueType.getCode() + "</div>");
                if (valueType.getCodeSystem() != null && !valueType.getCodeSystem().trim().equals("")) {
                    stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant RoleIDCode'>Code System :" + valueType.getCodeSystem() + "</div>");
                }
                if (valueType.getCodeSystemName() != null && !valueType.getCodeSystemName().trim().equals("")) {
                    stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant RoleIDCode'>Code System Name:" + valueType.getCodeSystemName() + "</div>");
                }
                if (valueType.getDisplayName() != null && !valueType.getDisplayName().trim().equals("")) {
                    stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant RoleIDCode'>Code Display Name:" + valueType.getDisplayName() + "</div>");
                }
                if (valueType.getOriginalText() != null && !valueType.getCodeSystem().trim().equals("")) {
                    stringHtml.append("<div class='ActiveParticipant_param" + param++ + " ActiveParticipant RoleIDCode'>Original Text:" + valueType.getOriginalText() + "</div>");
                }
            }
            ++i;
        }
        return stringHtml.toString();
    }

    public Element getActiveParticipantNode() {
        return this.activeParticipantNode;
    }

    public static boolean isValidElement(Element el) {
        if (el.getNodeName().equals("ActiveParticipant")) {
            return !el.getAttribute("UserID").equals("");
        }
        return false;
    }

    public void parse(Element el) throws ATNAException {
        if (ActiveParticipantType.isValidElement(el)) {
            this.setUserID(el.getAttribute("UserID"));
            if (el.getAttribute("UserIsRequestor") != "") {
                this.setUserIsRequestor(el.getAttribute("UserIsRequestor"));
            }
            if (el.getAttribute("AlternativeUserID") != "") {
                this.setAlternativeUserID(el.getAttribute("AlternativeUserID"));
            }
            if (el.getAttribute("UserName") != "") {
                this.setUserName(el.getAttribute("UserName"));
            }
            if (el.getAttribute("NetworkAccessPointID") != "") {
                this.setNetworkAccessPointID(el.getAttribute("NetworkAccessPointID"));
            }
            if (el.getAttribute("NetworkAccessPointTypeCode") != "") {
                this.setNetworkAccessPointTypeCode(el.getAttribute("NetworkAccessPointTypeCode"));
            }
            NodeList list = el.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Element childElement;
                if (list.item(i).getNodeType() == 1 && (childElement = (Element)list.item(i)).getNodeName().equals("RoleIDCode")) {
                    CodedValueType value = new CodedValueType();
                    value.parse(childElement);
                    this.setRoleIDCode(value);
                }
                ++i;
            }
        }
    }
}

