/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditActiveParticipantRoleID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.ParticipantObjectIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.util.AddressUtils;

public class ExportMessage
extends AuditMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ExportMessage(String eventDateTime, int eventOutcomeIndicator, String userIDActiveParticipantExporter, String userIDActiveParticipantDestination, String participantObjectStudyInstanceUID, String participantObjectPatientId, String sourceId) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this(eventDateTime, eventOutcomeIndicator, userIDActiveParticipantExporter, userIDActiveParticipantDestination, participantObjectStudyInstanceUID, participantObjectPatientId, sourceId, null, null);
    }

    public ExportMessage(String eventDateTime, int eventOutcomeIndicator, String userIDActiveParticipantExporter, String userIDActiveParticipantDestination, String participantObjectStudyInstanceUID, String participantObjectPatientId, String sourceId, String patricipantObjectTypeCode, CodedValueType transaction) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        super(sourceId);
        EventIdentificationType eventId = new EventIdentificationType(0);
        eventId.setEventActionCode("R");
        eventId.setEventID(new AuditEventID.Export());
        eventId.setEventDateTime(eventDateTime);
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        if (transaction != null) {
            eventId.setEventTypeCode(transaction);
        }
        this.setEventIdentification(eventId);
        ActiveParticipantType activeParticipantDestination = null;
        activeParticipantDestination = new ActiveParticipantType(userIDActiveParticipantDestination);
        activeParticipantDestination.setUserIsRequestor(false);
        activeParticipantDestination.setRoleIDCode(new AuditActiveParticipantRoleID.Destination());
        AddressUtils.setNetworkAccessPointCodes(activeParticipantDestination, AddressUtils.getRemoteAddressByURL(userIDActiveParticipantDestination));
        this.setActiveParticipant(activeParticipantDestination);
        ActiveParticipantType activeParticipantExporter = null;
        activeParticipantExporter = new ActiveParticipantType(userIDActiveParticipantExporter);
        activeParticipantExporter.setUserIsRequestor(true);
        activeParticipantExporter.setRoleIDCode(new AuditActiveParticipantRoleID.Source());
        AddressUtils.setNetworkAccessPointCodes(activeParticipantExporter, AddressUtils.getLocalAddress());
        this.setActiveParticipant(activeParticipantExporter);
        ParticipantObjectIdentificationType participantObjectPatient = new ParticipantObjectIdentificationType();
        participantObjectPatient.setParticipantObjectTypeCode((short)1);
        participantObjectPatient.setParticipantObjectTypeCodeRoleName("patient");
        CodedValueType value2 = new CodedValueType();
        value2.setCode("2");
        participantObjectPatient.setParticipantObjectIDTypeCode(value2);
        participantObjectPatient.setParticipantObjectID(participantObjectPatientId);
        this.setParticipationObjectIdentification(participantObjectPatient);
        ParticipantObjectIdentificationType participantObjectStudyUID = new ParticipantObjectIdentificationType();
        participantObjectStudyUID.setParticipantObjectTypeCode((short)2);
        participantObjectStudyUID.setParticipantObjectTypeCodeRoleName("job");
        CodedValueType value3 = new CodedValueType();
        value3.setCode(patricipantObjectTypeCode);
        participantObjectStudyUID.setParticipantObjectIDTypeCode(value3);
        participantObjectStudyUID.setParticipantObjectID(participantObjectStudyInstanceUID);
        this.setParticipationObjectIdentification(participantObjectStudyUID);
    }

    public ExportMessage() throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this.setMessagetype("export");
        if (this.getEventIdentification() != null) {
            this.getEventIdentification().setEventActionCode("R");
            CodedValueType eventIDValue = new CodedValueType();
            eventIDValue.setCode("110106");
            eventIDValue.setCodeSystemName("DCM");
            eventIDValue.setDisplayName("Export");
            this.getEventIdentification().setEventID(eventIDValue);
        }
    }
}

