/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URI;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.codes.SecurityAlertTypeCode;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.ParticipantObjectIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.TypeValuePairType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.util.AddressUtils;
import org.eclipse.ohf.ihe.atna.audit.util.TimeStamp;

public class NodeAuthenticationFailureMessage
extends AuditMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public NodeAuthenticationFailureMessage(int eventOutcomeIndicator, String reportingUserID, String reportingActor, URI failedURI, String failureDescription, String sourceId) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        super(sourceId);
        EventIdentificationType eventId = new EventIdentificationType(0);
        eventId.setEventActionCode("E");
        eventId.setEventID(new AuditEventID.SecurityAlert());
        eventId.setEventTypeCode(new SecurityAlertTypeCode.NodeAuthentication());
        eventId.setEventDateTime(TimeStamp.generateUTCDateTime());
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        this.setEventIdentification(eventId);
        ActiveParticipantType reportingUser = new ActiveParticipantType(reportingUserID);
        reportingUser.setUserIsRequestor(true);
        AddressUtils.setNetworkAccessPointCodes(reportingUser, AddressUtils.getLocalAddress());
        this.setActiveParticipant(reportingUser);
        ActiveParticipantType activeParticipant = new ActiveParticipantType(reportingActor);
        activeParticipant.setUserIsRequestor(false);
        this.setActiveParticipant(activeParticipant);
        ParticipantObjectIdentificationType participantObject = new ParticipantObjectIdentificationType();
        participantObject.setParticipantObjectTypeCode((short)2);
        participantObject.setParticipantObjectTypeCodeRole((short)13);
        CodedValueType code = new CodedValueType();
        code.setCode("12");
        participantObject.setParticipantObjectIDTypeCode(code);
        participantObject.setParticipantObjectID(failedURI.toASCIIString());
        TypeValuePairType participantObjectDetail = new TypeValuePairType();
        participantObjectDetail.setType("Alert Description");
        participantObjectDetail.setValue(failureDescription.getBytes());
        participantObject.setParticipantObjectDetail(participantObjectDetail);
        this.setParticipationObjectIdentification(participantObject);
    }
}

